/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.IVariableLabelProviderFactory;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.context.IModelContext;

class VariableLabelProviderFactoryReader {
    private static final String EXT_PT = "variableLabelProviderFactory";
    private static final String PRIORITY_ATTR = "priority";
    private static final String CLASS_ATTR = "class";
    private static List<IVariableLabelProviderFactory> _factories;

    private VariableLabelProviderFactoryReader() {
        throw new IllegalStateException("Should not be instantiated!");
    }

    public static ImageDescriptor getImageDescriptor(VariableGroup group, IModelContext context) {
        for (IVariableLabelProviderFactory factory : VariableLabelProviderFactoryReader.getAllFactories()) {
            if (!factory.isFactoryFor(group)) continue;
            return factory.getImageDescriptor(group, context);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(ValueReference ref, IModelContext context) {
        for (IVariableLabelProviderFactory factory : VariableLabelProviderFactoryReader.getAllFactories()) {
            if (!factory.isFactoryFor(ref)) continue;
            return factory.getImageDescriptor(ref, context);
        }
        return null;
    }

    private static synchronized List<IVariableLabelProviderFactory> getAllFactories() {
        if (_factories == null) {
            _factories = VariableLabelProviderFactoryReader.readAllFactories();
        }
        return Collections.unmodifiableList(_factories);
    }

    private static List<IVariableLabelProviderFactory> readAllFactories() {
        TreeSet<FactoryDescriptor> descriptors = new TreeSet<FactoryDescriptor>(new FactoryDescriptorComparator());
        Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.webtier.ui", (String)EXT_PT);
        for (IExtension ext : extensions) {
            IConfigurationElement[] tagElementConfig;
            IConfigurationElement[] iConfigurationElementArray = tagElementConfig = ext.getConfigurationElements();
            int n = tagElementConfig.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String p = element.getAttribute(PRIORITY_ATTR);
                    int priority = VariableLabelProviderFactoryReader.convertToInt(p);
                    IVariableLabelProviderFactory factory = (IVariableLabelProviderFactory)element.createExecutableExtension(CLASS_ATTR);
                    FactoryDescriptor descriptor = new FactoryDescriptor(priority, factory);
                    descriptors.add(descriptor);
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                }
                ++n2;
            }
        }
        ArrayList<IVariableLabelProviderFactory> factories = new ArrayList<IVariableLabelProviderFactory>(descriptors.size());
        for (FactoryDescriptor descriptor : descriptors) {
            factories.add(descriptor.getFactory());
        }
        return factories;
    }

    private static int convertToInt(String intString) {
        if (intString == null || intString.trim().length() == 0) {
            return Integer.MAX_VALUE;
        }
        intString = intString.trim();
        try {
            return Integer.valueOf(intString);
        }
        catch (NumberFormatException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return Integer.MAX_VALUE;
        }
    }

    private static class FactoryDescriptor {
        private final int _priority;
        private final IVariableLabelProviderFactory _factory;

        FactoryDescriptor(int priority, IVariableLabelProviderFactory factory) {
            this._priority = priority;
            this._factory = factory;
        }

        public int getPriority() {
            return this._priority;
        }

        public IVariableLabelProviderFactory getFactory() {
            return this._factory;
        }
    }

    private static class FactoryDescriptorComparator
    implements Comparator<FactoryDescriptor> {
        private FactoryDescriptorComparator() {
        }

        @Override
        public int compare(FactoryDescriptor fd0, FactoryDescriptor fd1) {
            return fd0.getPriority() - fd1.getPriority();
        }
    }
}

