/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.ValueReferenceTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.PossibleVariablesMatcher;

class UnpackVarGroupTreeContentProvider
extends ValueReferenceTreeContentProvider {
    private final List<String> _toUnpack;

    public UnpackVarGroupTreeContentProvider(IFilePositionContext context, PossibleVariablesMatcher possibleVariablesMatcher, List<String> toUnpack) {
        super(context, possibleVariablesMatcher);
        this._toUnpack = new ArrayList<String>(toUnpack);
    }

    public UnpackVarGroupTreeContentProvider(IFilePositionContext context, List<String> toUnpack) {
        super(context);
        this._toUnpack = new ArrayList<String>(toUnpack);
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        Object[] children = super.getChildren(parentElement);
        return this.unpackManagedBeanVarGroup(children);
    }

    @Override
    public Object[] getElements(Object inputElement) {
        Object[] elements = super.getElements(inputElement);
        return this.unpackManagedBeanVarGroup(elements);
    }

    private Object[] unpackManagedBeanVarGroup(Object[] objects) {
        ArrayList<Object> unpacked = new ArrayList<Object>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof VariableGroup) {
                VariableGroup vg = (VariableGroup)object;
                for (String match : this._toUnpack) {
                    if (match.equals(vg.getLabel())) {
                        unpacked.addAll(vg.getValueReferences());
                        continue;
                    }
                    unpacked.add(vg);
                }
            } else {
                unpacked.add(object);
            }
            ++n2;
        }
        return unpacked.toArray(new Object[unpacked.size()]);
    }
}

