/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.pagedesigner.commands.SourceViewerCommand;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class NewArtificialVariableCommand
extends SourceViewerCommand {
    private Comment _element;
    private int _location;
    private ArtificialVariableProvider _artificialVarProvider;

    public NewArtificialVariableCommand(StructuredTextEditor editor, String varName, String varType) {
        super(Messages.NewArtificialVariableCommand_label, editor);
        this._artificialVarProvider = new ArtificialVariableProvider(varName, varType);
        this._location = editor.getTextViewer().getTextWidget().getCaretOffset();
    }

    public void doExecute() {
        Node node = this.getPosition();
        Comment element = this.getModel().getDocument().createComment(this._artificialVarProvider.createVariable());
        if (element != null && node != null) {
            this.addToContainerNode(element, node);
            this.formatNode(element);
        }
        this._element = element;
    }

    private void addToContainerNode(Comment element, Node position) {
        try {
            switch (position.getNodeType()) {
                case 3: {
                    if (position.getNextSibling() == null) {
                        if (position.getParentNode().getChildNodes().getLength() > 0) {
                            position.getParentNode().insertBefore(element, position.getParentNode().getChildNodes().item(0));
                            break;
                        }
                        position.getParentNode().appendChild(element);
                        break;
                    }
                    position.getParentNode().insertBefore(element, position.getNextSibling());
                    break;
                }
                case 8: {
                    position.getParentNode().appendChild(element);
                    break;
                }
                case 1: {
                    if (position.getChildNodes().getLength() > 0) {
                        position.insertBefore(element, position.getChildNodes().item(0));
                        break;
                    }
                    position.appendChild(element);
                }
            }
        }
        catch (DOMException dOMException) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.NewArtificialVariableCommand_dialogTitle, (String)Messages.NewArtificialVariableCommand_dialogMsg);
        }
    }

    private Node getPosition() {
        Node node;
        try {
            node = this.getSourceEditingTextTools().getNode(this._location);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e, (String)"Bad artificial variable insertion location.");
            return null;
        }
        return node;
    }

    public void setSelection() {
        if (this._element != null) {
            int offset = EditModelQuery.getNodeStartIndex((Node)this._element);
            int length = EditModelQuery.getNodeEndIndex((Node)this._element) - offset;
            this._editor.getTextViewer().setSelectedRange(offset, length);
        }
    }

    private static class ArtificialVariableProvider {
        private String _varName;
        private String _varType;

        ArtificialVariableProvider(String varName, String varType) {
            this._varName = varName;
            this._varType = varType;
        }

        public String createVariable() {
            StringBuffer buf = new StringBuffer(" <oepe:var ");
            buf.append("name=").append("\"");
            buf.append(this._varName).append("\" ");
            buf.append("type=").append("\"");
            buf.append(this._varType).append("\" /> ");
            return buf.toString();
        }
    }
}

