/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.context.IModelContext;

public class MethodViewFilter
extends ViewerFilter {
    protected final List<MethodReference> _acceptedSignatures;

    public MethodViewFilter(List<MethodReference> acceptedSignatures) {
        this._acceptedSignatures = new ArrayList<MethodReference>(acceptedSignatures);
    }

    protected boolean hasMethodSignatures() {
        return this._acceptedSignatures != null && this._acceptedSignatures.size() > 0;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof VariableGroup) {
            return true;
        }
        if (element instanceof ValueReference) {
            ValueReference valRef = (ValueReference)element;
            IModelContext context = DataType.NullModelContext.getInstance();
            if (this.hasMethodSignatures()) {
                return valRef.getType(context).mightHaveFields(context) || valRef.getType(context).getPublicMethods().size() > 0;
            }
            return valRef.getType(context).getPublicMethods().size() > 0;
        }
        if (element instanceof MethodReference) {
            return this.handlesSignature((MethodReference)element);
        }
        return true;
    }

    protected boolean handlesSignature(VariableGroup varGroup) {
        for (ValueReference valRef : varGroup.getValueReferences()) {
            if (!this.handlesSignature(valRef)) continue;
            return true;
        }
        return false;
    }

    protected boolean handlesSignature(ValueReference valRef) {
        for (MethodReference methodRef : valRef.getMethodReferences()) {
            if (!this.handlesSignature(methodRef)) continue;
            return true;
        }
        return false;
    }

    protected boolean handlesSignature(MethodReference methodRef) {
        if (this.hasMethodSignatures()) {
            for (MethodReference acceptedSignature : this._acceptedSignatures) {
                if (!acceptedSignature.matchesSignature(methodRef)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

