/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal.palette.model.variable;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IVariablesListener;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.PossibleMethodVariablesMatcher;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class MethodReferenceTreeContentProvider
extends VariablesTreeContentProvider
implements IVariablesListener {
    private StructuredViewer _viewer;
    private ISelectionUpdater _selectionUpdater;

    public MethodReferenceTreeContentProvider() {
        super(new PossibleMethodVariablesMatcher(false, true, false));
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof MethodReference) {
            return ((MethodReference)element).getValueReference();
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ValueReference) {
            ArrayList children = new ArrayList();
            ValueReference valRef = (ValueReference)parentElement;
            children.addAll(valRef.getChildFields(DataType.NullModelContext.getInstance()));
            children.addAll(valRef.getMethodReferences());
            return children.toArray(new Object[children.size()]);
        }
        if (parentElement instanceof MethodReference) {
            return null;
        }
        return super.getChildren(parentElement);
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof ValueReference) {
            ValueReference valRef = (ValueReference)element;
            List fields = valRef.getChildFields(DataType.NullModelContext.getInstance());
            List methods = valRef.getMethodReferences();
            if (this._viewer == null) {
                return fields.size() > 0 | methods.size() > 0;
            }
            boolean anyFieldPassesFilters = this.anyChildPassesFilters(valRef, fields);
            if (anyFieldPassesFilters) {
                return true;
            }
            boolean anyMethodPassesFilters = this.anyChildPassesFilters(valRef, methods);
            return anyMethodPassesFilters;
        }
        return !(element instanceof MethodReference);
    }

    private boolean anyChildPassesFilters(Object parent, List<? extends Object> children) {
        for (Object object : children) {
            boolean madeItThroughAllFilters = true;
            ViewerFilter[] viewerFilterArray = this._viewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (!filter.select((Viewer)this._viewer, parent, object)) {
                    madeItThroughAllFilters = false;
                    break;
                }
                ++n2;
            }
            if (!madeItThroughAllFilters) continue;
            return true;
        }
        return false;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this._viewer = (StructuredViewer)viewer;
        if (oldInput != null) {
            ((VariablesModel)oldInput).removeListener(this);
        }
        if (newInput != null) {
            ((VariablesModel)newInput).addListener(this);
        }
    }

    public void refresh(IVariablesListener.VariableChangeEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Control control = MethodReferenceTreeContentProvider.this._viewer.getControl();
                if (control != null && !control.isDisposed()) {
                    MethodReferenceTreeContentProvider.this._viewer.refresh(false);
                    if (MethodReferenceTreeContentProvider.this._selectionUpdater != null) {
                        MethodReferenceTreeContentProvider.this._selectionUpdater.update();
                    }
                }
            }
        });
    }

    public void setSelectionUpdater(ISelectionUpdater updater) {
        this._selectionUpdater = updater;
    }

    public static interface ISelectionUpdater {
        public void update();
    }
}

