/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal;

import oracle.eclipse.tools.application.common.services.appservices.IDesignTimeLocaleService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import oracle.eclipse.tools.webtier.ui.wpe.WPEUpdateListener;
import oracle.eclipse.tools.webtier.ui.wpe.WPEUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.osgi.service.prefs.BackingStoreException;

public class WebtierUIStartup
implements IStartup {
    private static final String CTYPE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String CTYPE_JSPFRAGMENTSOURCE = "org.eclipse.jst.jsp.core.jspfragmentsource";
    private static final String PAGE_DESIGNER_EDITOR_ID = "org.eclipse.jst.pagedesigner.PageDesignerEditor";
    private static final String MADE_WPE_DEFAULT_EDITOR_KEY = "madeWPEDefaultEditor";

    public void earlyStartup() {
        IDesignTimeLocaleService.GlobalLocaleListeners.addGlobalLocaleListener((IDesignTimeLocaleService.ICurrentLocaleListener)new DesignTimeLocaleListener());
        final WPEUpdateListener listener = new WPEUpdateListener();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] pages;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference[] editorReferences;
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                        int n5 = editorReferences.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            listener.maybeAdd(editorReference);
                            ++n6;
                        }
                        ++n4;
                    }
                    window.getPartService().addPartListener((IPartListener2)listener);
                    ++n2;
                }
                PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowActivated(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                        window.getPartService().removePartListener((IPartListener2)listener);
                    }

                    public void windowOpened(IWorkbenchWindow window) {
                        window.getPartService().addPartListener((IPartListener2)listener);
                    }
                });
            }
        });
        this.makeWPEDefaultEditor();
    }

    private void makeWPEDefaultEditor() {
        IWorkbench workbench;
        IPreferencesService service = Platform.getPreferencesService();
        if (!service.getBoolean("oracle.eclipse.tools.webtier.ui", MADE_WPE_DEFAULT_EDITOR_KEY, false, null) && (workbench = PlatformUI.getWorkbench()) != null) {
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.associateJsffFileExtensionWithWpe();
                    }
                    catch (CoreException e) {
                        LoggingService.logError((String)"oracle.eclipse.tools.webtier.ui", (String)e.getLocalizedMessage());
                    }
                    this.setDefaultEditorForExt(WebtierUIStartup.CTYPE_JSPSOURCE);
                    this.setDefaultEditorForExt(WebtierUIStartup.CTYPE_JSPFRAGMENTSOURCE);
                    this.setDefaultEditorForExt(ContentTypeIdForHTML.ContentTypeID_HTML);
                    this.saveDefaultEditors();
                    IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.webtier.ui");
                    prefs.putBoolean(WebtierUIStartup.MADE_WPE_DEFAULT_EDITOR_KEY, true);
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException bse) {
                        LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)bse);
                    }
                }

                private void setDefaultEditorForExt(String contentTypeId) {
                    IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                    IContentType contentType = contentTypeManager.getContentType(contentTypeId);
                    String[] fileSpecs = contentType.getFileSpecs(8);
                    IEditorRegistry editorRegistry = workbench.getEditorRegistry();
                    String[] stringArray = fileSpecs;
                    int n = fileSpecs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileSpec = stringArray[n2];
                        editorRegistry.setDefaultEditor("*." + fileSpec, WebtierUIStartup.PAGE_DESIGNER_EDITOR_ID);
                        ++n2;
                    }
                }

                private void saveDefaultEditors() {
                    EditorRegistry registry = (EditorRegistry)workbench.getEditorRegistry();
                    FileEditorMapping[] mappings = (FileEditorMapping[])registry.getFileEditorMappings();
                    registry.setFileEditorMappings(mappings);
                    registry.saveAssociations();
                    IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui.workbench");
                    try {
                        preferences.flush();
                    }
                    catch (BackingStoreException bse) {
                        LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)bse);
                    }
                }

                private void associateJsffFileExtensionWithWpe() throws CoreException {
                    IContentType jspfContentType = Platform.getContentTypeManager().getContentType(WebtierUIStartup.CTYPE_JSPFRAGMENTSOURCE);
                    jspfContentType.addFileSpec("jsff", 8);
                    EditorRegistry editorRegistry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
                    IEditorDescriptor wpe = editorRegistry.findEditor(WebtierUIStartup.PAGE_DESIGNER_EDITOR_ID);
                    FileEditorMapping newType = new FileEditorMapping("jsff");
                    newType.setDefaultEditor((EditorDescriptor)wpe);
                    IFileEditorMapping[] oldMap = editorRegistry.getFileEditorMappings();
                    FileEditorMapping[] newMap = new FileEditorMapping[oldMap.length + 1];
                    int i = 0;
                    while (i < oldMap.length) {
                        newMap[i] = (FileEditorMapping)oldMap[i];
                        ++i;
                    }
                    newMap[oldMap.length] = newType;
                    editorRegistry.setFileEditorMappings(newMap);
                    editorRegistry.saveAssociations();
                }
            });
        }
    }

    private static class DesignTimeLocaleListener
    implements IDesignTimeLocaleService.ICurrentLocaleListener {
        private DesignTimeLocaleListener() {
        }

        public void localeChanged(IDesignTimeLocaleService.CurrentLocaleUpdateEvent event) {
            final IProject project = event.getAffectedProject();
            final IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow[] workbenchWindows;
                    IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = workbench.getWorkbenchWindows();
                    int n = workbenchWindows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                        int n3 = iWorkbenchPageArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IEditorReference[] editorReferences;
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                            int n5 = editorReferences.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IEditorReference ref = iEditorReferenceArray[n6];
                                try {
                                    IFile file;
                                    IEditorPart editorPart = ref.getEditor(false);
                                    IEditorInput editorInput = ref.getEditorInput();
                                    if (editorPart instanceof HTMLEditor && editorInput instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()) != null && file.isAccessible() && file.getProject().equals((Object)project)) {
                                        new WPEUtil().refreshWPEDesignPane(editorPart);
                                    }
                                }
                                catch (PartInitException e) {
                                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

