/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.webtier.ui.internal.IWPEEvent;
import oracle.eclipse.tools.webtier.ui.internal.IWPEOpenCloseListener;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class WPEOpenCloseNotifier
implements IPartListener2 {
    private static final String ANY_WPE = "_any_wpe_";
    private Map<Object, List<IWPEOpenCloseListener>> _listenerMap = new HashMap<Object, List<IWPEOpenCloseListener>>();

    WPEOpenCloseNotifier() {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        HTMLEditor ed = this.extractEditor(partRef);
        if (ed != null) {
            this.notifyEditorClosed(ed);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        HTMLEditor ed = this.extractEditor(partRef);
        if (ed != null) {
            this.notifyEditorOpened(ed);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        HTMLEditor ed = this.extractEditor(partRef);
        if (ed != null) {
            this.notifyEditorActivated(ed);
        }
    }

    private void notifyEditorOpened(HTMLEditor ed) {
        WPEEvent ev = new WPEEvent(ed, IWPEEvent.EventType.OPENED);
        this.notifyListeners(ev, ed.getEditorInput());
    }

    private void notifyEditorActivated(HTMLEditor ed) {
        WPEEvent ev = new WPEEvent(ed, IWPEEvent.EventType.ACTIVATED);
        this.notifyListeners(ev, ed.getEditorInput());
    }

    private void notifyEditorClosed(HTMLEditor ed) {
        WPEEvent ev = new WPEEvent(ed, IWPEEvent.EventType.CLOSED);
        this.notifyListeners(ev, ed.getEditorInput());
    }

    private void notifyListeners(IWPEEvent ev, IEditorInput page) {
        List<IWPEOpenCloseListener> listeners = this.getListeners(page);
        if (listeners != null) {
            for (IWPEOpenCloseListener listener : listeners) {
                listener.notify(ev);
            }
        }
    }

    private List<IWPEOpenCloseListener> getListeners(IEditorInput page) {
        List<IWPEOpenCloseListener> anyEditorListeners;
        ArrayList<IWPEOpenCloseListener> ret = new ArrayList<IWPEOpenCloseListener>();
        List<IWPEOpenCloseListener> listeners = this._listenerMap.get(page);
        if (listeners != null) {
            ret.addAll(listeners);
        }
        if ((anyEditorListeners = this._listenerMap.get(ANY_WPE)) != null) {
            ret.addAll(anyEditorListeners);
        }
        return ret;
    }

    public void dispose() {
        this._listenerMap.clear();
        this._listenerMap = null;
    }

    public void addListener(IWPEOpenCloseListener listener, IEditorInput page) {
        List<IWPEOpenCloseListener> listeners;
        Object key = page;
        if (page == null) {
            key = ANY_WPE;
        }
        if ((listeners = this._listenerMap.get(key)) == null) {
            listeners = new CopyOnWriteArrayList<IWPEOpenCloseListener>();
            this._listenerMap.put(key, listeners);
        }
        listeners.add(listener);
    }

    public void removeListener(IWPEOpenCloseListener listener, IEditorInput page) {
        List<IWPEOpenCloseListener> listeners;
        Object key = page;
        if (page == null) {
            key = ANY_WPE;
        }
        if ((listeners = this._listenerMap.get(key)) != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this._listenerMap.remove(key);
            }
        }
    }

    private HTMLEditor extractEditor(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof HTMLEditor) {
            return (HTMLEditor)part;
        }
        return null;
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    private static class WPEEvent
    implements IWPEEvent {
        private HTMLEditor _ed;
        private IWPEEvent.EventType _type;

        WPEEvent(HTMLEditor ed, IWPEEvent.EventType type) {
            this._ed = ed;
            this._type = type;
        }

        @Override
        public IWPEEvent.EventType getEventType() {
            return this._type;
        }

        @Override
        public HTMLEditor getWPEInstance() {
            return this._ed;
        }
    }
}

