/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.internal;

import java.io.IOException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.internal.IWPEOpenCloseListener;
import oracle.eclipse.tools.webtier.ui.internal.WPEOpenCloseNotifier;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContextType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.webtier.ui";
    private static Activator plugin;
    private TemplateStore _templateStore;
    private ContextTypeRegistry _contextTypeRegistry;
    private IWindowListener _windowListener;
    private WPEOpenCloseNotifier _wpeOpenCloseListener;
    private static final String OPEN_TYPE_NAME = "/icons/small/opentype.gif";
    private static final String OPEN_DECLARATION_NAME = "/icons/small/goto-src.gif";
    private static final String DROP_WIZARD_BANNER_NAME = "icons/wizard/DropNewTag.gif";
    private static final String CATEGORY_ICON_NAME = "icons/small/var-view.gif";
    private static final String MANAGED_BEANS_ICON_NAME = "icons/small/managed-beans-view.gif";
    private static final String DATA_CONTROLS_ICON_NAME = "icons/small/data-control-view.gif";
    private static final String DEFAULT_TAGLIB_ICON_NAME = "icons/small/taglib-view.gif";
    private static final String PAGE_VAR_ICON_NAME = "icons/small/page-var.gif";
    private static final String FIELD_ICON_NAME = "icons/small/var-field.gif";
    private static final String METHOD_ICON_NAME = "icons/small/var-meth.gif";
    private static final String SCRIPT_VAR_ICON_NAME = "icons/small/script-var.gif";
    private static final String X_REQUEST_VAR_ICON_NAME = "icons/small/external-request-var.gif";
    private static final String X_SESSION_VAR_ICON_NAME = "icons/small/external-session-var.gif";
    private static final String X_APP_VAR_ICON_NAME = "icons/small/external-app-var.gif";
    private static final String X_VIEW_VAR_ICON_NAME = "icons/small/external-view-var.png";
    private static final String X_BBEAN_VAR_ICON_NAME = "icons/small/external-bbean-var.png";
    private static final String X_PAGEFLOW_VAR_ICON_NAME = "icons/small/external-pageflow-var.png";
    private static final String PAGE_VARIABLES_ICON_NAME = "icons/small/valref-edit.gif";
    private static final String CLEAR_FILTER_ICON_NAME = "icons/small/clear-filter.gif";
    private static final String PALETTE_MAXIMIZE_ICON_NAME = "icons/small/thin_max_view.gif";
    private static final String PALETTE_RESTORE_ICON_NAME = "icons/small/thin_restore_view.gif";
    private static final String NEW_PROJECT_WIZARD_BANNER_NAME = "icons/wizard/war_wiz.gif";
    private static final String VARS_TAB_ICON_NAME = "icons/small/vars-tab.gif";
    private static final String RSCS_TAB_ICON_NAME = "icons/small/rscs-tab.gif";
    private static final String ADD_ICON_NAME = "icons/small/add-button.png";
    private static final String MOVEUP_ICON_NAME = "icons/small/move-up.png";
    private static final String MOVEDOWN_ICON_NAME = "icons/small/move-down.png";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.startWPEOpenCloseListening();
        this.getPreferenceStore().setDefault("oracle.eclipse.tools.adf.view.auto_generate_ids", true);
    }

    public void stop(BundleContext context) throws Exception {
        this.stopWPEOpenCloseListening();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Images[] imagesArray = Images.values();
        int n = imagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Images img = imagesArray[n2];
            img.init(reg);
            ++n2;
        }
    }

    public static void log(int severity, String message, Throwable ex) {
        ILog log = Activator.getDefault().getLog();
        Status status = new Status(severity, PLUGIN_ID, message, ex);
        log.log((IStatus)status);
    }

    public static void logError(String message, Throwable ex) {
        Activator.log(4, message, ex);
    }

    public TemplateStore getTemplateStore() {
        if (this._templateStore == null) {
            this._templateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), "");
            try {
                this._templateStore.load();
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)ioe);
            }
        }
        return this._templateStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this._contextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType((TemplateContextType)new CodeTemplateContextType("methodbody_context"));
            this._contextTypeRegistry = registry;
        }
        return this._contextTypeRegistry;
    }

    private void startWPEOpenCloseListening() {
        this._wpeOpenCloseListener = new WPEOpenCloseNotifier();
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            this._windowListener = new IWindowListener(){

                public void windowActivated(IWorkbenchWindow window) {
                    if (Activator.this._wpeOpenCloseListener != null) {
                        window.getPartService().addPartListener((IPartListener2)Activator.this._wpeOpenCloseListener);
                    }
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                    if (Activator.this._wpeOpenCloseListener != null) {
                        window.getPartService().removePartListener((IPartListener2)Activator.this._wpeOpenCloseListener);
                    }
                }

                public void windowOpened(IWorkbenchWindow window) {
                    window.getPartService().addPartListener((IPartListener2)Activator.this._wpeOpenCloseListener);
                }
            };
            workbench.addWindowListener(this._windowListener);
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.getPartService().addPartListener((IPartListener2)this._wpeOpenCloseListener);
                ++n2;
            }
        }
    }

    private void stopWPEOpenCloseListening() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            if (this._windowListener != null) {
                workbench.removeWindowListener(this._windowListener);
                this._windowListener = null;
            }
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.getPartService().removePartListener((IPartListener2)this._wpeOpenCloseListener);
                ++n2;
            }
        }
        if (this._wpeOpenCloseListener != null) {
            this._wpeOpenCloseListener.dispose();
            this._wpeOpenCloseListener = null;
        }
    }

    public void addWPEOpenCloseListener(IWPEOpenCloseListener listener, IEditorInput page) {
        if (this._wpeOpenCloseListener != null) {
            this._wpeOpenCloseListener.addListener(listener, page);
        }
    }

    public void removeWPEOpenCloseListener(IWPEOpenCloseListener listener, IEditorInput page) {
        if (this._wpeOpenCloseListener != null) {
            this._wpeOpenCloseListener.removeListener(listener, page);
        }
    }

    public static enum Images {
        DROP_WIZARD_BANNER("icons/wizard/DropNewTag.gif"),
        OPEN_TYPE("/icons/small/opentype.gif"),
        OPEN_DECLARATION("/icons/small/goto-src.gif"),
        CATEGORY_ICON("icons/small/var-view.gif"),
        MANAGED_BEANS_ICON("icons/small/managed-beans-view.gif"),
        DATA_CONTROLS_ICON("icons/small/data-control-view.gif"),
        DEFAULT_TAGLIB_ICON("icons/small/taglib-view.gif"),
        PAGE_VAR_ICON("icons/small/page-var.gif"),
        FIELD_ICON("icons/small/var-field.gif"),
        METHOD_ICON("icons/small/var-meth.gif"),
        SCRIPT_VAR_ICON("icons/small/script-var.gif"),
        X_REQUEST_VAR_ICON("icons/small/external-request-var.gif"),
        X_SESSION_VAR_ICON("icons/small/external-session-var.gif"),
        X_APP_VAR_ICON("icons/small/external-app-var.gif"),
        X_VIEW_VAR_ICON("icons/small/external-view-var.png"),
        X_BBEAN_VAR_ICON("icons/small/external-bbean-var.png"),
        X_PAGEFLOW_VAR_ICON("icons/small/external-pageflow-var.png"),
        PAGE_VARIABLES_ICON("icons/small/valref-edit.gif"),
        CLEAR_FILTER_ICON("icons/small/clear-filter.gif"),
        PALETTE_MAXIMIZE_ICON("icons/small/thin_max_view.gif"),
        PALETTE_RESTORE_ICON("icons/small/thin_restore_view.gif"),
        NEW_PROJECT_WIZARD_BANNER("icons/wizard/war_wiz.gif"),
        VARS_TAB_ICON("icons/small/vars-tab.gif"),
        RSCS_TAB_ICON("icons/small/rscs-tab.gif"),
        ADD_ICON("icons/small/add-button.png"),
        MOVEUP_ICON("icons/small/move-up.png"),
        MOVEDOWN_ICON("icons/small/move-down.png");

        private final String _key;

        private Images(String path) {
            this._key = path;
        }

        private void init(ImageRegistry reg) {
            ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)Activator.PLUGIN_ID, (String)this._key);
            reg.put(this._key, desc);
        }

        public Image getImage() {
            return Activator.getDefault().getImageRegistry().get(this._key);
        }

        public ImageDescriptor getImageDescriptor() {
            return Activator.getDefault().getImageRegistry().getDescriptor(this._key);
        }
    }
}

