/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.bindedit.VariableDataTypeValidatorReader;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.context.IModelContext;

public class VariablesValidator
implements IValidator {
    private final IDocument _baseDoc;
    private final int _offset;
    private final List<String> _acceptedBinarySigs;
    private final List<DataType> _acceptedDataTypesSigs;
    private final String _supportedTypesString;

    public VariablesValidator(IDocument baseDoc, int offset, List<String> acceptedBinarySigs, List<DataType> acceptedDataTypeSigs, String supportedTypesString) {
        this._baseDoc = baseDoc;
        this._offset = offset;
        this._acceptedBinarySigs = new ArrayList<String>(acceptedBinarySigs);
        this._acceptedDataTypesSigs = new ArrayList<DataType>(acceptedDataTypeSigs);
        this._supportedTypesString = supportedTypesString;
    }

    public IStatus validate(Object value) {
        if (value instanceof ValueReference) {
            ValueReference valRef = (ValueReference)value;
            DataType.Field field = valRef.getField((IModelContext)new FilePositionContext(this._offset, this._baseDoc.getFile()));
            DataType type = null;
            type = field != null ? field.getType() : valRef.getVariable().getType();
            IStatus result = VariableDataTypeValidatorReader.validate(type, this._baseDoc, this._offset, this._acceptedBinarySigs, this._acceptedDataTypesSigs, this._supportedTypesString);
            if (result == null) {
                LoggingService.logWarning((String)"oracle.eclipse.tools.webtier.ui", (String)Messages.bind((String)Messages.VariablesValidator_NoValidatorForDataType, (Object)type.toString()));
            } else {
                return result;
            }
        }
        return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.bind((String)Messages.BindDialog_TypeErrorLabel, (Object)(this._supportedTypesString.length() > 0 ? this._supportedTypesString : Messages.BindDialog_Correct)));
    }
}

