/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.bindedit.IVariableDataTypeValidator;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

class VariableDataTypeValidatorReader {
    private static final String EXT_PT = "variableDataTypeValidator";
    private static final String PRIORITY_ATTR = "priority";
    private static final String CLASS_ATTR = "class";
    private static List<IVariableDataTypeValidator> _validators;

    private VariableDataTypeValidatorReader() {
        throw new IllegalStateException("Should not be instantiated!");
    }

    public static IStatus validate(DataType dataType, IDocument baseDoc, int offset, List<String> acceptedBinarySigs, List<DataType> acceptedDataTypeSigs, String supportedTypesString) {
        for (IVariableDataTypeValidator validator : VariableDataTypeValidatorReader.getAllValidators()) {
            if (!validator.isValidatorFor(dataType)) continue;
            return validator.validate(dataType, baseDoc, offset, acceptedBinarySigs, acceptedDataTypeSigs, supportedTypesString);
        }
        return null;
    }

    private static synchronized List<IVariableDataTypeValidator> getAllValidators() {
        if (_validators == null) {
            _validators = VariableDataTypeValidatorReader.readAllValidators();
        }
        return _validators;
    }

    private static List<IVariableDataTypeValidator> readAllValidators() {
        TreeSet<ValidatorDescriptor> descriptors = new TreeSet<ValidatorDescriptor>(new ValidatorDescriptorComparator());
        Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.webtier.ui", (String)EXT_PT);
        for (IExtension ext : extensions) {
            IConfigurationElement[] elementConfig;
            IConfigurationElement[] iConfigurationElementArray = elementConfig = ext.getConfigurationElements();
            int n = elementConfig.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    String p = element.getAttribute(PRIORITY_ATTR);
                    int priority = VariableDataTypeValidatorReader.convertToInt(p);
                    IVariableDataTypeValidator validator = (IVariableDataTypeValidator)element.createExecutableExtension(CLASS_ATTR);
                    ValidatorDescriptor descriptor = new ValidatorDescriptor(priority, validator);
                    descriptors.add(descriptor);
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                }
                ++n2;
            }
        }
        ArrayList<IVariableDataTypeValidator> validators = new ArrayList<IVariableDataTypeValidator>(descriptors.size());
        for (ValidatorDescriptor descriptor : descriptors) {
            validators.add(descriptor.getValidator());
        }
        return validators;
    }

    private static int convertToInt(String intString) {
        if (intString == null || intString.trim().length() == 0) {
            return Integer.MAX_VALUE;
        }
        intString = intString.trim();
        try {
            return Integer.valueOf(intString);
        }
        catch (NumberFormatException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return Integer.MAX_VALUE;
        }
    }

    private static final class ValidatorDescriptor {
        private final int _priority;
        private final IVariableDataTypeValidator _validator;

        ValidatorDescriptor(int priority, IVariableDataTypeValidator validator) {
            this._priority = priority;
            this._validator = validator;
        }

        int getPriority() {
            return this._priority;
        }

        IVariableDataTypeValidator getValidator() {
            return this._validator;
        }
    }

    private static final class ValidatorDescriptorComparator
    implements Comparator<ValidatorDescriptor> {
        private ValidatorDescriptorComparator() {
        }

        @Override
        public int compare(ValidatorDescriptor d0, ValidatorDescriptor d1) {
            return d0.getPriority() - d1.getPriority();
        }
    }
}

