/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.Arrays;
import java.util.Comparator;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableIdentifierHelper;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class VariableComparator
extends ViewerComparator
implements Comparator {
    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, new Comparator(){

            public int compare(Object a, Object b) {
                return VariableComparator.this.compare(a, b);
            }
        });
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 != null && o2 != null) {
            if (o1 instanceof VariableGroup && o2 instanceof VariableGroup) {
                VariableGroup grp1 = (VariableGroup)o1;
                VariableGroup grp2 = (VariableGroup)o2;
                if (this.compare(grp1.getLabel(), Messages.VariablesTreeContentProvider_GroupLabel_PageVars) == 0) {
                    return -1;
                }
                if (this.compare(grp2.getLabel(), Messages.VariablesTreeContentProvider_GroupLabel_PageVars) == 0) {
                    return 1;
                }
            } else {
                if (o1 instanceof Variable && o2 instanceof Variable) {
                    Variable v1 = (Variable)o1;
                    Variable v2 = (Variable)o2;
                    return this.compare(v1.getName(), v2.getName());
                }
                if (o1 instanceof ValueReference && o2 instanceof ValueReference) {
                    ValueReference vr1 = (ValueReference)o1;
                    ValueReference vr2 = (ValueReference)o2;
                    String t1 = VariableIdentifierHelper.getTagName(vr1);
                    String t2 = VariableIdentifierHelper.getTagName(vr2);
                    return this.compare(t1, t2);
                }
            }
        }
        return 0;
    }

    protected int compare(String s1, String s2) {
        return s1.compareTo(s2);
    }
}

