/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.MethodReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.MethodReferenceObservableValue;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.webtier.ui.bindedit.BeanMethodObservableValue;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorValueCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultDeferredValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.ReadOnlyMessageObservable;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewMethodCustomEditorAdvisor
extends AbstractDialogEditorValueCreationAdvisor<IObservableValue, UpdateValueStrategy> {
    protected List<MethodReference> _acceptedSignatures;
    protected ValueReference _bean;

    public static NewMethodCustomEditorAdvisor getAdvisor(DataBindingContext context, Project project, List<String> originalAcceptedSignatures, List<MethodReference> acceptedSignatures, BeanMethodObservableValue userModel) {
        Assert.isTrue((originalAcceptedSignatures != null && originalAcceptedSignatures.size() > 0 ? 1 : 0) != 0, (String)Messages.NewMethodAdvisor_AcceptedSigsEmptyError);
        Assert.isNotNull((Object)((Object)userModel));
        Assert.isNotNull((Object)userModel.getBean());
        MethodNameValidatorConverter vc = new MethodNameValidatorConverter(originalAcceptedSignatures, project, userModel.getBean());
        return new NewMethodCustomEditorAdvisor(context, project, originalAcceptedSignatures, acceptedSignatures, userModel, vc, vc);
    }

    public NewMethodCustomEditorAdvisor(DataBindingContext context, Project project, List<String> originalAcceptedSignatures, List<MethodReference> acceptedSignatures, BeanMethodObservableValue userModel, IValidator selectionValidator, IConverter selectionConverter) {
        super(context, Messages.NewMethodDialog_Title, (AbstractDialogEditorCreationAdvisor.MessageSourceObservableValue)new ReadOnlyMessageObservable(Messages.bind((String)Messages.NewMethodDialog_Prompt, (Object)userModel.getBean().getType(DataType.NullModelContext.getInstance()).getDisplayName(false))), (AbstractBindingMediator)new UserDataMediator((IObservableValue)userModel), (AbstractBindingMediator)new IntermediateDataMediator(), (AbstractBindingMediator)new SelectionDataMediator(selectionValidator, selectionConverter));
        this._acceptedSignatures = acceptedSignatures;
        this._bean = userModel.getBean();
    }

    protected Control doCreateEditingArea(Composite parent) {
        Composite editingArea = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.minimumWidth = 465;
        editingArea.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        editingArea.setLayout((Layout)layout);
        Label label = new Label(editingArea, 320);
        label.setText(String.valueOf(Messages.NewMethodDialog_MethodNameLabel) + ':');
        GridData layoutData2 = new GridData();
        layoutData2.horizontalAlignment = 1;
        label.setLayoutData((Object)layoutData2);
        Text text = new Text(editingArea, 2052);
        GridData layoutData3 = new GridData();
        layoutData3.horizontalAlignment = 4;
        layoutData3.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)layoutData3);
        Label sigLabel = new Label(editingArea, 320);
        sigLabel.setText(String.valueOf(Messages.NewMethodDialog_SignatureLabel) + ':');
        GridData layoutData4 = new GridData();
        layoutData4.horizontalAlignment = 1;
        sigLabel.setLayoutData((Object)layoutData4);
        Label sigValueLabel = new Label(editingArea, 320);
        sigValueLabel.setText(Messages.bind((String)this._acceptedSignatures.get(0).getLabel(), (Object)Messages.NewMethodDialog_MethodNameUnspecified));
        GridData layoutData5 = new GridData();
        layoutData5.horizontalAlignment = 4;
        layoutData5.grabExcessHorizontalSpace = true;
        sigValueLabel.setLayoutData((Object)layoutData5);
        this.setInitState(AbstractDialogEditorCreationAdvisor.InitState.UI_INITIALIZED);
        this.getSelectionModel().setStateModel((IObservable)SWTObservables.observeText((Control)text, (int)24));
        return editingArea;
    }

    private static final class IntermediateDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        public IntermediateDataMediator() {
            super((IObservableValue)new MethodReferenceObservableValue(null), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    public static class MethodNameValidatorConverter
    implements IValidator,
    IConverter {
        private final MethodReferenceFactory _factory = new MethodReferenceFactory();
        private final String _returnType;
        private final String[] _paramTypes;
        private final Project _project;
        private final ValueReference _bean;
        private final List<MethodReference> _methodReferences;
        private MethodReference _methodReference;

        public MethodNameValidatorConverter(List<String> acceptedSignatures, Project project, ValueReference bean) {
            String signature = acceptedSignatures.get(0);
            this._returnType = TypeUtil.getFullyQualifiedName((String)Signature.getReturnType((String)signature));
            String[] paramTypes = Signature.getParameterTypes((String)signature);
            int i = 0;
            while (i < paramTypes.length) {
                paramTypes[i] = TypeUtil.getFullyQualifiedName((String)paramTypes[i]);
                ++i;
            }
            this._paramTypes = paramTypes;
            this._project = project;
            this._bean = bean;
            this._methodReferences = bean.getMethodReferences();
        }

        public IStatus validate(Object value) {
            String methodName = (String)value;
            if (methodName != null) {
                methodName = methodName.trim();
            }
            if (methodName == null || methodName.length() == 0) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewMethodDialog_EmptyMethodNameError);
            }
            if (JavaUtil.isKeyword((String)methodName)) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewMethodDialog_KeywordMethodNameError);
            }
            if (!Character.isJavaIdentifierStart(methodName.charAt(0))) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewMethodDialog_BadBeginCharMethodNameError);
            }
            int i = 0;
            while (i < methodName.length()) {
                if (Character.isWhitespace(methodName.charAt(i))) {
                    return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewMethodDialog_WhiteSpaceMethodNameError);
                }
                if (!Character.isJavaIdentifierPart(methodName.charAt(i))) {
                    return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.bind((String)Messages.NewMethodDialog_BadCharMethodNameError, (Object)Character.valueOf(methodName.charAt(i))));
                }
                ++i;
            }
            this.createMethodReference(methodName);
            if (this.isDuplicateMethod()) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewMethodDialog_ExistingMethodNameError);
            }
            return Status.OK_STATUS;
        }

        private void createMethodReference(String methodName) {
            this._methodReference = this._factory.createMethodReference(this._bean, this._project, methodName, this._returnType, this._paramTypes);
        }

        public boolean isDuplicateMethod() {
            if (this._methodReference == null) {
                return false;
            }
            for (MethodReference existingMethodRef : this._methodReferences) {
                if (!existingMethodRef.matches(this._methodReference)) continue;
                return true;
            }
            return false;
        }

        public Object convert(Object fromObject) {
            return this._methodReference;
        }

        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return MethodReference.class;
        }
    }

    public static class SelectionDataMediator
    extends DefaultDeferredValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        private final IValidator _validator;
        private final IConverter _converter;

        public SelectionDataMediator(IValidator validator, IConverter converter) {
            super(new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            this._validator = validator;
            this._converter = converter;
        }

        protected List<AbstractValueBindingMediator.ValidatorDescriptor> getTargetUpdateValidators() {
            return Collections.singletonList(new AbstractValueBindingMediator.ValidatorDescriptor(this._validator, AbstractValueBindingMediator.ValidatorDescriptor.EValidatorRuntime.AfterGetValidator));
        }

        protected IConverter getTargetUpdateConverter() {
            return this._converter;
        }
    }

    private static final class UserDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        public UserDataMediator(IObservableValue userModel) {
            super(userModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        }
    }
}

