/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.MethodReferenceFactory;
import oracle.eclipse.tools.application.common.services.variables.MethodReferenceObservableValue;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceObservableValue;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.services.documentservices.IDocumentBindersProvider;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.ui.bindedit.BeanMethodObservableValue;
import oracle.eclipse.tools.webtier.ui.bindedit.NewMethodCustomEditorAdvisor;
import oracle.eclipse.tools.webtier.ui.bindedit.VariableComparator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.MethodReferenceTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.MethodViewFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariableGroup;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeLabelProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideNoneScopedBeansFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideStringFieldsFilter;
import oracle.eclipse.tools.webtier.ui.method.MethodBodyCreator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.CustomEditDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditorDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class MethodBindDialog
extends PropertyEditorDialog {
    protected final IDocument _document;
    protected final Project _project;
    protected TreeViewer _viewer;
    protected final List<String> _originalAcceptedSignatures;
    protected final List<MethodReference> _acceptedSignatures;
    protected final String _supportedSignaturesString;
    protected final String _attributeName;
    protected IValidator _wrappedValidator;
    protected IValidator _beanValidator;
    protected IConverter _beanConverter;
    protected ToolBar _newMethodToolBar;
    protected ToolItem _newMethodToolItem;
    protected ValueReferenceObservableValue _beanForNewMethod;
    protected final String _userMethodbodyTemplateId;
    protected final String _defaultMethodBodyTemplateId;
    protected MethodReferenceObservableValue _intermediateValue;
    private MethodReferenceTreeContentProvider _contentProvider;
    private static final int DEFAULT_WIDTH_HINT = 425;
    private static final int DEFAULT_HEIGHT_HINT = 250;
    private static final int DEFAULT_MIN_WIDTH = 200;
    private static final int DEFAULT_MIN_HEIGHT = 150;
    private static final String HELPID = "oracle.eclipse.tools.webtier.ui.ChooseMethodBindingDialog";

    public MethodBindDialog(Shell parentShell, IObservableValue modelObservable, IValidator validator, IDocument baseDoc, List<String> acceptedSignatures, String attributeName, String userMethodBodyTemplateId, String defaultMethodBodyTemplateId) {
        super(parentShell, Messages.MethodBindDialog_Title, MethodBindDialog.hasMethodSignatures(acceptedSignatures) ? Messages.MethodBindDialog_InstructionsLabel : Messages.MethodBindDialog_InstructionsNoSigsLabel, (IObservable)modelObservable, validator);
        Project project;
        Assert.isNotNull((Object)baseDoc, (String)Messages.MethodBindDialog_BaseDocNullError);
        this._project = project = MethodBindDialog.getProject(baseDoc.getFile());
        this._originalAcceptedSignatures = acceptedSignatures;
        this._acceptedSignatures = MethodBindDialog.getMethodReferences(acceptedSignatures, project, Messages.MethodBindDialog_MethodName);
        this._attributeName = attributeName;
        this._supportedSignaturesString = MethodBindDialog.getSupportedSignaturesString(this._acceptedSignatures);
        this._document = baseDoc;
        this._userMethodbodyTemplateId = userMethodBodyTemplateId;
        this._defaultMethodBodyTemplateId = defaultMethodBodyTemplateId;
        this.setStatusLineAboveButtons(true);
    }

    public MethodBindDialog(Shell parentShell, IObservableValue modelObservable, IValidator validator, IDocument baseDoc, String attributeName) {
        this(parentShell, modelObservable, validator, baseDoc, new ArrayList<String>(), attributeName, null, null);
    }

    protected static boolean hasMethodSignatures(List<String> signatures) {
        return signatures != null && signatures.size() > 0;
    }

    protected boolean hasMethodSignatures() {
        return this._originalAcceptedSignatures != null && this._originalAcceptedSignatures.size() > 0;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
    }

    protected static Project getProject(IFile baseFile) {
        IDocument document = (IDocument)baseFile.getAdapter(IDocument.class);
        return document == null ? null : document.getProject();
    }

    protected static List<MethodReference> getMethodReferences(List<String> signatures, Project project, String methodName) {
        ArrayList<MethodReference> methodRefs = new ArrayList<MethodReference>(signatures.size());
        MethodReferenceFactory factory = new MethodReferenceFactory();
        for (String signature : signatures) {
            String returnType = Signature.getReturnType((String)signature);
            returnType = TypeUtil.getFullyQualifiedName((String)returnType);
            String[] paramTypes = Signature.getParameterTypes((String)signature);
            int i = 0;
            while (i < paramTypes.length) {
                paramTypes[i] = TypeUtil.getFullyQualifiedName((String)paramTypes[i]);
                ++i;
            }
            methodRefs.add(factory.createMethodReference(null, project, methodName, returnType, paramTypes));
        }
        return methodRefs;
    }

    protected static String getSupportedSignaturesString(List<MethodReference> signatures) {
        VariablesTreeLabelProvider labelProvider = new VariablesTreeLabelProvider(DataType.NullModelContext.getInstance());
        int numSigs = signatures.size();
        switch (numSigs) {
            case 0: {
                return "";
            }
            case 1: {
                return labelProvider.getText(signatures.get(0));
            }
            case 2: {
                return Messages.bind((String)Messages.MethodBindDialog_MultipleDataTypes, (Object)labelProvider.getText(signatures.get(0)), (Object)labelProvider.getText(signatures.get(1)));
            }
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < numSigs - 1) {
            builder.append(labelProvider.getText(signatures.get(i)));
            builder.append(Messages.MethodBindDialog_SignatureSeparator);
            builder.append(" ");
            ++i;
        }
        return Messages.bind((String)Messages.MethodBindDialog_MultipleDataTypes, (Object)builder.toString(), (Object)labelProvider.getText(signatures.get(numSigs - 1)));
    }

    protected Control createEditingArea(Composite parent) {
        Composite localParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        localParent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        localParent.setLayoutData((Object)data);
        VariablesModel model = this.createVariablesModel(this._document.getFile());
        Tree tree = new Tree(localParent, 2820);
        this._viewer = new TreeViewer(tree);
        this._viewer.setLabelProvider((IBaseLabelProvider)new VariablesTreeLabelProvider((IModelContext)new FilePositionContext(this._document.getFile())));
        this._contentProvider = new MethodReferenceTreeContentProvider();
        this._contentProvider.setSelectionUpdater(new MethodReferenceTreeContentProvider.ISelectionUpdater(){

            @Override
            public void update() {
                if (MethodBindDialog.this.validationBinding != null) {
                    MethodBindDialog.this.validationBinding.updateModelToTarget();
                }
            }
        });
        this._viewer.setContentProvider((IContentProvider)this._contentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._viewer);
        this.addFilters();
        this.addSorting();
        this._viewer.setAutoExpandLevel(2);
        this._viewer.setInput((Object)model);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        data2.minimumWidth = 200;
        data2.minimumHeight = 150;
        data2.widthHint = 425;
        data2.heightHint = 250;
        this._viewer.getControl().setLayoutData((Object)data2);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)selection;
                    Object item = ssel.getFirstElement();
                    if (item instanceof MethodReference) {
                        IStatus status;
                        Object validationStatus;
                        if (MethodBindDialog.this.validationBinding != null && (validationStatus = MethodBindDialog.this.validationBinding.getValidationStatus().getValue()) instanceof IStatus && (status = (IStatus)validationStatus).isOK()) {
                            MethodBindDialog.this.okPressed();
                        }
                    } else if (MethodBindDialog.this._viewer.getExpandedState(item)) {
                        MethodBindDialog.this._viewer.collapseToLevel(item, 1);
                    } else {
                        MethodBindDialog.this._viewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        if (this.hasMethodSignatures()) {
            this._newMethodToolBar = new ToolBar(localParent, 0x800000);
            this._newMethodToolItem = new ToolItem(this._newMethodToolBar, 8);
            this._newMethodToolItem.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
            String tooltip = Messages.bind((String)Messages.MethodBindDialog_NewMethodTooltip, (Object)this.getAttributeNameForMessage());
            this._newMethodToolItem.setToolTipText(tooltip);
            GridData data3 = new GridData();
            data3.verticalAlignment = 128;
            this._newMethodToolBar.setLayoutData((Object)data3);
        }
        return localParent;
    }

    protected VariablesModel createVariablesModel(IFile file) {
        return new VariablesModel(file);
    }

    protected MethodViewFilter createMethodViewFilter() {
        return new MethodViewFilter(this._acceptedSignatures);
    }

    private void addFilters() {
        this._viewer.addFilter((ViewerFilter)this.createMethodViewFilter());
        this._viewer.addFilter((ViewerFilter)new HideNoneScopedBeansFilter());
        if (this.hasMethodSignatures()) {
            this._viewer.addFilter((ViewerFilter)new ToStringFilter());
        } else {
            this._viewer.addFilter((ViewerFilter)new ObjectMethodFilter());
        }
        this._viewer.addFilter((ViewerFilter)new HideStringFieldsFilter((IModelContext)new FilePositionContext(this._document.getFile())));
    }

    private void addSorting() {
        this._viewer.setComparator((ViewerComparator)new VariableComparator());
    }

    private String getAttributeNameForMessage() {
        String capAttributeName = String.format("%s%s", Character.valueOf(Character.toUpperCase(this._attributeName.charAt(0))), this._attributeName.substring(1));
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < capAttributeName.length()) {
            char c = capAttributeName.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                builder.append(' ');
            }
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }

    protected IValidator getWrappedValidator() {
        if (this._wrappedValidator == null) {
            this._wrappedValidator = new WrappedValidator();
        }
        return this._wrappedValidator;
    }

    private boolean passBinderCheck(MethodReference methodRef) {
        this.createUpdateModelBinding(methodRef);
        return this.updateModelBinding != null;
    }

    private boolean isAddMethodButtonEnabled() {
        return this._newMethodToolBar == null ? false : this._newMethodToolBar.isEnabled();
    }

    protected String getMethodBodyTemplateId() {
        MethodBodyCreator creator = MethodBodyCreator.getInstance();
        if (this._userMethodbodyTemplateId != null && creator.doesTemplateExist(this._userMethodbodyTemplateId)) {
            return this._userMethodbodyTemplateId;
        }
        if (this._defaultMethodBodyTemplateId != null && creator.doesTemplateExist(this._defaultMethodBodyTemplateId)) {
            return this._defaultMethodBodyTemplateId;
        }
        return null;
    }

    protected void bindNewMethodButton() {
        this._beanForNewMethod = new ValueReferenceObservableValue(null);
        final Binding newMethodValidation = this.context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._viewer), (IObservableValue)this._beanForNewMethod, new UpdateValueStrategy().setAfterGetValidator(this.getBeanValidator()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        this.context.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this._newMethodToolBar), (IObservableValue)new ComputedValue(this.context.getValidationRealm(), Boolean.class){

            protected Object calculate() {
                Object value = newMethodValidation.getValidationStatus().getValue();
                if (!(value instanceof IStatus)) {
                    return null;
                }
                IStatus status = (IStatus)value;
                return !status.matches(8);
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this._newMethodToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Binding binding = null;
                try {
                    BeanMethodObservableValue beanMethodObservableValue = new BeanMethodObservableValue((ValueReference)MethodBindDialog.this._beanForNewMethod.getValue(), MethodBindDialog.this.getMethodBodyTemplateId(), MethodBindDialog.this._project, MethodBindDialog.this._document.getFile());
                    binding = MethodBindDialog.this.context.bindValue((IObservableValue)beanMethodObservableValue, (IObservableValue)MethodBindDialog.this._intermediateValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
                    NewMethodCustomEditorAdvisor advisor = NewMethodCustomEditorAdvisor.getAdvisor(new DataBindingContext(), MethodBindDialog.this._project, MethodBindDialog.this._originalAcceptedSignatures, MethodBindDialog.getMethodReferences(MethodBindDialog.this._originalAcceptedSignatures, MethodBindDialog.this._project, Messages.NewMethodDialog_MethodNameTemplate), beanMethodObservableValue);
                    CustomEditDialog dialog = new CustomEditDialog(new IShellProvider(){

                        public Shell getShell() {
                            return MethodBindDialog.this.getShell();
                        }
                    }, (AbstractDialogEditorCreationAdvisor)advisor);
                    dialog.open();
                }
                finally {
                    if (binding != null) {
                        binding.dispose();
                    }
                }
            }
        });
    }

    protected IValidator getBeanValidator() {
        if (this._beanValidator == null) {
            this._beanValidator = new BeanValidator((IFilePositionContext)new FilePositionContext(this._document.getFile()));
        }
        return this._beanValidator;
    }

    protected void bindData() {
        if (this.hasMethodSignatures()) {
            this.bindNewMethodButton();
        }
        this._intermediateValue = new MethodReferenceObservableValue(null);
        this.validationBinding = this.context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._viewer), (IObservableValue)this._intermediateValue, new UpdateValueStrategy().setAfterGetValidator(this.getWrappedValidator()), (UpdateValueStrategy)new MyTreeViewerUpdateStrategy(UpdateValueStrategy.POLICY_ON_REQUEST, this._viewer, this._document));
        this.context.bindValue(this.getStatusObservableValue(), (IObservableValue)new ComputedValue(this.context.getValidationRealm(), IStatus.class){

            protected Object calculate() {
                return MethodBindDialog.this.validationBinding.getValidationStatus().getValue();
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.createUpdateModelBinding((IObservableValue)this._intermediateValue);
        if (this.updateModelBinding == null) {
            this.getStatusObservableValue().setValue((Object)new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.BindDialog_NullUpdateModelBindingErrorLabel));
            return;
        }
        this.updateModelBinding.updateTargetToModel();
        this.validationBinding.updateModelToTarget();
    }

    private void createUpdateModelBinding(MethodReference methodRef) {
        this._intermediateValue.setValue((Object)methodRef);
        this.createUpdateModelBinding((IObservableValue)this._intermediateValue);
    }

    private void createUpdateModelBinding(IObservableValue intermediateObservableValue) {
        if (this._document != null) {
            if (this.updateModelBinding != null && !this.updateModelBinding.isDisposed()) {
                this.updateModelBinding.dispose();
            }
            IDocumentBindersProvider dbp = (IDocumentBindersProvider)this._document.getAdapter(IDocumentBindersProvider.class);
            this.updateModelBinding = dbp.createBinding(this.context, (IObservableValue)this.modelObservable, intermediateObservableValue);
        }
    }

    protected void bindOkButton(Button button) {
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(status.isOK());
        }
    }

    protected void performModelBindingUpdate() {
        this.updateModelBinding.updateModelToTarget();
        this.triggerUnsetBindings();
    }

    public boolean close() {
        if (this._contentProvider != null) {
            this._contentProvider.dispose();
        }
        return super.close();
    }

    public static final class BeanValidator
    implements IValidator {
        private IFilePositionContext _context;

        public BeanValidator(IFilePositionContext filePositionContext) {
            this._context = filePositionContext;
        }

        private IStatus validate(ValueReference valueRef) {
            DataType type = valueRef.getType((IModelContext)this._context);
            if (type.isPrimitiveType() || type.isArray() || type.isEnumerable()) {
                return Status.CANCEL_STATUS;
            }
            if (!(type instanceof JDTDataType)) {
                return Status.CANCEL_STATUS;
            }
            if (!type.isUpdatable()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public IStatus validate(Object value) {
            if (value instanceof ValueReference) {
                ValueReference valueRef = (ValueReference)value;
                return this.validate(valueRef);
            }
            return Status.CANCEL_STATUS;
        }
    }

    private static final class MyTreeViewerUpdateStrategy
    extends UpdateValueStrategy {
        private final TreeViewer _treeViewer;
        private final IDocument _document;

        public MyTreeViewerUpdateStrategy(int updatePolicy, TreeViewer treeViewer, IDocument document) {
            super(updatePolicy);
            this._treeViewer = treeViewer;
            this._document = document;
        }

        protected IStatus doSet(IObservableValue observableValue, Object value) {
            if (value == null) {
                return super.doSet(observableValue, value);
            }
            if (value instanceof VariableGroup || value instanceof ValueReference) {
                return Status.OK_STATUS;
            }
            if (!(value instanceof MethodReference)) {
                throw new IllegalArgumentException(Messages.MethodBindDialog_MethodRefRequiredError);
            }
            MethodReference methodReference = (MethodReference)value;
            Object[] elements = ((VariablesTreeContentProvider)this._treeViewer.getContentProvider()).getElements(this._treeViewer.getInput());
            ArrayList<VariableGroup> possiblePaths = new ArrayList<VariableGroup>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof VariableGroup && ((VariableGroup)element).mayContain(methodReference.getValueReference())) {
                    possiblePaths.add((VariableGroup)element);
                }
                ++n2;
            }
            if (possiblePaths.size() > 0) {
                if (possiblePaths.size() > 1) {
                    throw new IllegalStateException(Messages.MethodBindDialog_OneMatchingVarError);
                }
                VariableGroup selectionRoot = (VariableGroup)possiblePaths.get(0);
                List<Object> path = selectionRoot.getPath(methodReference, (IModelContext)new FilePositionContext(this._document.getFile()));
                if (path != selectionRoot.getNoPath()) {
                    path.add(0, this._treeViewer.getInput());
                    for (Object e : path) {
                        this._treeViewer.expandToLevel(e, 1);
                    }
                    return super.doSet(observableValue, value);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static final class ObjectMethodFilter
    extends ViewerFilter {
        private static final Set<String> OBJECT_METHOD_NAMES;

        static {
            HashSet<String> objectMethodNames = new HashSet<String>();
            objectMethodNames.add("wait");
            objectMethodNames.add("hashCode");
            objectMethodNames.add("getClass");
            objectMethodNames.add("equals");
            objectMethodNames.add("notify");
            objectMethodNames.add("notifyAll");
            objectMethodNames.add("toString");
            OBJECT_METHOD_NAMES = Collections.unmodifiableSet(objectMethodNames);
        }

        private ObjectMethodFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            MethodReference ref;
            return !(element instanceof MethodReference) || !OBJECT_METHOD_NAMES.contains((ref = (MethodReference)element).getMethodName());
        }
    }

    private static final class ToStringFilter
    extends ViewerFilter {
        private ToStringFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            MethodReference ref;
            return !(element instanceof MethodReference) || !(ref = (MethodReference)element).getMethodName().equals("toString");
        }
    }

    private final class WrappedValidator
    implements IValidator {
        private WrappedValidator() {
        }

        public IStatus validate(Object value) {
            MethodReference methodRef;
            if (value instanceof VariableGroup) {
                return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.MethodBindDialog_InvalidSelection);
            }
            if (value instanceof ValueReference) {
                if (MethodBindDialog.this.hasMethodSignatures() && MethodBindDialog.this.isAddMethodButtonEnabled()) {
                    return new Status(1, "oracle.eclipse.tools.webtier.ui", Messages.MethodBindDialog_MethodCreationInfo);
                }
                return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.MethodBindDialog_InvalidSelection);
            }
            if (value instanceof MethodReference && MethodBindDialog.this.passBinderCheck(methodRef = (MethodReference)value)) {
                if (MethodBindDialog.this.hasMethodSignatures()) {
                    for (MethodReference acceptedMethodRef : MethodBindDialog.this._acceptedSignatures) {
                        if (!methodRef.matchesSignature(acceptedMethodRef)) continue;
                        return Status.OK_STATUS;
                    }
                } else {
                    return Status.OK_STATUS;
                }
            }
            return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.bind((String)Messages.MethodBindDialog_TypeErrorLabel, (Object)MethodBindDialog.this._supportedSignaturesString));
        }
    }
}

