/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.resource.BindUtil;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleUtil;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.webtier.ui.bindedit.IElBindingContext;
import oracle.eclipse.tools.webtier.ui.bindedit.ResourcesValidator;
import oracle.eclipse.tools.webtier.ui.bindedit.VariableComparator;
import oracle.eclipse.tools.webtier.ui.bindedit.VariablesValidator;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.RefreshingValueReferenceTreeContentProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesTreeLabelProvider;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesViewFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideNoneScopedBeansFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.HideStringFieldsFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.NoEmptyFieldsFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.filters.PossibleVariablesMatcher;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBundleLabelProvider;
import oracle.eclipse.tools.webtier.ui.resource.internal.ResourceBundleListContentProvider;
import oracle.eclipse.tools.xml.edit.ui.provider.BindEditDialogCreationStrategyFactory;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.context.IModelContext;

public class JspElBindingContext
implements IElBindingContext {
    private static final List<IElBindingContext.BindingContextTab> EMPTY_TABS = new ArrayList<IElBindingContext.BindingContextTab>();
    private static final Map<BindUtil.BindDialogTab, List<IElBindingContext.BindingContextTab>> TAB_MAP;
    private static final Map<BindUtil.BindDialogTab, IElBindingContext.BindingContextTab> DEFAULT_TAB_MAP;
    private ViewerFilter userFilter;
    private final Map<IElBindingContext.BindingContextTab, BindingContextSection> _sections;
    private final EObject _eObject;
    private final EStructuralFeature _eFeature;
    private final int _offset;
    private final IDocument _baseDoc;
    private final List<String> _acceptedSigs;
    private final List<String> _acceptedBinarySigs;
    private final List<DataType> _acceptedDataTypeSigs;
    private final String _supportedTypesString;
    private final boolean _acceptsEarlyBoundVariables;
    private final boolean _acceptsLateBoundVariables;
    private final boolean _acceptsJspExpressions;
    private final BindEditDialogCreationStrategyFactory.BindDialogTabAdvisor _tabAdvisor;
    private BindUtil.BindDialogTab _tabsToShow;
    private Set<ResolutionTime> _resolutionTimes;

    static {
        HashMap tabMap = new HashMap();
        ArrayList<IElBindingContext.BindingContextTab> allTabs = new ArrayList<IElBindingContext.BindingContextTab>();
        allTabs.add(IElBindingContext.BindingContextTab.VARIABLES);
        allTabs.add(IElBindingContext.BindingContextTab.RESOURCES);
        tabMap.put(BindUtil.BindDialogTab.ALL, Collections.unmodifiableList(allTabs));
        ArrayList<IElBindingContext.BindingContextTab> varTab = new ArrayList<IElBindingContext.BindingContextTab>();
        varTab.add(IElBindingContext.BindingContextTab.VARIABLES);
        tabMap.put(BindUtil.BindDialogTab.VARIABLES, Collections.unmodifiableList(varTab));
        ArrayList<IElBindingContext.BindingContextTab> rscTab = new ArrayList<IElBindingContext.BindingContextTab>();
        rscTab.add(IElBindingContext.BindingContextTab.RESOURCES);
        tabMap.put(BindUtil.BindDialogTab.RESOURCES, Collections.unmodifiableList(rscTab));
        TAB_MAP = Collections.unmodifiableMap(tabMap);
        HashMap<BindUtil.BindDialogTab, IElBindingContext.BindingContextTab> defaultTabMap = new HashMap<BindUtil.BindDialogTab, IElBindingContext.BindingContextTab>();
        defaultTabMap.put(BindUtil.BindDialogTab.VARIABLES, IElBindingContext.BindingContextTab.VARIABLES);
        defaultTabMap.put(BindUtil.BindDialogTab.RESOURCES, IElBindingContext.BindingContextTab.RESOURCES);
        DEFAULT_TAB_MAP = Collections.unmodifiableMap(defaultTabMap);
    }

    private static List<String> convertToBinaryStrings(List<String> signatures) {
        ArrayList<String> binarySignatures = new ArrayList<String>();
        for (String sig : signatures) {
            binarySignatures.add(JspElBindingContext.createBinarySignature(sig));
        }
        return binarySignatures;
    }

    private static String createBinarySignature(String name) {
        String newName = name;
        if (newName != null && !newName.startsWith(String.valueOf('['))) {
            newName = Signature.createTypeSignature((String)newName, (boolean)true);
        }
        return newName;
    }

    private static List<DataType> getDataTypes(IFile baseFile, List<String> signatures) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(signatures.size());
        IDocument document = (IDocument)baseFile.getAdapter(IDocument.class);
        Assert.isNotNull((Object)document, (String)"The base document was null!");
        IDatatypeProvider dataTypeProvider = (IDatatypeProvider)document.getProject().getAppService(IDatatypeProvider.class);
        Assert.isNotNull((Object)dataTypeProvider, (String)"The data type provider was null!");
        for (String signature : signatures) {
            dataTypes.add(dataTypeProvider.getDataType(signature, null));
        }
        return dataTypes;
    }

    private static String getSupportedTypesString(List<DataType> acceptedSignatures) {
        int numSigs = acceptedSignatures.size();
        if (numSigs >= 2) {
            boolean hasObject = false;
            boolean hasString = false;
            for (DataType dataType : acceptedSignatures) {
                if (dataType.isString()) {
                    hasString = true;
                }
                if (!Object.class.getName().equals(dataType.getName())) continue;
                hasObject = true;
            }
            if (hasString && hasObject) {
                return null;
            }
        }
        switch (numSigs) {
            case 0: {
                return null;
            }
            case 1: {
                return JspElBindingContext.mapDataTypeToString(acceptedSignatures.get(0));
            }
            case 2: {
                return Messages.bind((String)Messages.BindDialog_MultipleDataTypes, (Object)JspElBindingContext.mapDataTypeToString(acceptedSignatures.get(0)), (Object)JspElBindingContext.mapDataTypeToString(acceptedSignatures.get(1)));
            }
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < numSigs - 1) {
            builder.append(JspElBindingContext.mapDataTypeToString(acceptedSignatures.get(i)));
            builder.append(Messages.BindDialog_TypeSeparator);
            builder.append(" ");
            ++i;
        }
        return Messages.bind((String)Messages.BindDialog_MultipleDataTypes, (Object)builder.toString(), (Object)JspElBindingContext.mapDataTypeToString(acceptedSignatures.get(numSigs - 1)));
    }

    private static String mapDataTypeToString(DataType dataType) {
        if (dataType.isArray()) {
            return Messages.bind((String)Messages.BindDialog_ArrayType, (Object)JspElBindingContext.mapDataTypeToString(dataType.getComponentType()));
        }
        return JspElBindingContext.mapSimpleDataTypeToString(dataType);
    }

    private static String mapSimpleDataTypeToString(DataType dataType) {
        if (dataType.isNumeric()) {
            return Messages.BindDialog_NumericType;
        }
        if (dataType.isBoolean()) {
            return Messages.BindDialog_BooleanType;
        }
        if (dataType.isEnumerable()) {
            return Messages.BindDialog_EnumerableType;
        }
        if (dataType.isString()) {
            return Messages.BindDialog_StringType;
        }
        return dataType.getName();
    }

    private static final int getOffset(EObject eObject, EStructuralFeature eFeature) {
        long offset = ResourceBundleUtil.INSTANCE.getOffset(eObject, eFeature);
        return (int)(offset > -1L ? offset : 0L);
    }

    public JspElBindingContext(EObject eObject, EStructuralFeature eFeature, IDocument baseDoc, List<String> acceptedSigs, Boolean acceptsEarlyBoundVariables, Boolean acceptsLateBoundVariables, Boolean acceptsJspExpressions, BindEditDialogCreationStrategyFactory.BindDialogTabAdvisor tabAdvisor) {
        HashMap<IElBindingContext.BindingContextTab, BindingContextSection> sections = new HashMap<IElBindingContext.BindingContextTab, BindingContextSection>();
        sections.put(IElBindingContext.BindingContextTab.VARIABLES, new VariablesBindingSection());
        sections.put(IElBindingContext.BindingContextTab.RESOURCES, new ResourcesBindingSection());
        this._sections = Collections.unmodifiableMap(sections);
        this._eObject = eObject;
        this._eFeature = eFeature;
        this._offset = JspElBindingContext.getOffset(eObject, eFeature);
        this._baseDoc = baseDoc;
        this._acceptedSigs = new ArrayList<String>(acceptedSigs);
        this._acceptedBinarySigs = JspElBindingContext.convertToBinaryStrings(acceptedSigs);
        this._acceptedDataTypeSigs = JspElBindingContext.getDataTypes(this._baseDoc.getFile(), this._acceptedSigs);
        this._supportedTypesString = JspElBindingContext.getSupportedTypesString(this._acceptedDataTypeSigs);
        this._acceptsEarlyBoundVariables = this.getValue(acceptsEarlyBoundVariables);
        this._acceptsLateBoundVariables = this.getValue(acceptsLateBoundVariables);
        this._acceptsJspExpressions = this.getValue(acceptsJspExpressions);
        this._tabAdvisor = tabAdvisor;
    }

    private boolean getValue(Boolean bool) {
        return bool == null ? false : bool;
    }

    private BindingContextSection getSection(IElBindingContext.BindingContextTab tab) {
        BindingContextSection section = this._sections.get((Object)tab);
        if (section == null) {
            throw new IllegalArgumentException((Object)((Object)tab) + " has no corresponding section");
        }
        return section;
    }

    @Override
    public String getDialogTitle() {
        List<IElBindingContext.BindingContextTab> tabs = this.getTabs();
        if (tabs.size() == 1 && tabs.contains((Object)IElBindingContext.BindingContextTab.RESOURCES)) {
            return Messages.BindDialog_ChooseResourceTitle;
        }
        return Messages.BindDialog_ChooseBindingTitle;
    }

    @Override
    public String getDialogInstructions() {
        List<IElBindingContext.BindingContextTab> tabs = this.getTabs();
        if (tabs.size() == 1 && tabs.contains((Object)IElBindingContext.BindingContextTab.RESOURCES)) {
            if (this._supportedTypesString == null) {
                return Messages.BindDialog_InstructionsGeneric;
            }
            return Messages.bind((String)Messages.BindDialog_InstructionsLabel, (Object)this._supportedTypesString);
        }
        return null;
    }

    @Override
    public List<IElBindingContext.BindingContextTab> getTabs() {
        BindUtil.BindDialogTab tabsToShow = this.getBindDialogTab();
        if (tabsToShow == null) {
            return EMPTY_TABS;
        }
        return TAB_MAP.get(tabsToShow);
    }

    private BindUtil.BindDialogTab getBindDialogTab() {
        if (this._tabsToShow == null) {
            this._tabsToShow = this._tabAdvisor.getTabsToShow();
        }
        return this._tabsToShow;
    }

    @Override
    public IElBindingContext.BindingContextTab getDefaultTab() {
        BindUtil.BindDialogTab defaultTab = BindUtil.INSTANCE.getDefaultTab(this._eObject, this._eFeature);
        IElBindingContext.BindingContextTab tab = DEFAULT_TAB_MAP.get(defaultTab);
        List<IElBindingContext.BindingContextTab> tabs = this.getTabs();
        if (tabs.size() == IElBindingContext.BindingContextTab.values().length) {
            return tab;
        }
        if (!tabs.contains((Object)tab)) {
            return tabs.get(0);
        }
        return tab;
    }

    @Override
    public String getTabInstructions(IElBindingContext.BindingContextTab tab) {
        return this.getSection(tab).getTabInstructions();
    }

    @Override
    public Object getModel(IElBindingContext.BindingContextTab tab) {
        return this.getSection(tab).getModel();
    }

    @Override
    public IStructuredContentProvider getContentProvider(IElBindingContext.BindingContextTab tab) {
        return this.getSection(tab).getContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider(IElBindingContext.BindingContextTab tab) {
        return this.getSection(tab).getLabelProvider();
    }

    @Override
    public List<ViewerFilter> getFilters(IElBindingContext.BindingContextTab tab) {
        if (this.userFilter == null) {
            return this.getSection(tab).getFilters();
        }
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        filters.addAll(this.getSection(tab).getFilters());
        filters.add(this.userFilter);
        return filters;
    }

    @Override
    public void addFilter(ViewerFilter filter) {
        this.userFilter = filter;
    }

    @Override
    public ViewerComparator getSorter(IElBindingContext.BindingContextTab tab) {
        return this.getSection(tab).getSorter();
    }

    @Override
    public IValidator getValidator(IElBindingContext.BindingContextTab tab) {
        return this.getSection(tab).getValidator();
    }

    private Set<ResolutionTime> getResSolutionTimes() {
        if (this._resolutionTimes == null) {
            HashSet resTimes = new HashSet();
            if (this._acceptsEarlyBoundVariables) {
                resTimes.addAll(ResolutionTime.COMPILETIME_VISIBLE_TYPES);
            }
            if (this._acceptsLateBoundVariables) {
                resTimes.addAll(ResolutionTime.RUNTIME_VISIBLE_TYPES);
            }
            this._resolutionTimes = Collections.unmodifiableSet(resTimes);
        }
        return this._resolutionTimes;
    }

    private static interface BindingContextSection {
        public String getTabInstructions();

        public Object getModel();

        public IStructuredContentProvider getContentProvider();

        public IBaseLabelProvider getLabelProvider();

        public List<ViewerFilter> getFilters();

        public ViewerComparator getSorter();

        public IValidator getValidator();
    }

    private final class ResourcesBindingSection
    implements BindingContextSection {
        private ResourcesBindingSection() {
        }

        @Override
        public String getTabInstructions() {
            return Messages.BindDialog_ResourceInstructionsLabel;
        }

        @Override
        public Object getModel() {
            return JspElBindingContext.this._eFeature;
        }

        @Override
        public IStructuredContentProvider getContentProvider() {
            return new ResourceBundleListContentProvider((IFilePositionContext)new FilePositionContext(JspElBindingContext.this._offset, JspElBindingContext.this._baseDoc.getFile()), JspElBindingContext.this._eObject, JspElBindingContext.this.getResSolutionTimes());
        }

        @Override
        public IBaseLabelProvider getLabelProvider() {
            return new ResourceBundleLabelProvider();
        }

        @Override
        public List<ViewerFilter> getFilters() {
            return Collections.emptyList();
        }

        @Override
        public ViewerComparator getSorter() {
            return null;
        }

        @Override
        public IValidator getValidator() {
            return new ResourcesValidator();
        }
    }

    private final class VariablesBindingSection
    implements BindingContextSection {
        private VariablesBindingSection() {
        }

        @Override
        public String getTabInstructions() {
            if (JspElBindingContext.this._supportedTypesString == null) {
                return Messages.BindDialog_InstructionsGeneric;
            }
            return Messages.bind((String)Messages.BindDialog_InstructionsLabel, (Object)JspElBindingContext.this._supportedTypesString);
        }

        @Override
        public Object getModel() {
            return new VariablesModel(JspElBindingContext.this._baseDoc.getFile());
        }

        @Override
        public IStructuredContentProvider getContentProvider() {
            return new RefreshingValueReferenceTreeContentProvider((IFilePositionContext)new FilePositionContext(JspElBindingContext.this._baseDoc.getFile()), new PossibleVariablesMatcher(JspElBindingContext.this._acceptsEarlyBoundVariables, JspElBindingContext.this._acceptsLateBoundVariables, JspElBindingContext.this._acceptsJspExpressions));
        }

        @Override
        public IBaseLabelProvider getLabelProvider() {
            return new VariablesTreeLabelProvider((IModelContext)new FilePositionContext(JspElBindingContext.this._offset, JspElBindingContext.this._baseDoc.getFile()));
        }

        @Override
        public List<ViewerFilter> getFilters() {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
            FilePositionContext context = new FilePositionContext(JspElBindingContext.this._offset, JspElBindingContext.this._baseDoc.getFile());
            filters.add(new VariablesViewFilter(VariablesViewFilter.ValueReferenceFilterType.ALL, (IFilePositionContext)context));
            filters.add(new NoEmptyFieldsFilter());
            filters.add(new HideNoneScopedBeansFilter());
            filters.add(new HideStringFieldsFilter((IModelContext)context));
            return filters;
        }

        @Override
        public ViewerComparator getSorter() {
            return new VariableComparator();
        }

        @Override
        public IValidator getValidator() {
            return new VariablesValidator(JspElBindingContext.this._baseDoc, JspElBindingContext.this._offset, JspElBindingContext.this._acceptedBinarySigs, JspElBindingContext.this._acceptedDataTypeSigs, JspElBindingContext.this._supportedTypesString);
        }
    }
}

