/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bindedit;

import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractViewChanger {
    private static final String VIEW_ENUM = "org.eclipse.swt.widgets.MenuItem.AbstractViewChanger.View";
    private Control _control;
    private View _currentView;

    public AbstractViewChanger(Composite parent, View initialView) {
        this._currentView = initialView;
        this._control = this.createControl(parent);
    }

    protected Control createControl(Composite parent) {
        Composite viewChanger = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        viewChanger.setLayout((Layout)layout);
        Label viewLabel = new Label(viewChanger, 256);
        viewLabel.setText(Messages.AbstractViewChanger_ViewLabel);
        Button viewButton = new Button(viewChanger, 1028);
        final Menu viewMenu = new Menu((Control)viewChanger);
        View[] viewArray = View.values();
        int n = viewArray.length;
        int n2 = 0;
        while (n2 < n) {
            View view = viewArray[n2];
            MenuItem menuItem = new MenuItem(viewMenu, 16);
            menuItem.setText(view.getMenuText());
            menuItem.setData(VIEW_ENUM, (Object)view);
            if (view == this._currentView) {
                menuItem.setSelection(true);
            }
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    MenuItem mi = (MenuItem)e.getSource();
                    View newView = (View)((Object)mi.getData(AbstractViewChanger.VIEW_ENUM));
                    if (newView != AbstractViewChanger.this._currentView) {
                        View oldView = AbstractViewChanger.this._currentView;
                        AbstractViewChanger.this._currentView = newView;
                        AbstractViewChanger.this.changeView(oldView, newView);
                    }
                }
            });
            ++n2;
        }
        viewButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                viewMenu.setVisible(true);
            }
        });
        return viewChanger;
    }

    Control getControl() {
        return this._control;
    }

    public abstract void changeView(View var1, View var2);

    public static enum View {
        RESOURCE_KEYS(Messages.AbstractViewChanger_ResourceKeysMenuText),
        RESOURCE_VALUES(Messages.AbstractViewChanger_ResourceValuesMenuText);

        private String _menuText;

        private View(String menuText) {
            this._menuText = menuText;
        }

        String getMenuText() {
            return this._menuText;
        }
    }
}

