/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.ui.bean;

import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.StatusDialog;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class NewManagedBeanDialog
extends StatusDialog {
    private static final IStatus STATUS_OK = new Status(0, "unknown", null);
    final String[] _scopes;
    final String _defaultScope;
    final int _defaultScopeIndex;
    final String _requiredScope;
    final int _requiredScopeIndex;
    final boolean _displayDescription;
    final IProject _project;
    final BeanNameValidator _beanNameValidator;
    private Text _nameText;
    private Text _typeText;
    private IJavaElement _beanClass;
    private String _beanClassName;
    private String _beanName;
    private IPath _beanJavaFilePath;
    private boolean _saveJavaClass;
    private NewClassWizardPage _newClassWizardPage;

    public NewManagedBeanDialog(Shell parent, List<String> scopes, String defaultScope, String requiredScope, boolean displayDescription, BeanNameValidator beanNameValidator, IProject project) {
        super(parent);
        this.setTitle(Messages.NewManagedBeanDialog_title);
        Assert.isNotNull(scopes);
        Assert.isTrue((scopes.size() > 0 ? 1 : 0) != 0);
        this._scopes = scopes.toArray(new String[scopes.size()]);
        Assert.isNotNull((Object)defaultScope);
        this._defaultScope = defaultScope;
        this._defaultScopeIndex = this.findIndex(this._defaultScope, this._scopes);
        Assert.isTrue((this._defaultScopeIndex != -1 ? 1 : 0) != 0);
        this._requiredScope = requiredScope;
        if (this._requiredScope != null) {
            this._requiredScopeIndex = this.findIndex(this._requiredScope, this._scopes);
            Assert.isTrue((this._requiredScopeIndex != -1 ? 1 : 0) != 0);
        } else {
            this._requiredScopeIndex = -1;
        }
        this._displayDescription = displayDescription;
        this._beanNameValidator = beanNameValidator;
        this._project = project;
    }

    public NewManagedBeanDialog(Shell parent, List<String> scopes, String defaultScope, String requiredScope, boolean displayDescription, BeanNameValidator beanNameValidator, IProject project, boolean saveJavaClass) {
        this(parent, scopes, defaultScope, requiredScope, displayDescription, beanNameValidator, project);
        this._saveJavaClass = saveJavaClass;
    }

    public String getBeanName() {
        return this._beanName;
    }

    public IJavaElement getBeanClass() {
        return this._beanClass;
    }

    public String getBeanClassName() {
        return this._beanClassName;
    }

    public IPath getBeanJavaFilePath() {
        return this._beanClass != null ? this._beanClass.getPath() : this._beanJavaFilePath;
    }

    public void create() {
        this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.webtier.ui", null));
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContent = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(dialogContent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        content.setLayoutData((Object)data);
        Label instructions = new Label(content, 16384);
        instructions.setText(Messages.NewManagedBeanDialog_instructions);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.horizontalSpan = 2;
        instructions.setLayoutData((Object)data);
        Label spacer = new Label(content, 16384);
        GridData data2 = new GridData();
        data2.horizontalAlignment = 1;
        data2.horizontalSpan = 2;
        spacer.setLayoutData((Object)data2);
        Label nameLabel = new Label(content, 16384);
        nameLabel.setText(Messages.NewManagedBeanDialog_nameLabel);
        GridData data3 = new GridData();
        data3.horizontalAlignment = 1;
        nameLabel.setLayoutData((Object)data3);
        this._nameText = new Text(content, 2052);
        data3 = new GridData();
        data3.widthHint = 300;
        this._nameText.setLayoutData((Object)data3);
        this._nameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NewManagedBeanDialog.this._beanName = ((Text)e.widget).getText().trim();
                NewManagedBeanDialog.this.validate();
            }
        });
        this._nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewManagedBeanDialog.this.validate();
            }
        });
        Label typeLabel = new Label(content, 16384);
        typeLabel.setText(Messages.NewManagedBeanDialog_typeLabel);
        GridData data4 = new GridData();
        data4.horizontalAlignment = 1;
        typeLabel.setLayoutData((Object)data4);
        Composite typeComp = new Composite(content, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.verticalSpacing = 0;
        layout2.marginWidth = 0;
        layout2.horizontalSpacing = 0;
        typeComp.setLayout((Layout)layout2);
        GridData data5 = new GridData(4, 4, true, true);
        typeComp.setLayoutData((Object)data5);
        this._typeText = new Text(typeComp, 18432);
        this._typeText.setEditable(false);
        GridData data6 = new GridData(4, 0x1000000, true, false);
        this._typeText.setLayoutData((Object)data6);
        ToolBar toolBar = new ToolBar(typeComp, 0x800000);
        toolBar.setBackground(parent.getBackground());
        GridLayout layout3 = new GridLayout(1, true);
        layout3.marginHeight = 1;
        layout3.verticalSpacing = 1;
        layout3.marginWidth = 1;
        layout3.horizontalSpacing = 1;
        toolBar.setLayout((Layout)layout3);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolItem createBean = new ToolItem(toolBar, 8);
        createBean.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
        createBean.setToolTipText(Messages.NewManagedBeanDialog_createBeanToolTip);
        createBean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewClassWizardPage page = new NewClassWizardPage();
                page.init((IStructuredSelection)new StructuredSelection((Object)NewManagedBeanDialog.this._project));
                NewClassCreationWizard wizard = new NewClassCreationWizard(page, false){

                    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
                        if (NewManagedBeanDialog.this._saveJavaClass) {
                            super.finishPage(monitor);
                        }
                    }
                };
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                WizardDialog dialog = new WizardDialog(JavaPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
                dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
                dialog.create();
                int res = dialog.open();
                if (res == 0) {
                    if (!NewManagedBeanDialog.this._saveJavaClass) {
                        StringBuilder fullyQualifiedNamedSB;
                        NewManagedBeanDialog.this._newClassWizardPage = page;
                        String typeName = page.getTypeName();
                        IType enclosingType = page.getEnclosingType();
                        if (enclosingType != null) {
                            fullyQualifiedNamedSB = new StringBuilder(enclosingType.getFullyQualifiedName()).append('.').append(typeName);
                            NewManagedBeanDialog.this._beanJavaFilePath = enclosingType.getPath();
                        } else {
                            IPackageFragment packageFragment = page.getPackageFragment();
                            fullyQualifiedNamedSB = new StringBuilder(packageFragment.getElementName());
                            if (fullyQualifiedNamedSB.length() > 0) {
                                fullyQualifiedNamedSB.append('.');
                            }
                            fullyQualifiedNamedSB.append(typeName);
                            NewManagedBeanDialog.this._beanJavaFilePath = packageFragment.getPath().append(typeName).addFileExtension("java");
                        }
                        NewManagedBeanDialog.this.updateDataFields(fullyQualifiedNamedSB.toString(), typeName);
                    } else {
                        NewManagedBeanDialog.this.updateDataFields(wizard.getCreatedElement());
                    }
                    NewManagedBeanDialog.this.validate();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label scopeLabel = new Label(content, 16384);
        scopeLabel.setText(Messages.NewManagedBeanDialog_scopeLabel);
        GridData data7 = new GridData();
        data7.horizontalAlignment = 1;
        scopeLabel.setLayoutData((Object)data7);
        Combo scopeCombo = new Combo(content, 12);
        scopeCombo.setItems(this._scopes);
        scopeCombo.select(this._defaultScopeIndex);
        if (this._requiredScope != null) {
            scopeCombo.select(this._requiredScopeIndex);
            scopeCombo.setEnabled(false);
        }
        if (this._displayDescription) {
            Label descrLabel = new Label(content, 16384);
            descrLabel.setText(Messages.NewManagedBeanDialog_descriptionLabel);
            GridData data8 = new GridData();
            data8.horizontalAlignment = 1;
            data8.verticalAlignment = 128;
            descrLabel.setLayoutData((Object)data8);
            Text description = new Text(content, 2626);
            GridData data9 = new GridData(4, 0x1000000, true, false);
            data9.heightHint = 60;
            description.setLayoutData((Object)data9);
        }
        return dialogContent;
    }

    protected ToolItem createBrowseBeanTypeToolItem(final Composite parent, ToolBar toolBar) {
        ToolItem browseBean = new ToolItem(toolBar, 8);
        browseBean.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        browseBean.setToolTipText(Messages.NewManagedBeanDialog_browseBeanToolTip);
        browseBean.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] types;
                OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(parent.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createWorkspaceScope(), 5);
                dialog.setTitle(Messages.NewManagedBeanDialog_browseBeanDialogTitle);
                dialog.setMessage(Messages.NewManagedBeanDialog_browseBeanDialogMessage);
                int result = dialog.open();
                if (result == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                    NewManagedBeanDialog.this.updateDataFields((IJavaElement)types[0]);
                    NewManagedBeanDialog.this.validate();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return browseBean;
    }

    private void updateDataFields(IJavaElement beanClass) {
        this._beanClass = beanClass;
        this.updateDataFields(this.getClassPath(this._beanClass), this._beanClass.getElementName());
    }

    private void updateDataFields(String fullyQualifiedClassName, String simpleClassName) {
        this._beanClassName = fullyQualifiedClassName;
        this._typeText.setText(fullyQualifiedClassName);
        this.adjustBeanName(simpleClassName);
    }

    private void adjustBeanName(String simpleClassName) {
        if (this._nameText.getText() == null || this._nameText.getText().trim().equals("")) {
            this._beanName = this.makeDefaultBeanName(simpleClassName);
            this._nameText.setText(this._beanName);
        }
    }

    private void validate() {
        IStatus status = this._beanNameValidator.validate(this._nameText);
        if (!status.isOK()) {
            this.updateStatus(status);
            return;
        }
        status = this.validateBeanType();
        if (!status.isOK()) {
            this.updateStatus(status);
            return;
        }
        this.updateStatus(STATUS_OK);
    }

    private IStatus validateBeanType() {
        if (this._typeText.getText() == null || this._typeText.getText().trim().equals("")) {
            return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewManagedBeanDialog_noTypeError);
        }
        return new Status(0, "oracle.eclipse.tools.webtier.ui", null);
    }

    private String makeDefaultBeanName(String className) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(className);
        buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
        return buffer.toString();
    }

    private String getClassPath(IJavaElement element) {
        if (element.getElementType() != 7) {
            return null;
        }
        IJavaElement e = element;
        StringBuffer buffer = new StringBuffer();
        buffer.insert(0, e.getElementName());
        e = e.getParent();
        while (e.getElementType() == 7) {
            buffer.insert(0, '.');
            buffer.insert(0, e.getElementName());
            e = e.getParent();
        }
        IPackageFragment pkg = (IPackageFragment)e.getAncestor(4);
        buffer.insert(0, '.');
        buffer.insert(0, pkg.getElementName());
        return buffer.toString();
    }

    private int findIndex(String value, String[] values) {
        int i = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (candidate.equals(value)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public void saveJavaClass(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this._newClassWizardPage.createType(monitor);
    }

    public static final class BeanNameValidator
    implements IValidator {
        private List<String> _beanNameExclusionList;

        public BeanNameValidator(List<String> beanNameExclusionList) {
            this._beanNameExclusionList = beanNameExclusionList;
        }

        public IStatus validate(Object value) {
            if (value instanceof Text) {
                Text strValue = (Text)value;
                if (strValue.getText() == null || strValue.getText().trim().equals("")) {
                    return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewManagedBeanDialog_noNameError);
                }
                if (strValue.getText().contains(" ")) {
                    return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewManagedBeanDialog_badNameError);
                }
                for (String beanName : this._beanNameExclusionList) {
                    if (!strValue.getText().equals(beanName)) continue;
                    return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewManagedBeanDialog_existingNameError);
                }
                return new Status(0, "oracle.eclipse.tools.webtier.ui", null);
            }
            return new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.NewManagedBeanDialog_noNameError);
        }
    }
}

