/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.sqltools.actions;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.eclipse.tools.database.ui.sqltools.SqlToolsUiMessages;
import oracle.eclipse.tools.database.ui.sqltools.plan.ExplainPlanExec;
import org.eclipse.datatools.sqltools.plan.EPVFacade;
import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorActionContributorExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;

public class SQLEditorExplainPlanAction
extends SQLEditorActionContributorExtension {
    private SQLEditor _sqlEditor;
    private static String TEXT_ACTION = "Text";
    private static String GRAPHIC_ACTION = "Graphic";

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
        super.setActiveEditor(targetEditor);
    }

    public void contributeToContextMenu(IMenuManager mm) {
        ExplainTextAction textAction = new ExplainTextAction();
        ExplainGraphicAction graphicAction = new ExplainGraphicAction();
        if (this._sqlEditor.isConnected()) {
            textAction.setEnabled(true);
            graphicAction.setEnabled(true);
        } else {
            textAction.setEnabled(false);
            graphicAction.setEnabled(false);
        }
        mm.add((IContributionItem)new ActionContributionItem((IAction)textAction));
        mm.add((IContributionItem)new ActionContributionItem((IAction)graphicAction));
    }

    private abstract class ExplainAction
    extends Action {
        String _type;

        ExplainAction(String type, String text) {
            super(text);
            this._type = null;
            this._type = type;
        }

        public void update() {
            this.setEnabled(SQLEditorExplainPlanAction.this._sqlEditor != null && SQLEditorExplainPlanAction.this._sqlEditor.isConnected() && SQLEditorExplainPlanAction.this._sqlEditor.getSQLType() == 100);
        }

        public void run() {
            Connection con = SQLEditorExplainPlanAction.this._sqlEditor.getConnectionInfo().getSharedConnection();
            if (con != null) {
                String _sql = SQLEditorExplainPlanAction.this._sqlEditor.getSelectedText();
                if (_sql == null) {
                    _sql = SQLEditorExplainPlanAction.this._sqlEditor.getText();
                }
                int type = this._type.equals(TEXT_ACTION) ? 0 : (this._type.equals(GRAPHIC_ACTION) ? 1 : -1);
                String vendor = SQLEditorExplainPlanAction.this._sqlEditor.getDatabase().getVendor();
                String version = SQLEditorExplainPlanAction.this._sqlEditor.getDatabase().getVersion();
                PlanRequest pr = new PlanRequest(_sql, String.valueOf(vendor) + "_" + version, type, 3);
                EPVFacade epv = EPVFacade.getInstance();
                if (epv.createNewPlanInstance(pr)) {
                    try {
                        epv.planGenerated(pr, ExplainPlanExec.doExplainPlan(con, _sql, type));
                    }
                    catch (SQLException e) {
                        epv.planFailed(pr, (Throwable)e);
                    }
                }
            }
        }
    }

    private class ExplainGraphicAction
    extends ExplainAction {
        ExplainGraphicAction() {
            super(GRAPHIC_ACTION, SqlToolsUiMessages.SQLEditorExplainPlanAction_executeGraphicPlan);
        }
    }

    private class ExplainTextAction
    extends ExplainAction {
        ExplainTextAction() {
            super(TEXT_ACTION, SqlToolsUiMessages.SQLEditorExplainPlanAction_executeTextPlan);
        }
    }
}

