/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors.table;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleView;
import oracle.eclipse.tools.database.connectivity.editors.IPartEditContext;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.SQLObjectComposite;
import oracle.eclipse.tools.database.ui.editors.table.OracleTableDataEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ViewComposite
extends SQLObjectComposite {
    private OracleTableDataEditor dataEditor;

    public ViewComposite(IPartEditContext context, Composite parent, int style) {
        super(context, parent, style);
        try {
            this.addColumns((TabFolder)this.getParent());
            this.addData((TabFolder)this.getParent());
            this.addObjectGrantsTab(DBToolsUiMessages.Composite_grantsTab);
            this.addObjectDetailTab(DBToolsUiMessages.Composite_detailTab);
            this.addSqlTab();
            this.selectTabItem(this.tabFolder.getItem(0));
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    protected ResultSet getPartData(String partName) throws SQLException {
        OracleObject obj = this.context.getDatabaseObject().getOracleObject();
        String schemaName = null;
        if (obj instanceof OracleView) {
            schemaName = ((OracleView)obj).getSchema().getName();
        }
        DatabaseMetaData dbmd = this.context.getDatabaseObject().getConnection().getMetaData();
        if (partName.equalsIgnoreCase("Columns")) {
            return dbmd.getColumns(null, schemaName, this.context.getDatabaseObject().getName(), "%");
        }
        return null;
    }

    private void addColumns(TabFolder tab) {
        this.add("Columns", DBToolsUiMessages.TableComposite_columnTab);
    }

    private void addData(TabFolder tab) throws SQLException {
        this.dataEditor = new OracleTableDataEditor(tab, "Data", DBToolsUiMessages.TableComposite_dataTab, this.context);
        this.dataEditor.create();
    }

    @Override
    protected void selectTabItem(TabItem tabItem) {
        String partName = (String)tabItem.getData("PART_NAME");
        if (partName != null && partName.equals("Data")) {
            Runnable longJob = new Runnable(){

                @Override
                public void run() {
                    ViewComposite.this.dataEditor.loadData();
                }
            };
            BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)longJob);
        } else {
            super.selectTabItem(tabItem);
        }
    }
}

