/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors;

import oracle.eclipse.tools.common.ui.dialogs.StatusDialog;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PrivilegeDialog
extends StatusDialog {
    protected String dlgTitle;
    protected IPrivilegeObject privilegeObj;
    protected Text schemaText;
    protected Text objNameText;
    protected Label availablePrivLabel;
    protected Label selectedPrivLabel;
    protected Button allCheckBox;
    protected Button addButton;
    protected Button addAllButton;
    protected Button removeButton;
    protected Button removeAllButton;
    protected List availableList;
    protected List selectedList;
    protected Combo usrNameCombo;
    protected String selectedUser;
    protected boolean isAllChecked;
    protected String[] selectedPrivs;

    public PrivilegeDialog(String dlgTitle, IPrivilegeObject privilegeObj) {
        super(dlgTitle);
        this.dlgTitle = dlgTitle;
        this.privilegeObj = privilegeObj;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.dlgTitle);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 10;
        gl.marginHeight = 10;
        composite.setLayout((Layout)gl);
        Composite upComp = new Composite(composite, 0);
        upComp.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 200;
        upComp.setLayout((Layout)gl);
        Label schemaLabel = new Label(upComp, 0);
        schemaLabel.setText(DBToolsUiMessages.privilegeDlgSchemaLabel);
        this.schemaText = new Text(upComp, 2056);
        this.schemaText.setLayoutData((Object)new GridData(768));
        Label objNameLabel = new Label(upComp, 0);
        objNameLabel.setText(DBToolsUiMessages.privilegeDlgObjNameLabel);
        this.objNameText = new Text(upComp, 2056);
        this.objNameText.setLayoutData((Object)new GridData(768));
        Label usrNameLabel = new Label(upComp, 0);
        usrNameLabel.setText(DBToolsUiMessages.privilegeDlgUserLabel);
        this.usrNameCombo = new Combo(upComp, 2060);
        this.usrNameCombo.setLayoutData((Object)new GridData(768));
        this.usrNameCombo.setVisibleItemCount(10);
        Group privGroup = new Group(composite, 0);
        privGroup.setText(DBToolsUiMessages.privilegeDlgPrivGroupLabel);
        gl = new GridLayout(3, false);
        gl.horizontalSpacing = 4;
        gl.verticalSpacing = 6;
        privGroup.setLayout((Layout)gl);
        this.allCheckBox = new Button((Composite)privGroup, 32);
        this.allCheckBox.setText(DBToolsUiMessages.privilegeDlgAllLabel);
        new Label((Composite)privGroup, 0);
        new Label((Composite)privGroup, 0);
        this.availablePrivLabel = new Label((Composite)privGroup, 0);
        this.availablePrivLabel.setText(DBToolsUiMessages.privilegeDlgAvailablePrivLabel);
        new Label((Composite)privGroup, 0);
        this.selectedPrivLabel = new Label((Composite)privGroup, 0);
        this.selectedPrivLabel.setText(DBToolsUiMessages.privilegeDlgSelectedPrivLabel);
        this.availableList = new List((Composite)privGroup, 2818);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 150;
        this.availableList.setLayoutData((Object)data);
        Composite comp = new Composite((Composite)privGroup, 0);
        data = new GridData(1808);
        data.widthHint = 100;
        comp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 25;
        layout.verticalSpacing = 20;
        comp.setLayout((Layout)layout);
        Composite addComp = new Composite(comp, 0);
        addComp.setLayout((Layout)new GridLayout(1, true));
        addComp.setLayoutData((Object)new GridData(768));
        Composite removeComp = new Composite(comp, 0);
        removeComp.setLayout((Layout)new GridLayout(1, true));
        removeComp.setLayoutData((Object)new GridData(768));
        this.addButton = new Button(addComp, 8);
        this.addButton.setText(DBToolsUiMessages.privilegeDlgAddButtonLabel);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addAllButton = new Button(addComp, 8);
        this.addAllButton.setText(DBToolsUiMessages.privilegeDlgAddAllButtonLabel);
        this.addAllButton.setLayoutData((Object)new GridData(768));
        this.removeButton = new Button(removeComp, 8);
        this.removeButton.setText(DBToolsUiMessages.privilegeDlgRemoveButtonLabel);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeAllButton = new Button(removeComp, 8);
        this.removeAllButton.setText(DBToolsUiMessages.privilegeDlgRemoveAllButtonLabel);
        this.removeAllButton.setLayoutData((Object)new GridData(768));
        this.selectedList = new List((Composite)privGroup, 2818);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 150;
        this.selectedList.setLayoutData((Object)data);
        this.addListeners();
        this.initializeData();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected void addListeners() {
        this.usrNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrivilegeDialog.this.handleUserSelection();
            }
        });
        this.availableList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PrivilegeDialog.this.handleAdd();
            }
        });
        this.selectedList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PrivilegeDialog.this.handleRemove();
            }
        });
        this.allCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivilegeDialog.this.handleCheckAll();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivilegeDialog.this.handleAdd();
            }
        });
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivilegeDialog.this.handleAddAll();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivilegeDialog.this.handleRemove();
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivilegeDialog.this.handleRemoveAll();
            }
        });
    }

    public String getSelectedUser() {
        return this.selectedUser;
    }

    public boolean isAllChecked() {
        return this.isAllChecked;
    }

    public String[] getSelectedPrivileges() {
        if (this.isAllChecked()) {
            return new String[]{"ALL"};
        }
        return this.selectedPrivs;
    }

    protected void initializeData() {
        this.schemaText.setText(this.privilegeObj.getOwner());
        this.objNameText.setText(this.privilegeObj.getName());
        this.usrNameCombo.setFocus();
    }

    protected void handleUserSelection() {
        this.selectedUser = this.usrNameCombo.getItem(this.usrNameCombo.getSelectionIndex());
    }

    protected void handleCheckAll() {
        this.isAllChecked = this.allCheckBox.getSelection();
        this.validate();
    }

    protected void handleAdd() {
        String[] selectionStrs = this.availableList.getSelection();
        int[] selectionInd = this.availableList.getSelectionIndices();
        this.availableList.remove(selectionInd);
        this.availableList.select(0);
        int prevCount = this.selectedList.getItemCount();
        String[] stringArray = selectionStrs;
        int n = selectionStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.selectedList.add(str);
            ++n2;
        }
        this.selectedList.deselectAll();
        this.selectedList.select(prevCount, prevCount + selectionStrs.length);
        this.selectionChanged();
        this.validate();
    }

    protected void handleAddAll() {
        String[] selectionStrs = this.availableList.getItems();
        this.availableList.removeAll();
        int prevCount = this.selectedList.getItemCount();
        String[] stringArray = selectionStrs;
        int n = selectionStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.selectedList.add(str);
            ++n2;
        }
        this.selectedList.deselectAll();
        this.selectedList.select(prevCount, prevCount + selectionStrs.length);
        this.selectionChanged();
        this.validate();
    }

    protected void handleRemove() {
        String[] selectionStrs = this.selectedList.getSelection();
        int[] selectionInd = this.selectedList.getSelectionIndices();
        this.selectedList.remove(selectionInd);
        this.selectedList.select(this.selectedList.getItemCount() - 1);
        int prevCount = this.availableList.getItemCount();
        String[] stringArray = selectionStrs;
        int n = selectionStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.availableList.add(str);
            ++n2;
        }
        this.availableList.deselectAll();
        this.availableList.select(prevCount, prevCount + selectionStrs.length);
        this.selectionChanged();
        this.validate();
    }

    protected void handleRemoveAll() {
        String[] selectionStrs = this.selectedList.getItems();
        this.selectedList.removeAll();
        int prevCount = this.availableList.getItemCount();
        String[] stringArray = selectionStrs;
        int n = selectionStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.availableList.add(str);
            ++n2;
        }
        this.availableList.deselectAll();
        this.availableList.select(prevCount, prevCount + selectionStrs.length);
        this.selectionChanged();
        this.validate();
    }

    protected void selectionChanged() {
        this.selectedPrivs = this.selectedList.getItems();
    }

    protected void validate() {
        if (this.usrNameCombo.getItemCount() == 0 || this.isAllChecked()) {
            if (this.usrNameCombo.getItemCount() > 0) {
                this.getButton(0).setEnabled(true);
            } else {
                this.allCheckBox.setEnabled(false);
                this.getButton(0).setEnabled(false);
            }
            this.availablePrivLabel.setEnabled(false);
            this.availableList.setEnabled(false);
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
            this.selectedPrivLabel.setEnabled(false);
            this.selectedList.setEnabled(false);
            return;
        }
        this.availablePrivLabel.setEnabled(true);
        this.selectedPrivLabel.setEnabled(true);
        this.availableList.setEnabled(true);
        this.selectedList.setEnabled(true);
        if (this.availableList.getSelectionCount() == 0 || this.availableList.getItemCount() == 0) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            this.addAllButton.setEnabled(true);
        }
        if (this.selectedList.getSelectionCount() == 0 || this.selectedList.getItemCount() == 0) {
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.removeAllButton.setEnabled(true);
        }
        if (this.getButton(0) != null) {
            if (this.selectedPrivs == null || this.selectedPrivs.length == 0) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }
}

