/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.drivers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.drivers.OracleOptionalPropertiesPane;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class OracleDriverUIContributor
implements IDriverUIContributor,
Listener {
    public static final String CATALOG_TYPE_PROPERTY_ID = "org.eclipse.datatools.enablement.oracle.catalogType";
    public static final String CATALOG_TYPE_VALUE_ALL = "ALL";
    public static final String CATALOG_TYPE_VALUE_DBA = "DBA";
    public static final String CATALOG_TYPE_VALUE_USER = "USER";
    private static final String CUI_NEWCW_DATABASE_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_DATABASE_LBL_UI_;
    private static final String CUI_NEWCW_SERVICE_NAME_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_SERVICE_NAME_LBL_UI_;
    private static final String CUI_NEWCW_HOST_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_HOST_LBL_UI_;
    private static final String CUI_NEWCW_PORT_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_PORT_LBL_UI_;
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_USERNAME_LBL_UI_;
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_PASSWORD_LBL_UI_;
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_SAVE_PASSWORD_LBL_UI_;
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = DBToolsUiMessages.CUI_NEWCW_CONNECTIONURL_LBL_UI_;
    private static final String CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_SERVICE_NAME_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_SERVICE_NAME_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = DBToolsUiMessages.CUI_NEWCW_URL_SUMMARY_DATA_TEXT_;
    private IDriverUIContributorInformation contributorInformation;
    private Button sidRadio;
    private Button serviceNameRadio;
    protected Text databaseText;
    protected Text serviceNameText;
    private Label hostLabel;
    protected Text hostText;
    private Label portLabel;
    protected Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button savePasswordButton;
    private Label urlLabel;
    protected Text urlText;
    protected DialogPage parentPage;
    private ScrolledComposite parentComposite;
    private Composite oldParent;
    protected OptionalPropertiesPane optionalPropsComposite;
    private Properties properties;
    protected boolean isReadOnly = false;
    private SelectionListener sidListener;
    private SelectionListener serviceNameListener;
    private ModifyListener urlListener;

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.sidRadio.getSelection() && this.databaseText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DBToolsUiMessages.CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_);
            isComplete = false;
        } else if (this.serviceNameRadio.getSelection() && this.serviceNameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DBToolsUiMessages.CUI_NEWCW_VALIDATE_SERVICE_NAME_REQ_UI_);
            isComplete = false;
        } else if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DBToolsUiMessages.CUI_NEWCW_VALIDATE_HOST_REQ_UI_);
            isComplete = false;
        } else if (this.portText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DBToolsUiMessages.CUI_NEWCW_VALIDATE_PORT_REQ_UI_);
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DBToolsUiMessages.CUI_NEWCW_VALIDATE_USERID_REQ_UI_);
            isComplete = false;
        } else if (this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(DBToolsUiMessages.CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_);
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnlyUI) {
        if (parent != this.oldParent || this.parentComposite == null || this.parentComposite.isDisposed()) {
            this.oldParent = parent;
            this.isReadOnly = isReadOnlyUI;
            int additionalStyles = 0;
            if (isReadOnlyUI) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem generalTab = new TabItem(tabComposite, 0);
            generalTab.setText(DBToolsUiMessages.CommonDriverUIContributor_generaltab);
            Composite baseComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            baseComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)baseComposite);
            this.sidRadio = new Button(baseComposite, 16);
            this.sidRadio.setText(CUI_NEWCW_DATABASE_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.sidRadio.setLayoutData((Object)gd);
            this.databaseText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.databaseText.setLayoutData((Object)gd);
            this.serviceNameRadio = new Button(baseComposite, 16);
            this.serviceNameRadio.setText(CUI_NEWCW_SERVICE_NAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.serviceNameRadio.setLayoutData((Object)gd);
            this.serviceNameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.serviceNameText.setLayoutData((Object)gd);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(baseComposite, 0);
            this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(baseComposite, 2052);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.urlText.setLayoutData((Object)gd);
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(DBToolsUiMessages.CommonDriverUIContributor_optionaltab);
            this.optionalPropsComposite = this.createOptionalPropertiesPane((Composite)tabComposite, 0, this.isReadOnly);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    private void initialize() {
        this.sidListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OracleDriverUIContributor.this.handleSIDServiceSwitch();
            }
        };
        this.serviceNameListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OracleDriverUIContributor.this.handleSIDServiceSwitch();
            }
        };
        this.urlListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OracleDriverUIContributor.this.handleURLChange();
            }
        };
        this.updateURL();
        this.addListeners();
        this.urlText.addModifyListener(this.urlListener);
    }

    private void addListeners() {
        this.sidRadio.addSelectionListener(this.sidListener);
        this.serviceNameRadio.addSelectionListener(this.serviceNameListener);
        this.databaseText.addListener(24, (Listener)this);
        this.serviceNameText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
    }

    private void removeListeners() {
        this.sidRadio.removeSelectionListener(this.sidListener);
        this.serviceNameRadio.removeSelectionListener(this.serviceNameListener);
        this.databaseText.removeListener(24, (Listener)this);
        this.serviceNameText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
    }

    private void handleSIDServiceSwitch() {
        if (this.sidRadio.getSelection()) {
            this.databaseText.setEnabled(true);
            this.serviceNameText.setEnabled(false);
        } else {
            this.databaseText.setEnabled(false);
            this.serviceNameText.setEnabled(true);
        }
        this.determineContributorCompletion();
        this.urlText.removeModifyListener(this.urlListener);
        this.updateURL();
        this.urlText.addModifyListener(this.urlListener);
    }

    private boolean isSIDConnection() {
        return this.sidRadio.getSelection();
    }

    protected void handleURLChange() {
        String url = this.urlText.getText().trim();
        if (url != null && url.length() > 0) {
            this.removeListeners();
            OracleJDBCURL oracleUrl = this.getURLHandle(url);
            this.loadFromURL(oracleUrl);
            this.determineContributorCompletion();
            this.setConnectionInformation();
            this.addListeners();
        }
    }

    protected void updateURL() {
        String url = null;
        url = this.sidRadio.getSelection() ? this.getURLHandle(this.hostText.getText().trim(), this.portText.getText().trim(), this.databaseText.getText().trim()).formatURL() : this.getServiceURLHandle(this.hostText.getText().trim(), this.portText.getText().trim(), this.serviceNameText.getText().trim()).formatURL();
        this.urlText.setText(url);
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        if (this.isSIDConnection()) {
            summaryData.add(new String[]{CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_, this.databaseText.getText().trim()});
        } else {
            summaryData.add(new String[]{CUI_NEWCW_SERVICE_NAME_SUMMARY_DATA_TEXT_, this.serviceNameText.getText().trim()});
        }
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        String propertyList = this.properties.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        if (propertyList != null) {
            String[] pairs = this.parseString(propertyList, ",");
            int i = 0;
            while (i < pairs.length) {
                String[] nameValue = this.parseString(pairs[i], "=");
                summaryData.add(nameValue);
                ++i;
            }
        }
        return summaryData;
    }

    protected String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public void loadProperties() {
        this.removeListeners();
        this.urlText.removeModifyListener(this.urlListener);
        OracleJDBCURL url = this.getURLHandle(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.loadFromURL(url);
        this.optionalPropsComposite.loadProperties();
        this.updateURL();
        this.addListeners();
        this.urlText.addModifyListener(this.urlListener);
        this.setConnectionInformation();
    }

    private void loadFromURL(OracleJDBCURL url) {
        String savePassword;
        String password;
        this.hostText.setText(url.getNode());
        this.portText.setText(url.getPort());
        if (url.isServiceConnection()) {
            this.serviceNameRadio.setSelection(true);
            this.sidRadio.setSelection(false);
            this.databaseText.setEnabled(false);
            this.serviceNameText.setEnabled(true);
            this.serviceNameText.setText(url.getDatabaseName());
        } else {
            this.serviceNameRadio.setSelection(false);
            this.sidRadio.setSelection(true);
            this.serviceNameText.setEnabled(false);
            this.databaseText.setEnabled(true);
            this.databaseText.setText(url.getDatabaseName());
        }
        String username = url.getUserName();
        if (username == null || username.length() == 0) {
            username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        }
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = url.getPassword()) == null || password.length() == 0) {
            password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password");
        }
        if (password != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && savePassword.equalsIgnoreCase("true")) {
            this.savePasswordButton.setSelection(true);
        }
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            }
        } else {
            this.urlText.removeModifyListener(this.urlListener);
            this.updateURL();
            this.urlText.addModifyListener(this.urlListener);
            this.setConnectionInformation();
        }
    }

    private void setConnectionInformation() {
        String dbName = null;
        dbName = this.sidRadio.getSelection() ? this.databaseText.getText().trim() : this.serviceNameText.getText().trim();
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", dbName);
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    protected OptionalPropertiesPane createOptionalPropertiesPane(Composite parent, int style, boolean useReadOnlyControls) {
        return new OracleOptionalPropertiesPane(parent, style, useReadOnlyControls);
    }

    protected OracleJDBCURL getURLHandle(String url) {
        return new OracleJDBCURL(url);
    }

    protected OracleJDBCURL getURLHandle(String node, String port, String sid) {
        return new OracleJDBCURL(node, port, sid);
    }

    protected OracleJDBCURL getServiceURLHandle(String node, String port, String serviceName) {
        return new OracleJDBCURL(node, port, serviceName, true);
    }

    protected static class OracleJDBCURL {
        protected String subprotocol = "";
        protected String node = "";
        protected String port = "";
        protected boolean isServiceConnection = false;
        protected String databaseName = "";
        protected String urlProperties = "";
        protected String userName = "";
        protected String password = "";
        private static final String URL_SEPARATOR = ":";

        public OracleJDBCURL(String url) {
            this.parseURL(url);
        }

        public OracleJDBCURL(String node, String port, String databaseName) {
            this(node, port, databaseName, false);
        }

        public OracleJDBCURL(String node, String port, String databaseName, boolean isServiceConnection) {
            this.node = node;
            this.port = port;
            this.databaseName = databaseName;
            this.isServiceConnection = isServiceConnection;
        }

        public boolean isServiceConnection() {
            return this.isServiceConnection;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.urlProperties;
        }

        protected String formatURL() {
            String url = null;
            url = !this.isServiceConnection ? "jdbc:oracle:thin:@" + this.getNode() + URL_SEPARATOR + this.getPort() + URL_SEPARATOR + this.getDatabaseName() : "jdbc:oracle:thin:@//" + this.getNode() + URL_SEPARATOR + this.getPort() + '/' + this.getDatabaseName();
            return url;
        }

        protected void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(URL_SEPARATOR) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(URL_SEPARATOR));
                remainingURL = remainingURL.substring(remainingURL.indexOf(URL_SEPARATOR) + 1);
                this.subprotocol = String.valueOf(this.subprotocol) + remainingURL.substring(0, remainingURL.indexOf(URL_SEPARATOR));
                remainingURL = remainingURL.substring(remainingURL.indexOf(URL_SEPARATOR) + 1);
                if (remainingURL.startsWith("@")) {
                    remainingURL = remainingURL.substring(1);
                } else {
                    String usrPass = remainingURL.substring(0, remainingURL.indexOf(64));
                    if (usrPass.indexOf(47) != -1) {
                        this.userName = usrPass.substring(0, usrPass.indexOf(47));
                        this.password = usrPass.substring(usrPass.indexOf(47) + 1);
                    }
                    remainingURL = remainingURL.substring(remainingURL.indexOf(64) + 1);
                }
                if (remainingURL.startsWith("//")) {
                    this.isServiceConnection = true;
                    remainingURL = remainingURL.substring(2);
                    this.node = remainingURL.substring(0, remainingURL.indexOf(URL_SEPARATOR));
                    remainingURL = remainingURL.substring(remainingURL.indexOf(URL_SEPARATOR) + 1);
                    this.port = remainingURL.substring(0, remainingURL.indexOf(47));
                    this.databaseName = remainingURL = remainingURL.substring(remainingURL.indexOf(47) + 1);
                } else {
                    this.node = remainingURL.substring(0, remainingURL.indexOf(URL_SEPARATOR));
                    remainingURL = remainingURL.substring(remainingURL.indexOf(URL_SEPARATOR) + 1);
                    this.port = remainingURL.substring(0, remainingURL.indexOf(URL_SEPARATOR));
                    this.databaseName = remainingURL = remainingURL.substring(remainingURL.indexOf(URL_SEPARATOR) + 1);
                }
            }
            catch (Exception exception) {}
        }
    }
}

