/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.drivers;

import java.util.Properties;
import oracle.eclipse.tools.database.ui.drivers.IDriverOptionalUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OracleClientInstallDirectoryContributor
implements IDriverOptionalUIContributor {
    private boolean isReadOnly;
    private Properties properties;
    private Text clientDirText;
    private Button browseBtn;
    private ModifyListener textListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!OracleClientInstallDirectoryContributor.this.isReadOnly) {
                OracleClientInstallDirectoryContributor.this.setConnectionInformation();
            }
        }
    };
    private static final String CLIENT_INSTALL_DIR_PROP_ID = "oracle.eclipse.tools.database.clientInstallDirectory";

    @Override
    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        Composite parentComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        parentComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parentComposite.setLayout((Layout)layout);
        Label clientDirLabel = new Label(parentComposite, 0);
        clientDirLabel.setText("Oracle Install Directory:");
        int style = isReadOnly ? 2056 : 2048;
        this.clientDirText = new Text(parentComposite, style);
        GridData gdata = new GridData(768);
        this.clientDirText.setLayoutData((Object)gdata);
        this.browseBtn = new Button(parentComposite, 8);
        this.browseBtn.setText("Browse");
        this.addListeners();
        return parentComposite;
    }

    private void addListeners() {
        this.clientDirText.addModifyListener(this.textListener);
    }

    private void removeListeners() {
        this.clientDirText.removeModifyListener(this.textListener);
    }

    @Override
    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.properties = contributorInformation.getProperties();
    }

    @Override
    public void loadProperties() {
        this.removeListeners();
        String installDir = this.properties.getProperty(CLIENT_INSTALL_DIR_PROP_ID);
        if (installDir != null) {
            this.clientDirText.setText(installDir);
        }
        this.addListeners();
    }

    @Override
    public boolean validateControl(DialogPage page) {
        return true;
    }

    public void setConnectionInformation() {
        this.properties.setProperty(CLIENT_INSTALL_DIR_PROP_ID, this.clientDirText.getText());
    }
}

