/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageBodyFolder;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.navigator.CommonViewer;

public class ShowErrorAction
extends Action {
    protected CommonViewer viewer;
    private ISelection selection;
    private static String getErrorTextQuery = "SELECT LINE, REPLACE(TEXT, CHR(10), ' '), ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ORDER BY ATTRIBUTE, LINE, POSITION";
    private static final String NEWLINE = System.getProperty("line.separator");

    public ShowErrorAction() {
        this.setText(DBToolsUiMessages.dseShowError);
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
    }

    public void run() {
        if (this.selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)this.selection;
            for (Object item : ss) {
                if (item instanceof PackageBodyFolder) {
                    OraclePackage owningPackage = (OraclePackage)((IVirtualNode)item).getParent();
                    item = owningPackage.getBody();
                }
                if (!(item instanceof OracleObject)) continue;
                OracleObject oo = (OracleObject)item;
                String errorMsg = this.getErrorText(oo);
                if (errorMsg == null || errorMsg.length() == 0) {
                    errorMsg = String.format(DBToolsUiMessages.unableToGetErrorMsg, oo.getName());
                }
                String title = String.format(DBToolsUiMessages.showErrorTitle, oo.getName());
                MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 2);
                msgBox.setText(title);
                msgBox.setMessage(errorMsg);
                msgBox.open();
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        this.selection = selection;
    }

    private String getErrorText(OracleObject oracleObj) {
        StringBuffer temp;
        block19: {
            PreparedStatement stmt = null;
            ResultSet r = null;
            temp = new StringBuffer();
            try {
                try {
                    Connection con = oracleObj.getConnection();
                    stmt = con.prepareStatement(getErrorTextQuery);
                    stmt.setString(1, oracleObj.getName());
                    stmt.setString(2, oracleObj.getOracleType());
                    stmt.setString(3, oracleObj.getOwner());
                    r = stmt.executeQuery();
                    boolean first = true;
                    while (r.next()) {
                        if (!first) {
                            temp.append(NEWLINE);
                            temp.append(NEWLINE);
                        }
                        String lineNo = r.getString(1);
                        String text = r.getString(2);
                        String attr = r.getString(3);
                        String msg = String.format(DBToolsUiMessages.showErrorText, attr, lineNo, text);
                        temp.append(msg);
                        first = false;
                    }
                }
                catch (SQLException e) {
                    MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 1);
                    msgBox.setText(DBToolsUiMessages.showErrorErrorTitle);
                    msgBox.setMessage(e.getLocalizedMessage());
                    msgBox.open();
                    try {
                        if (r != null) {
                            r.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block19;
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
            }
        }
        return temp.toString();
    }
}

