/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.sql.SQLException;
import java.sql.Statement;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlBuilder;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.actions.PrivilegeAction;
import oracle.eclipse.tools.database.ui.editors.RevokePrivilegeDialog;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class RevokeAction
extends PrivilegeAction {
    public RevokeAction() {
        this.setText(DBToolsUiMessages.dseRevoke);
    }

    @Override
    public void run() {
        DatabaseObject dbObj = super.getDBObject();
        RevokePrivilegeDialog revokeDlg = new RevokePrivilegeDialog(DBToolsUiMessages.revokeDlgTitle, this.po, dbObj);
        revokeDlg.create();
        Statement stmt = null;
        if (revokeDlg.open() == 0) {
            try {
                try {
                    String[] privileges = revokeDlg.getSelectedPrivileges();
                    String selectedUser = revokeDlg.getSelectedUser();
                    stmt = dbObj.getConnection().createStatement();
                    String query = new OracleDdlBuilder().createRevokeQuery(dbObj, (Object[])revokeDlg.getSelectedPrivileges(), selectedUser);
                    stmt.executeQuery(query);
                    StringBuffer privilegeBuf = new StringBuffer();
                    int i = 0;
                    while (i < privileges.length) {
                        if (i > 0) {
                            privilegeBuf.append(", ");
                        }
                        privilegeBuf.append(privileges[i]);
                        ++i;
                    }
                    String msg = String.format(DBToolsUiMessages.revokeSuccessMsg, privilegeBuf.toString(), dbObj.getName(), selectedUser);
                    MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell());
                    msgBox.setText(DBToolsUiMessages.revokeSuccessTitle);
                    msgBox.setMessage(msg);
                    msgBox.open();
                }
                catch (SQLException e) {
                    MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 1);
                    msgBox.setText(DBToolsUiMessages.revokeErrorMsg);
                    msgBox.setMessage(e.getLocalizedMessage());
                    msgBox.open();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                }
            }
        }
    }
}

