/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleComposedType;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDirectory;
import oracle.eclipse.tools.database.connectivity.catalog.OracleFunction;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OracleProcedure;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSequence;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.navigator.CommonViewer;

public abstract class PrivilegeAction
extends Action {
    protected CommonViewer viewer;
    protected IPrivilegeObject po = null;
    protected DatabaseObject dbObject = null;

    public abstract void run();

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
    }

    public DatabaseObject getDBObject() {
        if (this.dbObject == null) {
            ICatalogObject co = (ICatalogObject)this.po;
            OracleObject oo = (OracleObject)this.po;
            String object = ((SQLObject)this.po).getName();
            String objectType = null;
            String owner = null;
            if (this.po instanceof ViewTable) {
                objectType = "VIEW";
                owner = ((ViewTable)this.po).getSchema().getName();
            } else if (this.po instanceof Table) {
                objectType = "TABLE";
                owner = ((OracleTable)this.po).getSchema().getName();
            } else if (this.po instanceof Procedure) {
                objectType = "PROCEDURE";
                owner = ((OracleProcedure)this.po).getSchema().getName();
            } else if (this.po instanceof Sequence) {
                objectType = "SEQUENCE";
                owner = ((OracleSequence)this.po).getSchema().getName();
            } else if (this.po instanceof UserDefinedFunction) {
                objectType = "FUNCTION";
                owner = ((OracleFunction)this.po).getSchema().getName();
            } else if (this.po instanceof OraclePackage) {
                objectType = "PACKAGE";
                owner = ((OraclePackage)this.po).getSchema().getName();
            } else if (this.po instanceof OracleDirectory) {
                objectType = "DIRECTORY";
                owner = ((OracleDirectory)this.po).getSchema().getName();
            } else if (this.po instanceof UserDefinedType) {
                objectType = "TYPE";
                owner = ((OracleComposedType)this.po).getSchema().getName();
            }
            this.dbObject = new DatabaseObject();
            this.dbObject.setName(object);
            this.dbObject.setType(objectType);
            this.dbObject.setId(oo.getId());
            this.dbObject.setOwner(owner);
            this.dbObject.setConnection(co.getConnection());
        }
        return this.dbObject;
    }

    public void selectionChanged(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            Object item = ss.getFirstElement();
            this.po = (IPrivilegeObject)item;
            this.dbObject = null;
        }
    }
}

