/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.editors.SourceInput;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class OpenViewAction
extends Action {
    private final IWorkbenchWindow window;
    private final String viewId;
    private DatabaseObject dataObject;

    public OpenViewAction(IWorkbenchWindow window, String label, String viewId, DatabaseObject dataObject, int instance) {
        this.window = window;
        this.viewId = viewId;
        this.dataObject = dataObject;
        this.setText(label);
        this.setId("table.open");
        this.setActionDefinitionId("table.open");
    }

    public void run() {
        this.runInternal();
    }

    public IEditorPart runInternal() {
        IEditorPart editor = null;
        if (this.window != null) {
            try {
                if (this.viewId.equals("editor")) {
                    SourceInput editorInput = new SourceInput(this.dataObject);
                    editor = this.window.getActivePage().openEditor((IEditorInput)editorInput, "SqlEditor", true);
                } else {
                    SourceInput editorInput = new SourceInput(this.dataObject);
                    editorInput.setTooltip(this.dataObject.getName());
                    editor = this.window.getActivePage().openEditor((IEditorInput)editorInput, "objectEditor");
                    editor.setFocus();
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)DBToolsUiMessages.ObjectOpen_ErrorTitle, (String)(String.valueOf(DBToolsUiMessages.ObjectOpen_ErrorMsg) + e.getMessage()));
            }
        }
        return editor;
    }
}

