/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleTableNode;
import oracle.eclipse.tools.database.ui.wizards.CreateNewTableWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class NewTableAction
extends Action {
    private CommonViewer viewer;
    private ITreeContentProvider treeContentProvider;
    private ISelection selection;

    public NewTableAction() {
        this.setText(DBToolsUiMessages.dseNewTable);
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            this.treeContentProvider = (ITreeContentProvider)provider;
        }
    }

    public void selectionChanged(ISelection selection) {
        this.selection = selection;
    }

    public void run() {
        CreateNewTableWizard newTableWiz = new CreateNewTableWizard();
        newTableWiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)this.selection);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newTableWiz);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode == 0 && this.selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)this.selection;
            Object item = ss.getFirstElement();
            if (item instanceof OracleSchema) {
                Object[] expandedNodes;
                ((OracleSchema)item).refresh("TABLE");
                Object[] objectArray = expandedNodes = this.viewer.getExpandedElements();
                int n = expandedNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof OracleTableNode) {
                        this.viewer.refresh(obj, true);
                    }
                    ++n2;
                }
            } else {
                Object parentNode = this.treeContentProvider.getParent(item);
                if (item instanceof OracleTableNode && parentNode instanceof OracleSchema) {
                    OracleSchema oraSchema = (OracleSchema)parentNode;
                    oraSchema.refresh("TABLE");
                    this.viewer.refresh(item, true);
                }
            }
        }
    }
}

