/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.sql.SQLException;
import java.sql.Statement;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlBuilder;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.actions.PrivilegeAction;
import oracle.eclipse.tools.database.ui.editors.GrantPrivilegeDialog;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

public class GrantAction
extends PrivilegeAction {
    public GrantAction() {
        this.setText(DBToolsUiMessages.dseGrant);
    }

    @Override
    public void run() {
        GrantPrivilegeDialog dlg = new GrantPrivilegeDialog(DBToolsUiMessages.grantDlgTitle, this.po);
        dlg.create();
        if (dlg.open() == 0) {
            Statement stmt = null;
            try {
                try {
                    Object[] privileges = dlg.getSelectedPrivileges();
                    String selectedUser = dlg.getSelectedUser();
                    stmt = super.getDBObject().getConnection().createStatement();
                    String query = new OracleDdlBuilder().createGrantQuery(super.getDBObject(), privileges, selectedUser);
                    stmt.executeQuery(query);
                    StringBuffer privilegeBuf = new StringBuffer();
                    int i = 0;
                    while (i < privileges.length) {
                        if (i > 0) {
                            privilegeBuf.append(", ");
                        }
                        privilegeBuf.append((String)privileges[i]);
                        ++i;
                    }
                    String msg = String.format(DBToolsUiMessages.grantSuccessMsg, privilegeBuf.toString(), super.getDBObject().getName(), selectedUser);
                    MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell());
                    msgBox.setText(DBToolsUiMessages.grantSuccessTitle);
                    msgBox.setMessage(msg);
                    msgBox.open();
                }
                catch (SQLException e) {
                    MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 1);
                    msgBox.setText(DBToolsUiMessages.grantErrorMsg);
                    msgBox.setMessage(e.getLocalizedMessage());
                    msgBox.open();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                }
            }
        }
    }
}

