/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.modelbase.db.Synonym;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageBodyFolder;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FEWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.navigator.CommonViewer;

public class GenerateDDLAction
extends Action {
    protected CommonViewer viewer;
    private ISelection selection;
    private List<SQLObject> sqlObjects = new ArrayList<SQLObject>();

    public GenerateDDLAction() {
        this.setText(DBToolsUiMessages.dseGenerateDDL);
        try {
            URL url = new URL("platform:/plugin/org.eclipse.datatools.connectivity.sqm.core.ui/icons/generate_code.gif");
            ImageDescriptor newImage = ImageDescriptor.createFromURL((URL)url);
            this.setImageDescriptor(newImage);
        }
        catch (MalformedURLException e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
    }

    public void run() {
        if (this.selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)this.selection;
            for (Object item : ss) {
                OraclePackage owningPackage;
                if (item instanceof OraclePackage) {
                    owningPackage = (OraclePackage)item;
                    this.sqlObjects.add((SQLObject)owningPackage.getSpecification());
                    continue;
                }
                if (item instanceof PackageBodyFolder) {
                    owningPackage = (OraclePackage)((IVirtualNode)item).getParent();
                    this.sqlObjects.add((SQLObject)owningPackage.getBody());
                    continue;
                }
                if (!(item instanceof Synonym)) continue;
                this.sqlObjects.add((SQLObject)((Synonym)item));
            }
        }
        if (this.sqlObjects.size() == 0) {
            return;
        }
        FEWizard wizard = new FEWizard(this.sqlObjects);
        WizardDialog dialog = new WizardDialog(this.viewer.getCommonNavigator().getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(ISelection selection) {
        this.sqlObjects.clear();
        this.selection = selection;
    }
}

