/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.sql.SQLException;
import java.sql.Statement;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.catalog.OracleRecycleBinObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.navigator.CommonViewer;

public class FlashbackAction
extends Action {
    private OracleRecycleBinObject recycleObject;
    protected CommonViewer viewer;
    private Object parentNode;
    private ITreeContentProvider treeContentProvider;

    public FlashbackAction() {
        this.setText(DBToolsUiMessages.dseFlashback);
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            this.treeContentProvider = (ITreeContentProvider)provider;
        }
    }

    public void run() {
        block14: {
            if (this.recycleObject == null) {
                return;
            }
            this.parentNode = this.treeContentProvider.getParent((Object)this.recycleObject);
            Statement stmt = null;
            try {
                try {
                    FlashbackConfirmDialog dialog = new FlashbackConfirmDialog(Display.getDefault().getActiveShell(), DBToolsUiMessages.flashbackDlgTitle, null, this.recycleObject);
                    if (dialog.open() == 0) {
                        String sql = dialog.getSql();
                        stmt = this.recycleObject.getConnection().prepareStatement(sql);
                        stmt.execute();
                        ((OracleSchema)this.recycleObject.getSchema()).refresh("RECYCLE BIN");
                        this.viewer.refresh(this.parentNode, true);
                    }
                }
                catch (SQLException e) {
                    MessageBox msgBox = new MessageBox(this.viewer.getCommonNavigator().getSite().getShell(), 1);
                    msgBox.setText(DBToolsUiMessages.flashbackErrorMsg);
                    msgBox.setMessage(e.getLocalizedMessage());
                    msgBox.open();
                    if (stmt == null) break block14;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        StructuredSelection ss;
        Object item;
        this.recycleObject = null;
        if (selection instanceof StructuredSelection && (item = (ss = (StructuredSelection)selection).getFirstElement()) instanceof OracleRecycleBinObject) {
            this.recycleObject = (OracleRecycleBinObject)item;
            if (this.recycleObject.getType().equals("TABLE")) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private static class FlashbackConfirmDialog
    extends MessageDialog {
        private OracleRecycleBinObject recycleBinObj;
        private Text objNameText;
        private Text sqlText;
        private String sql;
        private String flashbackSql = "flashback table \"%s\".\"%s\" to before drop rename to %s";

        public FlashbackConfirmDialog(Shell parentShell, String title, String msg, OracleRecycleBinObject recycleBinObj) {
            super(parentShell, title, null, msg, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.recycleBinObj = recycleBinObj;
        }

        protected Control createCustomArea(Composite parent) {
            Composite myparent = new Composite(parent, 0);
            FlashbackConfirmDialog.applyDialogFont((Control)myparent);
            GridLayout gl = new GridLayout(1, false);
            myparent.setLayout((Layout)gl);
            myparent.setLayoutData((Object)new GridData(1808));
            Composite nameComp = new Composite(myparent, 0);
            nameComp.setLayout((Layout)new GridLayout(2, false));
            nameComp.setLayoutData((Object)new GridData(768));
            Label objNameLabel = new Label(nameComp, 0);
            objNameLabel.setText(DBToolsUiMessages.flashbackObjNameLabel);
            this.objNameText = new Text(nameComp, 2048);
            this.objNameText.setLayoutData((Object)new GridData(768));
            this.objNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FlashbackConfirmDialog.this.handleNameChange();
                }
            });
            Group group = new Group(myparent, 0);
            group.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout(1, false);
            group.setLayout((Layout)layout);
            group.setText(DBToolsUiMessages.previewDDL);
            this.sqlText = new Text((Composite)group, 2826);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.widthHint = 500;
            gd.heightHint = 80;
            this.sqlText.setLayoutData((Object)gd);
            this.sqlText.setText(this.computeDDL(""));
            return myparent;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.getButton(this.getDefaultButtonIndex()).setEnabled(false);
            return control;
        }

        public String getSql() {
            return this.sql;
        }

        private void handleNameChange() {
            String objName = this.objNameText.getText().trim();
            if (objName != null && objName.length() > 0) {
                this.sql = this.computeDDL(objName);
                this.sqlText.setText(this.sql);
                this.getButton(0).setEnabled(true);
            } else {
                this.getButton(0).setEnabled(false);
            }
        }

        private String computeDDL(String newName) {
            String temp = String.format(this.flashbackSql, this.recycleBinObj.getSchema().getName(), this.recycleBinObj.getObjectName(), newName);
            return temp;
        }
    }
}

