/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageBodyFolder;
import oracle.eclipse.tools.database.ui.util.DSEUtil;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class EditAction
extends Action {
    protected CommonViewer viewer;
    private SQLObject editableObject;

    public EditAction() {
        this.setText(DBToolsUiMessages.dseEdit);
        try {
            URL url = new URL("platform:/plugin/org.eclipse.datatools.sqltools.routineeditor.ui/icons/routine_editor.gif");
            ImageDescriptor newImage = ImageDescriptor.createFromURL((URL)url);
            this.setImageDescriptor(newImage);
        }
        catch (MalformedURLException e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    public void run() {
        if (this.editableObject == null) {
            return;
        }
        ProcIdentifier proc = DSEUtil.getProcIdentifier(this.editableObject);
        IEditorPart parent = null;
        try {
            IWorkbenchPage page;
            if (proc != null && (parent = this.openEditor(proc, page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage())) == null) {
                return;
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    public void selectionChanged(ISelection selection) {
        this.editableObject = null;
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            Object item = ss.getFirstElement();
            if (item instanceof OraclePackage) {
                this.editableObject = (OraclePackage)item;
            } else if (item instanceof PackageBodyFolder) {
                OraclePackage owningPackage = (OraclePackage)((IVirtualNode)item).getParent();
                this.editableObject = owningPackage.getBody();
            }
        }
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
    }

    protected IEditorPart openEditor(ProcIdentifier proc, IWorkbenchPage page) throws PartInitException {
        return page.openEditor((IEditorInput)new ProcEditorInput(proc), "org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditor");
    }
}

