/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.catalog.OracleColumn;
import oracle.eclipse.tools.database.connectivity.catalog.OracleComposedType;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabaseLink;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDirectory;
import oracle.eclipse.tools.database.connectivity.catalog.OracleIndex;
import oracle.eclipse.tools.database.connectivity.catalog.OracleMaterializedView;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePublicSynonym;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSequence;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSynonym;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.catalog.OracleView;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlBuilder;
import oracle.eclipse.tools.database.modelbase.db.DatabaseLink;
import oracle.eclipse.tools.database.modelbase.db.Directory;
import oracle.eclipse.tools.database.modelbase.db.MaterializedView;
import oracle.eclipse.tools.database.modelbase.db.OraPackage;
import oracle.eclipse.tools.database.modelbase.db.OraSequence;
import oracle.eclipse.tools.database.modelbase.db.PackageBody;
import oracle.eclipse.tools.database.modelbase.db.Synonym;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageBodyFolder;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.sqleditor.result.GroupSQLResultRunnable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class DropAction
extends Action {
    private ISelection selection;
    private List<SQLObject> dropableObjects = new ArrayList<SQLObject>();
    private List parentNodes = new ArrayList();
    private List<String> refreshTypes = new ArrayList<String>();
    private static String LINE_RETURN = System.getProperty("line.separator");
    private CommonViewer viewer;
    private ITreeContentProvider treeContentProvider;
    private OracleSchema oracleSchema;
    private ICatalogObject parentObject = null;

    public DropAction() {
        this.setText(DBToolsUiMessages.dseDrop);
        try {
            URL url = new URL("platform:/plugin/org.eclipse.datatools.sqltools.routineeditor.ui/icons/drop.gif");
            ImageDescriptor newImage = ImageDescriptor.createFromURL((URL)url);
            this.setImageDescriptor(newImage);
        }
        catch (MalformedURLException e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    public void run() {
        this.getDropableObjects();
        String title = DBToolsUiMessages.dropTitle;
        String message = DBToolsUiMessages.dropDesc;
        DropConfirmDialog dialog = new DropConfirmDialog(Display.getDefault().getActiveShell(), title, message, this.dropableObjects);
        if (dialog.open() == 0) {
            this.executeDDL(dialog.getSQLStatements());
        }
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            this.treeContentProvider = (ITreeContentProvider)provider;
        }
    }

    private void executeDDL(String[] sqlStatements) {
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(this.getProfileName(), "");
        try {
            String message = DBToolsUiMessages.dropObjects;
            GroupSQLResultRunnable job = new GroupSQLResultRunnable(null, sqlStatements, null, null, databaseIdentifier, false, new HashMap(), message, DBToolsUiMessages.dropTitle);
            job.setName(message);
            job.setUser(true);
            job.schedule();
            job.join();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.datatools.sqltools.result.resultView");
            this.refreshSchemaAndDSE();
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    private String getProfileName() {
        if (this.viewer != null) {
            Object item = this.dropableObjects.size() > 0 ? this.dropableObjects.get(0) : null;
            while (item != null) {
                if (!((item = this.treeContentProvider.getParent(item)) instanceof IConnectionProfile)) continue;
                return ((IConnectionProfile)item).getName();
            }
        }
        return null;
    }

    public void selectionChanged(ISelection selection) {
        this.dropableObjects.clear();
        this.refreshTypes.clear();
        this.parentNodes.clear();
        this.parentObject = null;
        this.selection = selection;
    }

    private void getDropableObjects() {
        if (this.selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)this.selection;
            for (Object item : ss) {
                OracleSynonym syn;
                PackageBody dropableObject = null;
                Object parentNode = this.treeContentProvider.getParent(item);
                String refreshType = null;
                if (item instanceof PackageBodyFolder) {
                    OraclePackage owningPackage = (OraclePackage)((IVirtualNode)item).getParent();
                    dropableObject = owningPackage.getBody();
                    this.oracleSchema = (OracleSchema)owningPackage.getSchema();
                    parentNode = this.treeContentProvider.getParent((Object)owningPackage);
                    refreshType = "PACKAGE BODY";
                } else if (item instanceof OraclePackage) {
                    OraclePackage oraPack = (OraclePackage)item;
                    dropableObject = oraPack;
                    this.oracleSchema = (OracleSchema)oraPack.getSchema();
                    refreshType = "PACKAGE";
                } else if (item instanceof OracleComposedType) {
                    OracleComposedType dbType = (OracleComposedType)item;
                    dropableObject = dbType;
                    this.oracleSchema = (OracleSchema)dbType.getSchema();
                    refreshType = "TYPE";
                } else if (item instanceof OracleDatabaseLink) {
                    OracleDatabaseLink dbLink = (OracleDatabaseLink)item;
                    dropableObject = dbLink;
                    this.oracleSchema = (OracleSchema)dbLink.getSchema();
                    refreshType = "DATABASE LINK";
                } else if (item instanceof OracleDirectory) {
                    OracleDirectory dbDir = (OracleDirectory)item;
                    dropableObject = dbDir;
                    this.oracleSchema = (OracleSchema)dbDir.getSchema();
                    refreshType = "DIRECTORY";
                } else if (item instanceof OracleMaterializedView) {
                    OracleMaterializedView dbMat = (OracleMaterializedView)item;
                    dropableObject = dbMat;
                    this.oracleSchema = (OracleSchema)dbMat.getSchema();
                    refreshType = "MATERIALIZED VIEW";
                } else if (item instanceof OraclePublicSynonym) {
                    OraclePublicSynonym pubSyn = (OraclePublicSynonym)item;
                    dropableObject = pubSyn;
                    this.oracleSchema = (OracleSchema)pubSyn.getSchema();
                    refreshType = "PUBLIC SYNONYM";
                } else if (item instanceof OracleSequence) {
                    OracleSequence seq = (OracleSequence)item;
                    dropableObject = seq;
                    this.oracleSchema = (OracleSchema)seq.getSchema();
                    refreshType = "SEQUENCE";
                } else if (item instanceof OracleSynonym) {
                    syn = (OracleSynonym)item;
                    dropableObject = syn;
                    this.oracleSchema = (OracleSchema)syn.getSchema();
                    refreshType = "SYNONYM";
                } else if (item instanceof OraclePublicSynonym) {
                    syn = (OraclePublicSynonym)item;
                    dropableObject = syn;
                    this.oracleSchema = (OracleSchema)syn.getSchema();
                    refreshType = "PUBLIC SYNONYM";
                } else if (item instanceof OracleTable) {
                    OracleTable table = (OracleTable)item;
                    dropableObject = table;
                    this.oracleSchema = (OracleSchema)table.getSchema();
                    refreshType = "TABLE";
                } else if (item instanceof OracleView) {
                    OracleView view = (OracleView)item;
                    dropableObject = view;
                    this.oracleSchema = (OracleSchema)view.getSchema();
                    refreshType = "VIEW";
                } else if (item instanceof OracleIndex) {
                    OracleIndex index = (OracleIndex)item;
                    dropableObject = index;
                    this.oracleSchema = (OracleSchema)index.getSchema();
                    this.parentObject = (OracleTable)index.getTable();
                } else if (item instanceof TableConstraint) {
                    TableConstraint tc = (TableConstraint)item;
                    dropableObject = tc;
                    this.oracleSchema = (OracleSchema)tc.getBaseTable().getSchema();
                    this.parentObject = (OracleTable)tc.getBaseTable();
                } else if (item instanceof OracleColumn) {
                    OracleColumn oc = (OracleColumn)item;
                    dropableObject = oc;
                    this.oracleSchema = (OracleSchema)oc.getTable().getSchema();
                    this.parentObject = (OracleTable)oc.getTable();
                }
                this.dropableObjects.add((SQLObject)dropableObject);
                if (!this.parentNodes.contains(parentNode)) {
                    this.parentNodes.add(parentNode);
                }
                this.refreshTypes.add(refreshType);
            }
        }
    }

    private static String[] getDDLs(boolean cascadeConstraints, List<SQLObject> dropableObjects) {
        String[] ddls = null;
        if (dropableObjects.size() > 0) {
            OracleDdlBuilder builder = new OracleDdlBuilder();
            ddls = new String[dropableObjects.size()];
            Iterator<SQLObject> it = dropableObjects.iterator();
            int index = 0;
            while (it.hasNext()) {
                SQLObject sqlObj = it.next();
                boolean quoteIdentifiers = true;
                boolean qualifyNames = true;
                if (sqlObj instanceof DatabaseLink || sqlObj instanceof Directory) {
                    quoteIdentifiers = false;
                    qualifyNames = false;
                }
                String dropStmt = null;
                if (sqlObj instanceof PackageBody) {
                    dropStmt = builder.dropPackageBody((PackageBody)sqlObj, quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OraclePackage) {
                    dropStmt = builder.dropPackage((OraPackage)((OraclePackage)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleComposedType) {
                    dropStmt = builder.dropUserDefinedType((UserDefinedType)((OracleComposedType)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleDatabaseLink) {
                    dropStmt = builder.dropDatabaseLink((DatabaseLink)((OracleDatabaseLink)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleDirectory) {
                    dropStmt = builder.dropDirectory((Directory)((OracleDirectory)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleMaterializedView) {
                    dropStmt = builder.dropMaterializedView((MaterializedView)((OracleMaterializedView)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleSynonym) {
                    dropStmt = builder.dropSynonym((Synonym)((OracleSynonym)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OraclePublicSynonym) {
                    dropStmt = builder.dropSynonym((Synonym)((OraclePublicSynonym)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleSequence) {
                    dropStmt = builder.dropSequence((OraSequence)((OracleSequence)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleTable) {
                    dropStmt = cascadeConstraints ? builder.dropTableCascadeConstraints((BaseTable)((OracleTable)sqlObj), quoteIdentifiers, qualifyNames) : builder.dropTable((BaseTable)((OracleTable)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleView) {
                    dropStmt = builder.dropView((ViewTable)((OracleView)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleIndex) {
                    dropStmt = builder.dropIndex((Index)((OracleIndex)sqlObj), quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof TableConstraint) {
                    dropStmt = builder.dropTableConstraint((TableConstraint)sqlObj, quoteIdentifiers, qualifyNames);
                } else if (sqlObj instanceof OracleColumn) {
                    dropStmt = builder.dropTableColumn((OracleColumn)sqlObj, cascadeConstraints, quoteIdentifiers, qualifyNames);
                }
                ddls[index++] = dropStmt;
            }
        }
        return ddls;
    }

    private void refreshSchemaAndDSE() {
        if (this.parentObject != null) {
            this.parentObject.refresh();
        } else {
            Iterator<SQLObject> it = this.dropableObjects.iterator();
            Iterator<String> typeIt = this.refreshTypes.iterator();
            while (it.hasNext() && typeIt.hasNext()) {
                SQLObject dropableObject = it.next();
                String refreshType = typeIt.next();
                if (dropableObject instanceof OraclePublicSynonym) {
                    this.oracleSchema.refreshSynonyms(true);
                    continue;
                }
                if (dropableObject instanceof OracleSynonym) {
                    this.oracleSchema.refreshSynonyms(false);
                    continue;
                }
                this.oracleSchema.refresh(refreshType);
            }
        }
        for (Object parentNode : this.parentNodes) {
            this.viewer.refresh(parentNode, true);
        }
    }

    private static class DropConfirmDialog
    extends MessageDialog {
        private boolean cascadeConstraints = true;
        private List<SQLObject> dropableObjects;
        private String[] sqlStatements;
        private String sql;

        public DropConfirmDialog(Shell parentShell, String title, String msg, List<SQLObject> dropableObjects) {
            super(parentShell, title, null, msg, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.dropableObjects = dropableObjects;
            this.sqlStatements = DropAction.getDDLs(this.cascadeConstraints, this.dropableObjects);
            this.sql = this.getAsOneString(this.sqlStatements);
        }

        protected Control createCustomArea(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(DBToolsUiMessages.previewDDL);
            GridLayout layout = new GridLayout(1, false);
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(1808));
            DropConfirmDialog.applyDialogFont((Control)group);
            final Text text = new Text((Composite)group, 2826);
            text.setText(this.sql);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.horizontalAlignment = 4;
            gd.widthHint = 260;
            gd.heightHint = 200;
            text.setLayoutData((Object)gd);
            if (this.includeCascadeOption()) {
                final Button cascadeCheck = new Button(parent, 32);
                cascadeCheck.setText(DBToolsUiMessages.cascadeConstraints);
                cascadeCheck.setSelection(this.cascadeConstraints);
                cascadeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DropConfirmDialog.this.cascadeConstraints = cascadeCheck.getSelection();
                        DropConfirmDialog.this.sqlStatements = DropAction.getDDLs(DropConfirmDialog.this.cascadeConstraints, DropConfirmDialog.this.dropableObjects);
                        DropConfirmDialog.this.sql = DropConfirmDialog.this.getAsOneString(DropConfirmDialog.this.sqlStatements);
                        text.setText(DropConfirmDialog.this.sql);
                    }
                });
            }
            return group;
        }

        public String[] getSQLStatements() {
            return this.sqlStatements;
        }

        private String getAsOneString(String[] stmts) {
            StringBuffer buf = new StringBuffer();
            String[] stringArray = this.sqlStatements;
            int n = this.sqlStatements.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                buf.append(str);
                buf.append(";");
                buf.append(LINE_RETURN);
                buf.append(LINE_RETURN);
                ++n2;
            }
            return buf.toString();
        }

        private boolean includeCascadeOption() {
            boolean ret = false;
            for (SQLObject obj : this.dropableObjects) {
                if (!(obj instanceof OracleTable) && !(obj instanceof OracleColumn)) continue;
                ret = true;
                break;
            }
            return ret;
        }
    }
}

