/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleFunction;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageBody;
import oracle.eclipse.tools.database.connectivity.catalog.OracleProcedure;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTrigger;
import oracle.eclipse.tools.database.connectivity.catalog.OracleView;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.db.SourceUtil;
import oracle.eclipse.tools.database.connectivity.editors.SourceInput;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageBodyFolder;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.navigator.CommonViewer;

public class CompileAction
extends Action {
    private CommonViewer viewer;
    private ITreeContentProvider treeContentProvider;
    private Object parentNode;
    private String refreshType;
    private OracleObject oracleObject;
    private Schema schema;
    private ISelection selection;

    public CompileAction() {
        this.setText(DBToolsUiMessages.dseCompile);
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            this.treeContentProvider = (ITreeContentProvider)provider;
        }
    }

    public void selectionChanged(ISelection selection) {
        this.oracleObject = null;
        this.selection = selection;
    }

    public void run() {
        this.getOracleObject();
        if (this.oracleObject == null) {
            return;
        }
        Connection connection = ((OracleSchema)this.schema).getConnection();
        Statement replaceStmt = null;
        Statement compileStmt = null;
        try {
            try {
                int majorVer = connection.getMetaData().getDatabaseMajorVersion();
                String source = this.getObjectSource();
                boolean isWin = System.getProperty("os.name").startsWith("Win");
                if (majorVer < 11 && isWin && source.indexOf("\r\n") != -1) {
                    source = source.replaceAll("\r\n", "\n");
                    String replaceSql = "CREATE OR REPLACE " + source;
                    replaceStmt = connection.createStatement();
                    replaceStmt.execute(replaceSql);
                }
                String qualifiedName = "\"" + this.oracleObject.getOwner() + "\".\"" + this.oracleObject.getName() + "\"";
                String type = this.oracleObject.getOracleType().equals("PACKAGE BODY") ? "PACKAGE" : this.oracleObject.getOracleType();
                String compileSql = "alter " + type + " " + qualifiedName + " compile";
                if (this.oracleObject.getOracleType().equals("PACKAGE BODY")) {
                    compileSql = String.valueOf(compileSql) + " body";
                }
                compileStmt = connection.createStatement();
                compileStmt.execute(compileSql);
                if (this.oracleObject instanceof OracleTrigger) {
                    OracleTable otable = (OracleTable)this.treeContentProvider.getParent(this.parentNode);
                    otable.refreshTrigger();
                } else {
                    ((OracleSchema)this.schema).refresh(this.refreshType);
                }
                this.viewer.refresh(this.parentNode, true);
                String msg = String.format(DBToolsUiMessages.compileSuccessMsg, qualifiedName);
                MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell());
                msgBox.setText(DBToolsUiMessages.compileSuccessTitle);
                msgBox.setMessage(msg);
                msgBox.open();
            }
            catch (SQLException e) {
                MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 1);
                msgBox.setText(DBToolsUiMessages.compileErrorMsg);
                msgBox.setMessage(e.getLocalizedMessage());
                msgBox.open();
                try {
                    if (replaceStmt != null) {
                        replaceStmt.close();
                    }
                    if (compileStmt != null) {
                        compileStmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (replaceStmt != null) {
                    replaceStmt.close();
                }
                if (compileStmt != null) {
                    compileStmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
            }
        }
    }

    private void getOracleObject() {
        if (this.selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)this.selection;
            Object item = ss.getFirstElement();
            this.parentNode = this.treeContentProvider.getParent(item);
            if (item instanceof OraclePackage) {
                this.oracleObject = (OraclePackage)item;
                this.schema = ((OraclePackage)item).getSchema();
                this.refreshType = "PACKAGE";
            } else if (item instanceof PackageBodyFolder) {
                OraclePackage owningPackage = (OraclePackage)((IVirtualNode)item).getParent();
                this.parentNode = this.treeContentProvider.getParent((Object)owningPackage);
                this.oracleObject = (OraclePackageBody)owningPackage.getBody();
                this.schema = owningPackage.getSchema();
                this.refreshType = "PACKAGE BODY";
            } else if (item instanceof OracleProcedure) {
                this.oracleObject = (OracleProcedure)item;
                this.schema = ((OracleProcedure)item).getSchema();
                this.refreshType = "PROCEDURE";
            } else if (item instanceof OracleFunction) {
                this.oracleObject = (OracleFunction)item;
                this.schema = ((OracleFunction)item).getSchema();
                this.refreshType = "FUNCTION";
            } else if (item instanceof OracleView) {
                this.oracleObject = (OracleView)item;
                this.schema = ((OracleView)item).getSchema();
                this.refreshType = "VIEW";
            } else if (item instanceof OracleTrigger) {
                this.oracleObject = (OracleTrigger)item;
                this.schema = ((OracleTrigger)item).getSchema();
                this.refreshType = "TRIGGER";
            }
        }
    }

    private String getObjectSource() {
        DatabaseObject dbObject = new DatabaseObject();
        dbObject.setName(this.oracleObject.getName());
        dbObject.setType(this.oracleObject.getOracleType());
        dbObject.setId(this.oracleObject.getId());
        dbObject.setOwner(this.schema.getName());
        dbObject.setOracleObject(this.oracleObject);
        SourceInput si = new SourceInput(dbObject);
        SourceUtil su = new SourceUtil();
        su.setConnection(((OracleSchema)this.schema).getConnection());
        return su.getSource(si, false, false, true);
    }
}

