/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities;

import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.model.RootNode;
import oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities.ColumnNode;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class TableNode
extends RootNode {
    private Table table;

    public TableNode() {
        this.setImage(OracleDBUIPlugin.getInstance().getImage("icons/table.png"));
    }

    public TableNode(Table table) {
        this();
        this.setTable(table);
    }

    public void setTable(Table table) {
        this.setName(table.getName());
        this.table = table;
        EList columns = table.getColumns();
        for (Column col : columns) {
            ColumnNode colNode = new ColumnNode(col, this);
            colNode.setNodeDiagramModel(this.getNodeDiagramModel());
            this.addChild((Node)colNode);
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void refreshColumnType() {
        this.setTooltip(this.getTooltipText());
        List children = this.getAllChildren();
        for (Node child : children) {
            assert (child instanceof ColumnNode);
            ((ColumnNode)child).refreshCoumnType();
        }
    }

    private String getTooltipText() {
        StringBuffer buf = new StringBuffer();
        if (this.table instanceof BaseTable) {
            buf.append("Name             ");
            buf.append(this.table.getName());
            BaseTable btable = (BaseTable)this.table;
            if (btable.getPrimaryKey() != null) {
                buf.append("\n");
                EList pkCols = btable.getPrimaryKey().getMembers();
                buf.append("Primary Key   ");
                int i = 0;
                while (i < pkCols.size()) {
                    buf.append(((Column)pkCols.get(i)).getName());
                    if (i < pkCols.size() - 1) {
                        buf.append(" ");
                    }
                    ++i;
                }
            }
        }
        return buf.toString();
    }
}

