/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.common.ui.diagram.model.NodeRelationship;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities.ColumnNode;
import oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities.TableNode;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class SchemaDiagramModel
extends NodeDiagramModel {
    private Schema schema;
    private HashMap<Table, TableNode> tableNodeMap = new HashMap();

    public SchemaDiagramModel(Schema schema) throws InterruptedException {
        this.schema = schema;
        this.setModelName(schema.getName());
        this.buildSchemaModel();
    }

    public Node getModelObject(Object obj) {
        if (obj == null) {
            return null;
        }
        for (Table keyObj : this.tableNodeMap.keySet()) {
            if (!(keyObj instanceof BaseTable) || !((BaseTable)keyObj).getName().equals((String)obj)) continue;
            return (Node)this.tableNodeMap.get(keyObj);
        }
        return null;
    }

    public void refreshColumnType(IProgressMonitor monitor) {
        monitor.beginTask(Resources.refreshColumnTypeTaskName, this.tableNodeMap.keySet().size());
        for (Table table : this.tableNodeMap.keySet()) {
            if (table instanceof BaseTable) {
                TableNode srcTableNode = this.tableNodeMap.get(table);
                if (!monitor.isCanceled()) {
                    srcTableNode.refreshColumnType();
                    monitor.worked(1);
                }
            }
            monitor.done();
        }
    }

    private void buildSchemaModel() throws InterruptedException {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SchemaDiagramModel.this.buildSchemaModel(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    private void buildSchemaModel(IProgressMonitor monitor) throws InterruptedException {
        EList tables = this.schema.getTables();
        monitor.beginTask(Resources.buildSchemaModelTaskName, tables.size());
        for (Table table : tables) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (table instanceof ViewTable) continue;
            TableNode tableNode = new TableNode(table);
            tableNode.setNodeDiagramModel(this);
            this.addNode((Node)tableNode);
            this.tableNodeMap.put(table, tableNode);
            monitor.worked(1);
        }
        this.buildForeignKeyRelationships(monitor);
        monitor.done();
    }

    private void buildForeignKeyRelationships(IProgressMonitor monitor) {
        monitor.subTask(Resources.buildForeignKeyRelationshipTaskName);
        for (Table table : this.tableNodeMap.keySet()) {
            if (!(table instanceof BaseTable)) continue;
            TableNode srcTableNode = this.tableNodeMap.get(table);
            BaseTable baseTable = (BaseTable)table;
            List foreignKeys = baseTable.getForeignKeys();
            for (ForeignKey foreighKey : foreignKeys) {
                BaseTable referencedTable = foreighKey.getUniqueConstraint().getBaseTable();
                if (referencedTable == null || !this.tableNodeMap.containsKey(referencedTable)) continue;
                TableNode destTableNode = this.tableNodeMap.get(referencedTable);
                EList srcCols = foreighKey.getMembers();
                EList destCols = foreighKey.getUniqueConstraint().getMembers();
                assert (srcCols.size() == destCols.size());
                int i = 0;
                while (i < srcCols.size()) {
                    Column srcCol = (Column)srcCols.get(i);
                    Column destCol = (Column)destCols.get(i);
                    ColumnNode srcNode = (ColumnNode)srcTableNode.findChild(srcCol.getName());
                    ColumnNode destNode = (ColumnNode)destTableNode.findChild(destCol.getName());
                    assert (srcNode != null);
                    assert (destNode != null);
                    NodeRelationship nodeRelation = new NodeRelationship((Node)srcNode, (Node)destNode, false);
                    nodeRelation.setNodeDiagramModel((NodeDiagramModel)this);
                    StringBuffer tooltip = new StringBuffer();
                    tooltip.append("FK ");
                    tooltip.append(table.getName());
                    tooltip.append(":");
                    tooltip.append(srcNode.getName());
                    tooltip.append(" -> PK ");
                    tooltip.append(referencedTable.getName());
                    tooltip.append(":");
                    tooltip.append(destNode.getName());
                    nodeRelation.setTooltip(tooltip.toString());
                    ++i;
                }
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String refreshColumnTypeTaskName;
        public static String buildSchemaModelTaskName;
        public static String buildForeignKeyRelationshipTaskName;

        static {
            Resources.initializeMessages((String)SchemaDiagramModel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

