/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas;

import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramToolbarPane;
import oracle.eclipse.tools.database.orm.ui.diagram.actions.dbschemas.OpenScrapbookAction;
import oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas.SchemaDiagramEditor;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SchemaViewerToolbarPane
extends NodeDiagramToolbarPane {
    private FigureCanvas leftFillToolBarCanvas;
    private FigureCanvas leftToolBarCanvas;
    private Figure leftToolBarBGFigure;
    private Label openScrapbookBtn;
    private Image openScrapbookImg = OracleDBUIPlugin.getInstance().getImage("icons/scrapbook.png");
    private Image openScrapbookHoverImg = OracleDBUIPlugin.getInstance().getImage("icons/scrapbook-hover.png");
    private static final int LEFT_TOOLBAR_WIDTH = 35;
    private static int wrappingMinSize = 323;
    protected int labelWidth = -1;
    protected int labelYPos = -1;

    public SchemaViewerToolbarPane(Composite parent) {
        this.toolbarCanvas = new Canvas(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.toolbarCanvas.setLayoutData((Object)gd);
        this.toolbarCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                org.eclipse.swt.graphics.Rectangle imageRect = SchemaViewerToolbarPane.this.toolbarBgImage.getBounds();
                org.eclipse.swt.graphics.Rectangle rect = SchemaViewerToolbarPane.this.toolbarCanvas.getClientArea();
                event.gc.drawImage(SchemaViewerToolbarPane.this.toolbarBgImage, 0, 0, imageRect.width, imageRect.height, rect.x, rect.y, rect.width, rect.height);
            }
        });
        parent.addControlListener((ControlListener)new SchemaToolbarControlListener());
        this.setSizeVariables();
        this.createLeftFillCanvas();
        this.createLeftToolBar();
        this.createLinkStyleToolBar();
        this.createZoomCombo((Composite)this.toolbarCanvas);
        this.createRightToolBar();
    }

    private void createLeftFillCanvas() {
        this.leftFillToolBarCanvas = new FigureCanvas((Composite)this.toolbarCanvas);
        this.leftFillToolBarCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.leftFillToolBarCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        NodeDiagramToolbarPane.ToolBarFigure leftFillBGFigure = new NodeDiagramToolbarPane.ToolBarFigure((NodeDiagramToolbarPane)this);
        leftFillBGFigure.setLayoutManager((LayoutManager)new XYLayout());
        leftFillBGFigure.setMinimumSize(new Dimension(35, this.paneHeight));
        leftFillBGFigure.setPreferredSize(new Dimension(35, this.paneHeight));
        this.leftFillToolBarCanvas.setContents((IFigure)leftFillBGFigure);
    }

    private void createLeftToolBar() {
        this.leftToolBarCanvas = new FigureCanvas((Composite)this.toolbarCanvas);
        this.leftToolBarCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.leftToolBarCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.leftToolBarBGFigure = new NodeDiagramToolbarPane.ToolBarFigureWithSeparator((NodeDiagramToolbarPane)this, false);
        this.leftToolBarBGFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.leftToolBarBGFigure.setMinimumSize(new Dimension(35, this.paneHeight));
        this.leftToolBarBGFigure.setPreferredSize(new Dimension(35, this.paneHeight));
        this.leftToolBarCanvas.setContents((IFigure)this.leftToolBarBGFigure);
        this.createLeftToolBarButtons();
        this.layoutLeftToolBarButtons();
    }

    private void createLeftToolBarButtons() {
        this.createOpenScrapbookBtn();
    }

    private void createOpenScrapbookBtn() {
        this.openScrapbookBtn = new Label(this.openScrapbookImg);
        this.openScrapbookBtn.setToolTip((IFigure)new Label(Resources.openSqlScrapbookTooltip));
        this.openScrapbookBtn.setOpaque(false);
        this.openScrapbookBtn.addMouseMotionListener((MouseMotionListener)new NodeDiagramToolbarPane.ToolBarMouseMotionListener((NodeDiagramToolbarPane)this, this.openScrapbookBtn, this.openScrapbookImg, this.openScrapbookHoverImg, new NodeDiagramToolbarPane.HoverCondition((NodeDiagramToolbarPane)this)));
        this.openScrapbookBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                Schema schema = ((SchemaDiagramEditor)SchemaViewerToolbarPane.this.getGraphicalEditor()).getSchema();
                OpenScrapbookAction action = new OpenScrapbookAction(schema);
                action.run();
                SchemaViewerToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
    }

    private void layoutLeftToolBarButtons() {
        int xinset = 5;
        int y = (this.paneHeight - 22) / 2;
        int nextX = xinset;
        Rectangle r = new Rectangle(nextX, y, 24, 22);
        this.leftToolBarBGFigure.add((IFigure)this.openScrapbookBtn, (Object)r);
    }

    private static final class Resources
    extends NLS {
        public static String openSqlScrapbookTooltip;

        static {
            Resources.initializeMessages((String)SchemaViewerToolbarPane.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private class SchemaToolbarControlListener
    implements ControlListener {
        private SchemaToolbarControlListener() {
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            int width = ((SchemaViewerToolbarPane)SchemaViewerToolbarPane.this).toolbarCanvas.getParent().getSize().x;
            int height = 0;
            int nRows = 1;
            if (width < wrappingMinSize) {
                nRows = width >= 228 ? 2 : 3;
            }
            height = nRows * SchemaViewerToolbarPane.this.paneHeight;
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.heightHint = height;
            gd.widthHint = width;
            SchemaViewerToolbarPane.this.toolbarCanvas.setLayoutData((Object)gd);
            int topMargin = (SchemaViewerToolbarPane.this.paneHeight - 16) / 2;
            if (nRows == 1) {
                int x = width;
                SchemaViewerToolbarPane.this.rightToolBarCanvas.setBounds(x - 95, 0, 95, SchemaViewerToolbarPane.this.paneHeight);
                SchemaViewerToolbarPane.this.comboParent.setBounds((x -= 95) - 95, topMargin, 95, 16);
                SchemaViewerToolbarPane.this.linkStyleToolBarCanvas.setBounds((x -= 95) - 98, 0, 98, SchemaViewerToolbarPane.this.paneHeight);
                SchemaViewerToolbarPane.this.leftToolBarCanvas.setBounds((x -= 98) - 35, 0, 35, SchemaViewerToolbarPane.this.paneHeight);
                SchemaViewerToolbarPane.this.leftFillToolBarCanvas.setBounds(0, 0, x - 35, SchemaViewerToolbarPane.this.paneHeight);
            } else if (nRows == 2) {
                SchemaViewerToolbarPane.this.leftToolBarCanvas.setBounds(0, 0, 35, SchemaViewerToolbarPane.this.paneHeight);
                SchemaViewerToolbarPane.this.linkStyleToolBarCanvas.setBounds(35, 0, 98, SchemaViewerToolbarPane.this.paneHeight);
                int rightWidth = width - 133;
                SchemaViewerToolbarPane.this.rightToolBarCanvas.setBounds(width - rightWidth, 0, rightWidth, SchemaViewerToolbarPane.this.paneHeight);
                int x = Math.max(width - 95, 0);
                SchemaViewerToolbarPane.this.comboParent.setBounds(0, SchemaViewerToolbarPane.this.paneHeight + topMargin, 95, 16);
                SchemaViewerToolbarPane.this.leftFillToolBarCanvas.setBounds(95, SchemaViewerToolbarPane.this.paneHeight, x, SchemaViewerToolbarPane.this.paneHeight);
            } else {
                SchemaViewerToolbarPane.this.leftToolBarCanvas.setBounds(0, 0, 35, SchemaViewerToolbarPane.this.paneHeight);
                SchemaViewerToolbarPane.this.linkStyleToolBarCanvas.setBounds(35, 0, 98, SchemaViewerToolbarPane.this.paneHeight);
                SchemaViewerToolbarPane.this.rightToolBarCanvas.setBounds(0, SchemaViewerToolbarPane.this.paneHeight, width, SchemaViewerToolbarPane.this.paneHeight);
                int x = Math.max(width - 95, 0);
                SchemaViewerToolbarPane.this.comboParent.setBounds(0, SchemaViewerToolbarPane.this.paneHeight * 2 + topMargin, 95, 16);
                SchemaViewerToolbarPane.this.leftFillToolBarCanvas.setBounds(95, SchemaViewerToolbarPane.this.paneHeight * 2, x, SchemaViewerToolbarPane.this.paneHeight);
            }
        }
    }
}

