/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas;

import oracle.eclipse.tools.common.ui.diagram.actions.GraphEditorExportToImageAction;
import oracle.eclipse.tools.common.ui.diagram.actions.GraphicalEditorPrintAction;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditor;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramToolbarPane;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeDiagramPart;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.orm.ui.diagram.actions.dbschemas.OpenScrapbookAction;
import oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas.SchemaViewerInput;
import oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas.SchemaViewerToolbarPane;
import oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities.SchemaDiagramModel;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectListener;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.NonConflictingRule;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SchemaDiagramEditor
extends NodeDiagramEditor {
    private IConnectionProfile selectedConnectionProfile;
    private final IConnectListener connectionListener = this.buildConnectionListener();
    private Object initialSelection;
    private Job refreshColumnTypeJob;

    public NodeDiagramToolbarPane createToolbarPane(Composite parent) {
        SchemaViewerToolbarPane toolbar = new SchemaViewerToolbarPane(parent);
        return toolbar;
    }

    public void dispose() {
        super.dispose();
        if (this.selectedConnectionProfile != null) {
            this.selectedConnectionProfile.removeConnectListener(this.connectionListener);
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof SchemaViewerInput) {
            SchemaViewerInput schemaInput = (SchemaViewerInput)input;
            try {
                this.setModel(schemaInput.getModel());
                this.setPartName(schemaInput.getPartName());
            }
            catch (InterruptedException ie) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)ie);
            }
            Schema schema = this.getSchema();
            EObject database = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)schema);
            if (database instanceof Database) {
                Database db = (Database)database;
                this.selectedConnectionProfile = ModelUtil.getConnectionProfile((Database)db);
                if (this.selectedConnectionProfile != null) {
                    this.selectedConnectionProfile.addConnectListener(this.connectionListener);
                }
            }
        }
    }

    public void setInitialSelection(Object initialSelection) {
        Object oldSel = this.initialSelection;
        this.initialSelection = initialSelection;
        if (oldSel != null && oldSel != initialSelection) {
            this.selectObject(initialSelection);
        }
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        if (this.initialSelection != null) {
            this.selectObject(this.initialSelection);
        }
        this.refreshColumnTypeJob = this.createRefreshColumnTypeJob();
        this.refreshColumnTypeJob.schedule();
    }

    public void populateCanvasContextMenu(IMenuManager menuMgr) {
        menuMgr.add((IAction)new OpenScrapbookAction(this.getSchema()));
        menuMgr.add((IContributionItem)new Separator());
        this.addZoomSubMenu(menuMgr);
        menuMgr.add((IContributionItem)new Separator());
        NodeDiagramPart modelPart = this.getModelEditPart();
        NodeDiagramModel model = (NodeDiagramModel)modelPart.getModel();
        String defaultImageName = this.getDefaultImageName(model.getModelName());
        GraphEditorExportToImageAction egvAction = new GraphEditorExportToImageAction(this.getGraphicalViewer(), modelPart.getFigure(), null, defaultImageName);
        menuMgr.add((IAction)egvAction);
        menuMgr.add((IAction)new GraphicalEditorPrintAction((IWorkbenchPart)this));
    }

    public Schema getSchema() {
        IEditorInput input = this.getEditorInput();
        assert (input instanceof SchemaViewerInput);
        Schema schema = ((SchemaViewerInput)input).getDTPSchema();
        return schema;
    }

    public FigureCanvas getMainFigureCanvas() {
        Control ctrl = this.getViewer().getControl();
        assert (ctrl instanceof FigureCanvas);
        return (FigureCanvas)ctrl;
    }

    private void connectionClosed(IConnectionProfile cp) {
        if (cp.equals(this.selectedConnectionProfile)) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = null;
            if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null) {
                page.closeEditor((IEditorPart)this, true);
            }
        }
    }

    private IConnectListener buildConnectionListener() {
        return new IConnectListener(){

            public void closeConnection(final ConnectEvent event) throws CoreException {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SchemaDiagramEditor.this.connectionClosed(event.getConnectionProfile());
                    }
                });
            }

            public boolean okToClose(ConnectEvent event) {
                return true;
            }

            public void openConnection(ConnectEvent event) throws CoreException {
            }
        };
    }

    private Job createRefreshColumnTypeJob() {
        Job job = new Job("Refreshing column types"){

            public IStatus run(IProgressMonitor monitor) {
                final NodeDiagramModel model = SchemaDiagramEditor.this.getModel();
                if (!$assertionsDisabled && !(model instanceof SchemaDiagramModel)) {
                    throw new AssertionError();
                }
                ((SchemaDiagramModel)model).refreshColumnType(monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SchemaDiagramEditor.this.getGraphicalViewer().setContents((Object)model);
                        SchemaDiagramEditor.this.getViewer().flush();
                        if (SchemaDiagramEditor.this.initialSelection != null) {
                            SchemaDiagramEditor.this.selectObject(SchemaDiagramEditor.this.initialSelection);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule((ISchedulingRule)new NonConflictingRule());
        job.setPriority(30);
        return job;
    }

    public void refresh() {
        if (this.refreshColumnTypeJob != null && this.refreshColumnTypeJob.getState() != 0) {
            this.refreshColumnTypeJob.cancel();
        }
        super.refresh();
        this.refreshColumnTypeJob = this.createRefreshColumnTypeJob();
        this.refreshColumnTypeJob.schedule();
    }
}

