/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.actions.dbschemas;

import java.util.ArrayList;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenScrapbookAction
extends Action {
    private Schema schema;

    public OpenScrapbookAction(Schema schema) {
        this.schema = schema;
        this.setText(Resources.openSqlScrapbook);
        ImageDescriptor id = OracleDBUIPlugin.getInstance().getImageDescriptor("icons/scrapbook.png");
        this.setImageDescriptor(id);
    }

    public void run() {
        Database db;
        IConnectionProfile profile;
        EObject database;
        ISQLEditorConnectionInfo editorConnectionInfo = null;
        if (this.schema != null && (database = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)this.schema)) instanceof Database && (profile = ModelUtil.getConnectionProfile((Database)(db = (Database)database))) != null) {
            editorConnectionInfo = new SQLEditorConnectionInfo(null, profile.getName(), db.getName());
        }
        if (editorConnectionInfo == null) {
            editorConnectionInfo = SQLFileUtil.getDefaultConnectionInfo();
        }
        String scrap = "";
        SQLEditorStorageEditorInput editorStorageEditorInput = new SQLEditorStorageEditorInput("", scrap);
        editorStorageEditorInput.setConnectionInfo(editorConnectionInfo);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorReference[] editors = window.getActivePage().getEditorReferences();
        int suffix = 0;
        ArrayList<String> editorNameList = new ArrayList<String>();
        int i = 0;
        while (i < editors.length) {
            editorNameList.add(editors[i].getName());
            ++i;
        }
        while (true) {
            String name;
            if (!editorNameList.contains(name = NLS.bind((String)Resources.openScrapbookActionScrapbookTitle, (Object)Integer.toString(suffix)))) {
                editorStorageEditorInput.setName(name);
                try {
                    window.getActivePage().openEditor((IEditorInput)editorStorageEditorInput, "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor");
                }
                catch (PartInitException e) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (CoreException)e);
                }
                break;
            }
            ++suffix;
        }
    }

    private static final class Resources
    extends NLS {
        public static String openSqlScrapbook;
        public static String openScrapbookActionScrapbookTitle;

        static {
            Resources.initializeMessages((String)OpenScrapbookAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

