/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.maven.adf.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.newadfapplication.INewADFApplicationWizardPage;
import oracle.eclipse.tools.maven.adf.MavenActivator;
import oracle.eclipse.tools.maven.adf.ui.MavenPageDataModelProvider;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IServer;

public class NewADFApplicationMavenPage
extends DataModelWizardPage
implements INewADFApplicationWizardPage {
    private static final String PAGE_NAME = "oracle.eclipse.tools.maven.adf.ui.maven_page";
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.adf.view.ui.NewADFApplicationWizard";
    private static final String IMAGE_PATH_WIZ_BAN = "icons/wizards/application-banner.png";
    private static final int HORIZ_INDENT = 21;
    private static final String[] validationPropertyNames = new String[]{"NewADFApplicationDataModelProvider.USE_MAVEN", "NewADFApplicationDataModelProvider.MAVEN_GROUP_ID", "NewADFApplicationDataModelProvider.MAVEN_ARTIFACT_ID", "NewADFApplicationDataModelProvider.MAVEN_VERSION", "NewADFApplicationDataModelProvider.MAVEN_SERVER"};
    protected static final List<String> SUPPORTED_SERVER_IDS = new ArrayList<String>();
    protected static final List<String> SUPPORTED_ADF_VERSIONS;
    private static final Integer STATUS_KEY_WLS_RUNTIME;
    private IDataModel wizardDataModel;
    private Button btnUseMaven;
    private Label lblGroupID;
    private Text txtGroupID;
    private Label lblArtifactID;
    private Text txtArtifactID;
    private Label lblVersion;
    private Text txtVersion;
    private Label lblServer;
    private Combo cboServer;

    static {
        SUPPORTED_SERVER_IDS.add("com.bea.weblogic1212.server");
        SUPPORTED_ADF_VERSIONS = new ArrayList<String>();
        SUPPORTED_ADF_VERSIONS.add("12.1.2");
        STATUS_KEY_WLS_RUNTIME = new Integer(validationPropertyNames.length);
    }

    public NewADFApplicationMavenPage() {
        super(DataModelFactory.createDataModel((IDataModelProvider)new MavenPageDataModelProvider()), PAGE_NAME);
        this.setTitle(Resources.MAVEN_PAGE_TITLE);
        this.setDescription(Resources.MAVEN_PAGE_DESC);
        this.setImageDescriptor(MavenActivator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.maven.adf", (String)IMAGE_PATH_WIZ_BAN));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Font font = parent.getFont();
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        top.setFont(font);
        IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
        help.setHelp((Control)top, HELP_CONTEXT_ID);
        this.btnUseMaven = new Button(top, 131104);
        GridDataFactory.defaultsFor((Control)this.btnUseMaven).span(2, 1).applyTo((Control)this.btnUseMaven);
        this.btnUseMaven.setText(Resources.BTN_USE_MAVEN_TEXT);
        this.btnUseMaven.setFont(font);
        this.synchHelper.synchCheckbox(this.btnUseMaven, "NewADFApplicationDataModelProvider.USE_MAVEN", null);
        this.lblGroupID = new Label(top, 0);
        this.lblGroupID.setText(Resources.LBL_GROUP_ID_TEXT);
        this.lblGroupID.setFont(font);
        GridDataFactory.defaultsFor((Control)this.lblGroupID).indent(21, 0).applyTo((Control)this.lblGroupID);
        this.txtGroupID = new Text(top, 2048);
        this.txtGroupID.setFont(font);
        GridDataFactory.defaultsFor((Control)this.txtGroupID).grab(true, false).applyTo((Control)this.txtGroupID);
        this.synchHelper.synchText(this.txtGroupID, "NewADFApplicationDataModelProvider.MAVEN_GROUP_ID", new Control[]{this.lblGroupID});
        this.lblArtifactID = new Label(top, 0);
        this.lblArtifactID.setText(Resources.LBL_ARTIFACT_ID_TEXT);
        this.lblArtifactID.setFont(font);
        GridDataFactory.defaultsFor((Control)this.lblArtifactID).indent(21, 0).applyTo((Control)this.lblArtifactID);
        this.txtArtifactID = new Text(top, 2048);
        this.txtArtifactID.setFont(font);
        GridDataFactory.defaultsFor((Control)this.txtArtifactID).grab(true, false).applyTo((Control)this.txtArtifactID);
        this.synchHelper.synchText(this.txtArtifactID, "NewADFApplicationDataModelProvider.MAVEN_ARTIFACT_ID", new Control[]{this.lblArtifactID});
        this.lblVersion = new Label(top, 0);
        this.lblVersion.setText(Resources.LBL_VERSION_TEXT);
        this.lblVersion.setFont(font);
        GridDataFactory.defaultsFor((Control)this.lblVersion).indent(21, 0).applyTo((Control)this.lblVersion);
        this.txtVersion = new Text(top, 2048);
        this.txtVersion.setFont(font);
        GridDataFactory.defaultsFor((Control)this.txtVersion).grab(true, false).applyTo((Control)this.txtVersion);
        this.synchHelper.synchText(this.txtVersion, "NewADFApplicationDataModelProvider.MAVEN_VERSION", new Control[]{this.lblVersion});
        this.lblServer = new Label(top, 0);
        this.lblServer.setText(Resources.LBL_SERVER_TEXT);
        this.lblServer.setFont(font);
        GridDataFactory.defaultsFor((Control)this.lblServer).indent(21, 0).applyTo((Control)this.lblServer);
        this.cboServer = new Combo(top, 2056);
        this.cboServer.setFont(font);
        GridDataFactory.defaultsFor((Control)this.cboServer).grab(true, false).applyTo((Control)this.cboServer);
        this.synchHelper.synchCombo(this.cboServer, "NewADFApplicationDataModelProvider.MAVEN_SERVER", new Control[]{this.lblServer});
        if (this.cboServer.getSelectionIndex() == -1 && this.cboServer.getVisibleItemCount() != 0) {
            this.cboServer.select(0);
        }
        return top;
    }

    protected String[] getValidationPropertyNames() {
        return validationPropertyNames;
    }

    protected void updateControls() {
        boolean useMaven = this.btnUseMaven.getSelection();
        this.lblGroupID.setEnabled(useMaven);
        this.txtGroupID.setEnabled(useMaven);
        this.lblArtifactID.setEnabled(useMaven);
        this.txtArtifactID.setEnabled(useMaven);
        this.lblVersion.setEnabled(useMaven);
        this.txtVersion.setEnabled(useMaven);
        this.lblServer.setEnabled(useMaven);
        this.cboServer.setEnabled(useMaven);
        super.updateControls();
    }

    public final void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(HELP_CONTEXT_ID);
    }

    protected IDialogSettings getDialogSettings() {
        return MavenActivator.getDefault().getDialogSettings();
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IProjectCreationPropertiesNew.PROJECT_NAME")) {
            this.model.setProperty("NewADFApplicationDataModelProvider.MAVEN_ARTIFACT_ID", event.getProperty());
        } else if (event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            this.synchHelper.synchUIWithModel("NewADFApplicationDataModelProvider.MAVEN_SERVER", 4);
        }
        super.propertyChanged(event);
    }

    public void dispose() {
        if (this.wizardDataModel != null) {
            this.wizardDataModel.removeListener((IDataModelListener)this);
        }
        super.dispose();
    }

    public void setWizardDataModel(IDataModel wizardDataModel) {
        this.wizardDataModel = wizardDataModel;
        if (this.wizardDataModel != null) {
            this.wizardDataModel.addListener((IDataModelListener)this);
        }
    }

    public void performFinish(IProject webProject, IProject jpaProject, IProgressMonitor monitor) throws CoreException {
        if (this.isValidMavenState()) {
            monitor.subTask(Resources.SUBTASK_MAVENIZE);
            this.mavenizeADFApp(webProject, jpaProject);
        }
    }

    protected void validatePage(boolean showMessage) {
        List runtimeComponents;
        boolean valid = false;
        Object objRuntime = this.wizardDataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        IRuntime runtime = null;
        if (objRuntime instanceof IRuntime && (runtimeComponents = (runtime = (IRuntime)objRuntime).getRuntimeComponents()) != null) {
            for (IRuntimeComponent runtimeComponent : runtimeComponents) {
                IRuntimeComponentVersion runtimeComponentVersion = runtimeComponent.getRuntimeComponentVersion();
                if (runtimeComponentVersion == null || !runtimeComponentVersion.getRuntimeComponentType().getId().equals("com.bea.weblogic")) continue;
                valid = SUPPORTED_ADF_VERSIONS.contains(JRFRuntimeUtil.getAdfVersionForWls((String)runtimeComponentVersion.getVersionString()));
            }
        }
        if (valid) {
            this.setOKStatus(STATUS_KEY_WLS_RUNTIME);
            this.btnUseMaven.setEnabled(true);
        } else {
            this.model.setProperty("NewADFApplicationDataModelProvider.USE_MAVEN", (Object)Boolean.FALSE);
            this.btnUseMaven.setEnabled(false);
            String infoMessage = runtime != null ? NLS.bind((String)Resources.UNSUPPORTED_WLS_RUNTIME, (Object)runtime.getLocalizedName()) : NLS.bind((String)Resources.UNSUPPORTED_WLS_RUNTIME, (Object)"UNKNOWN");
            this.setInfoStatus(STATUS_KEY_WLS_RUNTIME, infoMessage);
        }
        super.validatePage(true);
    }

    private boolean isValidMavenState() {
        String version;
        String artifactID;
        String groupID;
        String facetProjectName;
        boolean useMaven;
        boolean isValid = false;
        if (this.wizardDataModel != null && (useMaven = this.model.getBooleanProperty("NewADFApplicationDataModelProvider.USE_MAVEN")) && (facetProjectName = this.wizardDataModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME")) != null && facetProjectName.length() > 0 && (groupID = this.model.getStringProperty("NewADFApplicationDataModelProvider.MAVEN_GROUP_ID")) != null && groupID.length() > 0 && (artifactID = this.model.getStringProperty("NewADFApplicationDataModelProvider.MAVEN_ARTIFACT_ID")) != null && artifactID.length() > 0 && (version = this.model.getStringProperty("NewADFApplicationDataModelProvider.MAVEN_VERSION")) != null && version.length() > 0) {
            isValid = true;
        }
        return isValid;
    }

    private void mavenizeADFApp(IProject webProject, IProject jpaProject) throws CoreException {
        String earProjectName = this.wizardDataModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        if (earProjectName != null) {
            Object objAdaptedServer;
            IProject earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjectName);
            String groupId = this.model.getStringProperty("NewADFApplicationDataModelProvider.MAVEN_GROUP_ID");
            String artifactId = this.model.getStringProperty("NewADFApplicationDataModelProvider.MAVEN_ARTIFACT_ID");
            String packaging = "ear";
            String version = this.model.getStringProperty("NewADFApplicationDataModelProvider.MAVEN_VERSION");
            QualifiedName weblogicServerKey = new QualifiedName("oracle.eclipse.tools.maven.adf.ui.mavenpage", "weblogicServer");
            IServer server = (IServer)this.model.getProperty("NewADFApplicationDataModelProvider.MAVEN_SERVER");
            if (server != null && SUPPORTED_SERVER_IDS.contains(server.getServerType().getId()) && (objAdaptedServer = server.loadAdapter(IWeblogicServer.class, null)) != null) {
                IWeblogicServer weblogicServer = (IWeblogicServer)objAdaptedServer;
                earProject.setSessionProperty(weblogicServerKey, (Object)weblogicServer);
            }
            boolean success = NewADFApplicationMavenPage.mavenizeProject(this.getContainer().getShell(), earProject, groupId, artifactId, packaging, version, null, null);
            earProject.setSessionProperty(weblogicServerKey, null);
            if (success) {
                groupId = groupId.concat(".").concat(artifactId);
                artifactId = webProject.getName();
                packaging = "war";
                success = NewADFApplicationMavenPage.mavenizeProject(this.getContainer().getShell(), webProject, groupId, artifactId, packaging, version, earProject, null);
                if (success) {
                    if (jpaProject != null) {
                        artifactId = jpaProject.getName();
                        packaging = "ejb";
                        success = NewADFApplicationMavenPage.mavenizeProject(this.getContainer().getShell(), jpaProject, groupId, artifactId, packaging, version, earProject, webProject);
                    }
                    NewADFApplicationMavenPage.setMavenEARModules(earProject, webProject, jpaProject);
                    NewADFApplicationMavenPage.writeMavenAppPOM(earProject, webProject, jpaProject, groupId, version);
                }
            }
        }
    }

    private static boolean mavenizeProject(final Shell shell, IProject project, String groupId, String artifactId, String packaging, String version, IProject parentProject, IProject webProject) throws CoreException {
        boolean success = false;
        if (project != null && project.isOpen() && groupId != null && groupId.length() > 0 && artifactId != null && artifactId.length() > 0 && packaging != null && packaging.length() > 0 && version != null && version.length() > 0) {
            MavenProject ejbMavenProject;
            MavenProject webMavenProject;
            Dependency dependency;
            List dependencies;
            MavenProject childMavenProject;
            MavenProject parentMavenProject;
            if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                Model model = new Model();
                model.setModelVersion("4.0.0");
                model.setGroupId(groupId);
                model.setArtifactId(artifactId);
                model.setVersion(version);
                model.setPackaging(packaging);
                IFile pomFile = project.getFile((IPath)new Path("pom.xml"));
                QualifiedName isProjectInADFApp = new QualifiedName("oracle.eclipse.tools.maven.adf.ui.mavenpage", "isProjectInADFApp");
                project.setSessionProperty(isProjectInADFApp, (Object)Boolean.TRUE);
                try {
                    MavenPlugin.getProjectConversionManager().convert(project, model, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (NullPointerException npEx) {
                    Status status = new Status(4, "oracle.eclipse.tools.maven.adf", Resources.NEXUS_ERROR_STATUS_MESSAGE, npEx.getCause());
                    Display.getDefault().syncExec(new Runnable((IStatus)status){
                        private final /* synthetic */ IStatus val$status;
                        {
                            this.val$status = iStatus;
                        }

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)shell, (String)Resources.NEXUS_ERROR_TITLE, (String)Resources.NEXUS_ERROR_MESSAGE, (IStatus)this.val$status, (int)4);
                        }
                    });
                    throw new CoreException((IStatus)status);
                }
                project.setSessionProperty(isProjectInADFApp, null);
                MavenPlugin.getMavenModelManager().createMavenModel(pomFile, model);
                ResolverConfiguration configuration = new ResolverConfiguration();
                configuration.setResolveWorkspaceProjects(true);
                configuration.setSelectedProfiles("");
                IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
                configurationManager.enableMavenNature(project, configuration, (IProgressMonitor)new NullProgressMonitor());
                if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    configurationManager.updateProjectConfiguration(project, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            if (parentProject != null && (parentMavenProject = NewADFApplicationMavenPage.readMavenProject(parentProject)) != null && (childMavenProject = NewADFApplicationMavenPage.readMavenProject(project)) != null) {
                dependencies = parentMavenProject.getDependencies();
                dependency = new Dependency();
                dependency.setGroupId(childMavenProject.getGroupId());
                dependency.setArtifactId(childMavenProject.getArtifactId());
                dependency.setVersion(childMavenProject.getVersion());
                dependency.setType(childMavenProject.getPackaging());
                dependencies.add(dependency);
                NewADFApplicationMavenPage.writeMavenProject(parentMavenProject);
                NewADFApplicationMavenPage.updateMavenProject(parentProject);
            }
            if (webProject != null && (webMavenProject = NewADFApplicationMavenPage.readMavenProject(webProject)) != null && (ejbMavenProject = NewADFApplicationMavenPage.readMavenProject(project)) != null) {
                dependencies = webMavenProject.getDependencies();
                dependency = new Dependency();
                dependency.setGroupId(ejbMavenProject.getGroupId());
                dependency.setArtifactId(ejbMavenProject.getArtifactId());
                dependency.setVersion(ejbMavenProject.getVersion());
                dependency.setType(ejbMavenProject.getPackaging());
                dependency.setScope("provided");
                dependencies.add(dependency);
                NewADFApplicationMavenPage.fixMavenAbsolutePaths(webMavenProject, webProject);
                NewADFApplicationMavenPage.writeMavenProject(webMavenProject);
                NewADFApplicationMavenPage.updateMavenProject(webProject);
            }
            success = true;
        }
        return success;
    }

    private static void setMavenEARModules(IProject earProject, IProject webProject, IProject jpaProject) throws CoreException {
        Object objConfiguration;
        PluginExecution execution;
        Map executionsMap;
        Plugin plugin;
        Map pluginsMap;
        Build build;
        MavenProject webMavenProject;
        MavenProject earMavenProject = NewADFApplicationMavenPage.readMavenProject(earProject);
        if (earMavenProject != null && (webMavenProject = NewADFApplicationMavenPage.readMavenProject(webProject)) != null && (build = earMavenProject.getBuild()) != null && (pluginsMap = build.getPluginsAsMap()) != null && (plugin = (Plugin)pluginsMap.get("org.apache.maven.plugins:maven-ear-plugin")) != null && (executionsMap = plugin.getExecutionsAsMap()) != null && (execution = (PluginExecution)executionsMap.get("default-ear")) != null && (objConfiguration = execution.getConfiguration()) instanceof Xpp3Dom) {
            Xpp3Dom configuration = (Xpp3Dom)objConfiguration;
            Xpp3Dom modules = new Xpp3Dom("modules");
            NewADFApplicationMavenPage.addMavenEARModule(modules, "webModule", webMavenProject);
            MavenProject jpaMavenProject = NewADFApplicationMavenPage.readMavenProject(jpaProject);
            if (jpaMavenProject != null) {
                NewADFApplicationMavenPage.addMavenEARModule(modules, "ejbModule", jpaMavenProject);
            }
            configuration.addChild(modules);
            NewADFApplicationMavenPage.fixMavenAbsolutePaths(earMavenProject, earProject);
            NewADFApplicationMavenPage.writeMavenProject(earMavenProject);
            NewADFApplicationMavenPage.updateMavenProject(earProject);
        }
    }

    private static void addMavenEARModule(Xpp3Dom modules, String moduleType, MavenProject mavenProject) {
        if (modules != null && moduleType != null && moduleType.trim().length() > 0 && mavenProject != null) {
            Xpp3Dom module = new Xpp3Dom(moduleType);
            Xpp3Dom groupId = new Xpp3Dom("groupId");
            groupId.setValue(mavenProject.getGroupId());
            module.addChild(groupId);
            Xpp3Dom artifactId = new Xpp3Dom("artifactId");
            artifactId.setValue(mavenProject.getArtifactId());
            module.addChild(artifactId);
            modules.addChild(module);
        }
    }

    private static void writeMavenAppPOM(IProject earProject, IProject webProject, IProject jpaProject, String groupId, String version) throws CoreException {
        if (earProject != null && groupId != null && groupId.trim().length() > 0 && version != null && version.trim().length() > 0) {
            Model model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(groupId);
            model.setArtifactId(String.valueOf(earProject.getName()) + "_app");
            model.setVersion(version);
            model.setPackaging("pom");
            if (jpaProject != null) {
                model.addModule("../" + jpaProject.getName());
            }
            if (webProject != null) {
                model.addModule("../" + webProject.getName());
            }
            model.addModule(".");
            IFile appPomFile = earProject.getFile((IPath)new Path("app_pom.xml"));
            MavenPlugin.getMavenModelManager().createMavenModel(appPomFile, model);
        }
    }

    private static MavenProject readMavenProject(IProject project) throws CoreException {
        IFile pomFile;
        MavenProject mavenProject = null;
        if (project != null && (pomFile = project.getFile("pom.xml")) != null) {
            mavenProject = MavenPlugin.getMavenModelManager().readMavenProject(pomFile, (IProgressMonitor)new NullProgressMonitor());
        }
        return mavenProject;
    }

    private static void fixMavenAbsolutePaths(MavenProject mavenProject, IProject project) {
        Build build;
        Model model;
        if (mavenProject != null && project != null && (model = mavenProject.getModel()) != null && (build = model.getBuild()) != null) {
            String reportingOutputDir;
            Reporting reporting;
            Plugin wlsPlugin;
            Map managedPluginsMap;
            PluginManagement pluginManagement;
            Plugin sitePlugin;
            Map pluginsMap;
            String dir;
            List testResources;
            List resources;
            String testOutputDir;
            String outputDir;
            String testSrcDir;
            String scriptSrcDir;
            String srcDir = NewADFApplicationMavenPage.getProjectRelativePath(project, build.getSourceDirectory());
            if (srcDir != null) {
                build.setSourceDirectory(srcDir);
            }
            if ((scriptSrcDir = NewADFApplicationMavenPage.getProjectRelativePath(project, build.getScriptSourceDirectory())) != null) {
                build.setScriptSourceDirectory(scriptSrcDir);
            }
            if ((testSrcDir = NewADFApplicationMavenPage.getProjectRelativePath(project, build.getTestSourceDirectory())) != null) {
                build.setTestSourceDirectory(testSrcDir);
            }
            if ((outputDir = NewADFApplicationMavenPage.getProjectRelativePath(project, build.getOutputDirectory())) != null) {
                build.setOutputDirectory(outputDir);
            }
            if ((testOutputDir = NewADFApplicationMavenPage.getProjectRelativePath(project, build.getTestOutputDirectory())) != null) {
                build.setTestOutputDirectory(testOutputDir);
            }
            if ((resources = build.getResources()) != null) {
                for (Resource resource : resources) {
                    String resDir = NewADFApplicationMavenPage.getProjectRelativePath(project, resource.getDirectory());
                    if (resDir == null) continue;
                    resource.setDirectory(resDir);
                }
            }
            if ((testResources = build.getTestResources()) != null) {
                for (Resource testResource : testResources) {
                    String testResDir = NewADFApplicationMavenPage.getProjectRelativePath(project, testResource.getDirectory());
                    if (testResDir == null) continue;
                    testResource.setDirectory(testResDir);
                }
            }
            if ((dir = NewADFApplicationMavenPage.getProjectRelativePath(project, build.getDirectory())) != null) {
                build.setDirectory(dir);
            }
            if ((pluginsMap = build.getPluginsAsMap()) != null && (sitePlugin = (Plugin)pluginsMap.get("org.apache.maven.plugins:maven-site-plugin")) != null) {
                NewADFApplicationMavenPage.fixMavenConfigurationChildAbsolutePath(sitePlugin.getConfiguration(), "outputDirectory", project);
                Map executionsMap = sitePlugin.getExecutionsAsMap();
                if (executionsMap != null) {
                    PluginExecution defDeployExecution;
                    PluginExecution defSiteExecution = (PluginExecution)executionsMap.get("default-site");
                    if (defSiteExecution != null) {
                        NewADFApplicationMavenPage.fixMavenConfigurationChildAbsolutePath(defSiteExecution.getConfiguration(), "outputDirectory", project);
                    }
                    if ((defDeployExecution = (PluginExecution)executionsMap.get("default-deploy")) != null) {
                        NewADFApplicationMavenPage.fixMavenConfigurationChildAbsolutePath(defDeployExecution.getConfiguration(), "outputDirectory", project);
                    }
                }
            }
            if ((pluginManagement = build.getPluginManagement()) != null && (managedPluginsMap = pluginManagement.getPluginsAsMap()) != null && (wlsPlugin = (Plugin)managedPluginsMap.get("com.oracle.weblogic:weblogic-maven-plugin")) != null) {
                NewADFApplicationMavenPage.fixMavenConfigurationChildAbsolutePath(wlsPlugin.getConfiguration(), "source", project);
            }
            if ((reporting = model.getReporting()) != null && (reportingOutputDir = NewADFApplicationMavenPage.getProjectRelativePath(project, reporting.getOutputDirectory())) != null) {
                reporting.setOutputDirectory(reportingOutputDir);
            }
        }
    }

    private static void fixMavenConfigurationChildAbsolutePath(Object configuration, String child, IProject project) {
        String value;
        Xpp3Dom childElement;
        if (configuration instanceof Xpp3Dom && (childElement = ((Xpp3Dom)configuration).getChild(child)) != null && (value = NewADFApplicationMavenPage.getProjectRelativePath(project, childElement.getValue())) != null) {
            childElement.setValue(value);
        }
    }

    private static String getProjectRelativePath(IProject project, String sPath) {
        IPath projectPath;
        Path path;
        String relPath = null;
        if (project != null && sPath != null && sPath.length() > 0 && (path = new Path(sPath)).isAbsolute() && (projectPath = project.getLocation()) != null) {
            relPath = path.makeRelativeTo(projectPath).toString();
        }
        return relPath;
    }

    private static void writeMavenProject(MavenProject project) throws CoreException {
        Model model;
        File file;
        if (project != null && (file = project.getFile()) != null && file.canWrite() && (model = project.getModel()) != null) {
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(file);
                    MavenPlugin.getMaven().writeModel(model, (OutputStream)out);
                }
                catch (FileNotFoundException fnfEx) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.maven.adf", Resources.MAVEN_PROJECT_WRITE_ERROR, (Throwable)fnfEx));
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioEx) {
                        throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.maven.adf", Resources.MAVEN_PROJECT_WRITE_ERROR, (Throwable)ioEx));
                    }
                }
            }
        }
    }

    private static void updateMavenProject(IProject project) throws CoreException {
        MavenPlugin.getProjectConfigurationManager().updateProjectConfiguration(project, (IProgressMonitor)new NullProgressMonitor());
    }

    private static final class Resources
    extends NLS {
        public static String MAVEN_PAGE_TITLE;
        public static String MAVEN_PAGE_DESC;
        public static String BTN_USE_MAVEN_TEXT;
        public static String LBL_GROUP_ID_TEXT;
        public static String LBL_ARTIFACT_ID_TEXT;
        public static String LBL_VERSION_TEXT;
        public static String LBL_SERVER_TEXT;
        public static String SUBTASK_MAVENIZE;
        public static String MAVEN_PROJECT_WRITE_ERROR;
        public static String UNSUPPORTED_WLS_RUNTIME;
        public static String NEXUS_ERROR_TITLE;
        public static String NEXUS_ERROR_MESSAGE;
        public static String NEXUS_ERROR_STATUS_MESSAGE;

        static {
            Resources.initializeMessages((String)NewADFApplicationMavenPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

