/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.maven.adf.project.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import org.apache.maven.model.Build;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;

public abstract class AbstractFacetedProjectConversionParticipant
extends AbstractProjectConversionParticipant {
    protected static final String ADF_VERSION_11g = "11.1.1";
    protected static final String ADF_VERSION_12c = "12.1.2";
    protected static final String LIBRARY_GROUP_ID_11g = "oracle.jdeveloper.library";
    protected static final String LIBRARY_GROUP_ID_12c = "com.oracle.adf.library";
    protected static final String LIBRARY_DEFAULT_VERSION_11g = "12.1.2.0.0";
    protected static final String LIBRARY_DEFAULT_VERSION_12c = "12.1.2-0-0";
    private static final String LIBRARY_TYPE = "pom";
    private static final String LIBRARY_SCOPE = "provided";
    private static final String BUILD_HELPER_GROUP_ID = "org.codehaus.mojo";
    private static final String BUILD_HELPER_ARTIFACT_ID = "build-helper-maven-plugin";
    private static final String BUILD_HELPER_VERSION = "1.7";

    protected abstract IProjectFacet getApplicableFacet();

    public boolean accept(IProject project) throws CoreException {
        IFacetedProject fProject;
        boolean accept = false;
        if (project != null && (fProject = ProjectFacetsManager.create((IProject)project)) != null && fProject.hasProjectFacet(this.getApplicableFacet())) {
            accept = true;
        }
        return accept;
    }

    protected static void addDependency(Model model, String groupId, String artifactId, String version, String type, String scope) {
        if (model != null) {
            Dependency dependency = new Dependency();
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactId);
            dependency.setVersion(version);
            dependency.setType(type);
            if (scope != null) {
                dependency.setScope(scope);
            }
            model.addDependency(dependency);
        }
    }

    protected static void addLibrary(Model model, LibraryDescriptor descriptor) {
        AbstractFacetedProjectConversionParticipant.addDependency(model, descriptor.groupId, descriptor.artifactId, descriptor.version, LIBRARY_TYPE, LIBRARY_SCOPE);
    }

    protected static void addResourceFolder(Model model, String folderName) {
        if (model != null && folderName != null && folderName.length() > 0) {
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            if (AbstractFacetedProjectConversionParticipant.addBuildHelperResourceFolder(build, folderName)) {
                AbstractFacetedProjectConversionParticipant.ignoreBuildHelperLifecycleMapping(build);
            }
        }
    }

    protected static String getADFVersion(IProject project) {
        String adfVersion;
        block4: {
            adfVersion = ADF_VERSION_11g;
            if (project != null) {
                try {
                    List components;
                    IRuntime runtime;
                    IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                    if (fProject == null || (runtime = fProject.getPrimaryRuntime()) == null || (components = runtime.getRuntimeComponents()) == null) break block4;
                    for (IRuntimeComponent component : components) {
                        IRuntimeComponentVersion componentVersion = component.getRuntimeComponentVersion();
                        if (componentVersion == null || !"com.bea.weblogic".equals(componentVersion.getRuntimeComponentType().getId())) continue;
                        adfVersion = JRFRuntimeUtil.getAdfVersionForWls((String)componentVersion.getVersionString());
                        break;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return adfVersion;
    }

    private static boolean addBuildHelperResourceFolder(Build build, String folderName) {
        boolean success = false;
        Plugin plugin = AbstractFacetedProjectConversionParticipant.getOrCreatePlugin((PluginContainer)build, BUILD_HELPER_GROUP_ID, BUILD_HELPER_ARTIFACT_ID);
        if (plugin != null) {
            plugin.setVersion(BUILD_HELPER_VERSION);
            PluginExecution pluginExecution = AbstractFacetedProjectConversionParticipant.getOrCreatePluginExecution(plugin, "add-resource");
            if (pluginExecution != null) {
                pluginExecution.setPhase("generate-resources");
                List goals = pluginExecution.getGoals();
                if (goals == null || !goals.contains("add-resource")) {
                    pluginExecution.addGoal("add-resource");
                }
                Xpp3Dom configuration = (Xpp3Dom)AbstractFacetedProjectConversionParticipant.getOrCreateConfiguration((ConfigurationContainer)pluginExecution);
                Xpp3Dom resources = AbstractFacetedProjectConversionParticipant.getOrCreateElement(configuration, "resources");
                Xpp3Dom resource = new Xpp3Dom("resource");
                resources.addChild(resource);
                Xpp3Dom directory = AbstractFacetedProjectConversionParticipant.getOrCreateElement(resource, "directory", folderName);
                success = directory != null;
            }
        }
        return success;
    }

    private static boolean ignoreBuildHelperLifecycleMapping(Build build) {
        Plugin plugin;
        boolean success = false;
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement == null) {
            pluginManagement = new PluginManagement();
            build.setPluginManagement(pluginManagement);
        }
        if ((plugin = AbstractFacetedProjectConversionParticipant.getOrCreatePlugin((PluginContainer)pluginManagement, "org.eclipse.m2e", "lifecycle-mapping")) != null) {
            plugin.setVersion("1.0.0");
            Xpp3Dom configuration = (Xpp3Dom)AbstractFacetedProjectConversionParticipant.getOrCreateConfiguration((ConfigurationContainer)plugin);
            Xpp3Dom lifecycleMappingMetadata = AbstractFacetedProjectConversionParticipant.getOrCreateElement(configuration, "lifecycleMappingMetadata");
            Xpp3Dom pluginExecutions = AbstractFacetedProjectConversionParticipant.getOrCreateElement(lifecycleMappingMetadata, "pluginExecutions");
            Xpp3Dom pluginExecution = AbstractFacetedProjectConversionParticipant.getOrCreateElement(pluginExecutions, "pluginExecution");
            Xpp3Dom pluginExecutionFilter = AbstractFacetedProjectConversionParticipant.getOrCreateElement(pluginExecution, "pluginExecutionFilter");
            success = AbstractFacetedProjectConversionParticipant.getOrCreateElement(pluginExecutionFilter, "groupId", BUILD_HELPER_GROUP_ID) != null;
            success &= AbstractFacetedProjectConversionParticipant.getOrCreateElement(pluginExecutionFilter, "artifactId", BUILD_HELPER_ARTIFACT_ID) != null;
            success &= AbstractFacetedProjectConversionParticipant.getOrCreateElement(pluginExecutionFilter, "versionRange", "[1.7,)") != null;
            Xpp3Dom goals = AbstractFacetedProjectConversionParticipant.getOrCreateElement(pluginExecutionFilter, "goals");
            success &= AbstractFacetedProjectConversionParticipant.getOrCreateElement(goals, "goal", "add-resource") != null;
            Xpp3Dom action = AbstractFacetedProjectConversionParticipant.getOrCreateElement(pluginExecution, "action");
            success &= AbstractFacetedProjectConversionParticipant.getOrCreateElement(action, "ignore") != null;
        }
        return success;
    }

    private static Plugin getOrCreatePlugin(PluginContainer container, String groupId, String artifactId) {
        Plugin plugin = null;
        Map pluginsMap = container.getPluginsAsMap();
        if (pluginsMap == null) {
            container.setPlugins(new ArrayList());
            pluginsMap = container.getPluginsAsMap();
        }
        if ((plugin = (Plugin)pluginsMap.get(String.valueOf(groupId) + ":" + artifactId)) == null) {
            plugin = new Plugin();
            plugin.setGroupId(groupId);
            plugin.setArtifactId(artifactId);
            container.addPlugin(plugin);
        }
        return plugin;
    }

    private static PluginExecution getOrCreatePluginExecution(Plugin plugin, String id) {
        PluginExecution pluginExecution = null;
        Map executionsMap = plugin.getExecutionsAsMap();
        if (executionsMap == null) {
            plugin.setExecutions(new ArrayList());
            executionsMap = plugin.getExecutionsAsMap();
        }
        if ((pluginExecution = (PluginExecution)executionsMap.get(id)) == null) {
            pluginExecution = new PluginExecution();
            pluginExecution.setId(id);
            plugin.addExecution(pluginExecution);
        }
        return pluginExecution;
    }

    private static Object getOrCreateConfiguration(ConfigurationContainer container) {
        Object configuration = null;
        configuration = container.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
            container.setConfiguration(configuration);
        }
        return configuration;
    }

    private static Xpp3Dom getOrCreateElement(Xpp3Dom parent, String name) {
        return AbstractFacetedProjectConversionParticipant.getOrCreateElement(parent, name, null);
    }

    private static Xpp3Dom getOrCreateElement(Xpp3Dom parent, String name, String value) {
        String oldValue;
        Xpp3Dom element = null;
        element = parent.getChild(name);
        if (element == null) {
            element = new Xpp3Dom(name);
            parent.addChild(element);
        }
        if (value != null && value.length() > 0 && !value.equals(oldValue = element.getValue())) {
            element.setValue(value);
        }
        return element;
    }

    protected static class LibraryDescriptor {
        public String groupId;
        public String artifactId;
        public String version;

        public LibraryDescriptor(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }
}

