/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.markers.ApiQuickFixProcessor;
import org.eclipse.pde.api.tools.ui.internal.wizards.JavadocConversionRefactoring;
import org.eclipse.pde.api.tools.ui.internal.wizards.StringFilter;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class JavadocConversionPage
extends UserInputWizardPage {
    private static final String SETTINGS_SECTION = "JavadocTagConversionWizardPage";
    private static final String SETTINGS_REMOVE_TAGS = "remove_tags";
    static Map<String, String> ALL_API_IMPORTS = new HashMap<String, String>();
    Button removetags = null;
    CheckboxTableViewer tableviewer = null;
    HashSet<Object> checkedset = new HashSet();
    UpdateJob updatejob = new UpdateJob();
    StringFilter filter = new StringFilter();
    private Text checkcount = null;

    static {
        ALL_API_IMPORTS.put("NoExtend", "org.eclipse.pde.api.tools.annotations.NoExtend");
        ALL_API_IMPORTS.put("NoImplement", "org.eclipse.pde.api.tools.annotations.NoImplement");
        ALL_API_IMPORTS.put("NoInstantiate", "org.eclipse.pde.api.tools.annotations.NoInstantiate");
        ALL_API_IMPORTS.put("NoOverride", "org.eclipse.pde.api.tools.annotations.NoOverride");
        ALL_API_IMPORTS.put("NoReference", "org.eclipse.pde.api.tools.annotations.NoReference");
    }

    public JavadocConversionPage() {
        super(WizardMessages.JavadocConversionWizard_0);
        this.setTitle(WizardMessages.JavadocConversionWizard_0);
        this.setDescription(WizardMessages.JavadocConversionPage_convert_tags_to_annotations_description);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.JAVADOC_CONVERSION_WIZARD_PAGE);
        SWTFactory.createWrapLabel(comp, WizardMessages.JavadocConversionPage_select_pjs_to_convert, 1, 100);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiToolingSetupWizardPage_6, 1, 50);
        final Text text = SWTFactory.createText(comp, 2048, 1);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocConversionPage.this.updatejob.setFilter(text.getText().trim());
                JavadocConversionPage.this.updatejob.cancel();
                JavadocConversionPage.this.updatejob.schedule();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && JavadocConversionPage.this.tableviewer != null) {
                    JavadocConversionPage.this.tableviewer.getTable().setFocus();
                }
            }
        });
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_8, 1, 50);
        Table table = new Table(comp, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        IProject[] input = Util.getApiProjectsMinSourceLevel((String)"1.5");
        if (input == null) {
            this.setMessage(WizardMessages.JavadocConversionPage_0, 2);
        } else {
            this.tableviewer.setInput((Object)input);
        }
        this.tableviewer.setComparator(new ViewerComparator());
        this.tableviewer.addFilter((ViewerFilter)this.filter);
        this.tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    JavadocConversionPage.this.checkedset.add(event.getElement());
                } else {
                    JavadocConversionPage.this.checkedset.remove(event.getElement());
                }
                JavadocConversionPage.this.setPageComplete(JavadocConversionPage.this.pageValid());
            }
        });
        Composite bcomp = SWTFactory.createComposite(comp, 3, 1, 771, 0, 0);
        Button button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_10, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavadocConversionPage.this.tableviewer.setAllChecked(true);
                JavadocConversionPage.this.checkedset.addAll(Arrays.asList(JavadocConversionPage.this.tableviewer.getCheckedElements()));
                JavadocConversionPage.this.setPageComplete(JavadocConversionPage.this.pageValid());
            }
        });
        button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_11, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavadocConversionPage.this.tableviewer.setAllChecked(false);
                TableItem[] items = JavadocConversionPage.this.tableviewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    JavadocConversionPage.this.checkedset.remove(items[i].getData());
                    ++i;
                }
                JavadocConversionPage.this.setPageComplete(JavadocConversionPage.this.pageValid());
            }
        });
        this.checkcount = SWTFactory.createText(bcomp, 0x800008, 1, 640);
        this.checkcount.setBackground(bcomp.getBackground());
        Object[] selected = this.getWorkbenchSelection();
        if (selected.length > 0) {
            this.tableviewer.setCheckedElements(selected);
            this.checkedset.addAll(Arrays.asList(selected));
        }
        this.setPageComplete(this.tableviewer.getCheckedElements().length > 0);
        SWTFactory.createVerticalSpacer(comp, 1);
        this.removetags = SWTFactory.createCheckButton(comp, WizardMessages.JavadocConversionPage_delete_tags_during_conversion, null, true, 1);
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings != null) {
            this.removetags.setSelection(settings.getBoolean(SETTINGS_REMOVE_TAGS));
        }
    }

    protected boolean pageValid() {
        if (this.checkedset.size() < 1) {
            this.setErrorMessage(WizardMessages.UpdateJavadocTagsWizardPage_12);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean finish() {
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION);
        settings.put(SETTINGS_REMOVE_TAGS, this.removetags.getSelection());
        return true;
    }

    public IWizardPage getNextPage() {
        this.collectChanges();
        IWizardPage page = super.getNextPage();
        if (page != null) {
            page.setDescription(WizardMessages.JavadocConversionPage_changes_required_for_conversion);
        }
        return page;
    }

    protected boolean performFinish() {
        this.collectChanges();
        return super.performFinish();
    }

    protected Object[] getWorkbenchSelection() {
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            Object[] jps = ((IStructuredSelection)provider.getSelection()).toArray();
            ArrayList<IProject> pjs = new ArrayList<IProject>();
            int i = 0;
            while (i < jps.length) {
                IAdaptable adapt;
                IProject pj;
                if (jps[i] instanceof IAdaptable && Util.isApiProject((IProject)(pj = (IProject)(adapt = (IAdaptable)jps[i]).getAdapter(IProject.class)))) {
                    pjs.add(pj);
                }
                ++i;
            }
            return pjs.toArray();
        }
        return new Object[0];
    }

    private void collectChanges() {
        final JavadocConversionRefactoring refactoring = (JavadocConversionRefactoring)this.getRefactoring();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IProject[] projects = JavadocConversionPage.this.checkedset.toArray(new IProject[JavadocConversionPage.this.checkedset.size()]);
                IProject project = null;
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)WizardMessages.JavadocConversionPage_scanning_projects_for_javadoc_tags, (int)(projects.length * 3));
                refactoring.resetRefactoring();
                boolean remove = JavadocConversionPage.this.removetags.getSelection();
                CompositeChange pchange = null;
                int i = 0;
                while (i < projects.length) {
                    project = projects[i];
                    localmonitor.setTaskName(NLS.bind((String)WizardMessages.JavadocConversionPage_scan_javadoc_to_convert, (Object[])new Object[]{project.getName()}));
                    pchange = new CompositeChange(project.getName());
                    IFile build = project.getFile("build.properties");
                    if (ApiQuickFixProcessor.needsBuildPropertiesChange(build)) {
                        try {
                            pchange.add(ApiQuickFixProcessor.createBuildPropertiesChange(build));
                        }
                        catch (CoreException coreException) {}
                    }
                    try {
                        JavadocConversionPage.this.createChanges(pchange, JavaCore.create((IProject)project), remove, localmonitor.newChild(1));
                    }
                    catch (CoreException e) {
                        ApiUIPlugin.log(e);
                    }
                    if (pchange.getChildren().length > 0) {
                        refactoring.addChange((Change)pchange);
                    }
                    Util.updateMonitor((IProgressMonitor)localmonitor, (int)1);
                    ++i;
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InvocationTargetException e) {
            ApiUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            ApiUIPlugin.log(e);
        }
    }

    RefactoringStatus createChanges(CompositeChange projectchange, IJavaProject project, boolean remove, SubMonitor monitor) throws CoreException {
        HashMap<IFile, Set<TextEdit>> map = new HashMap<IFile, Set<TextEdit>>();
        RefactoringStatus status = this.collectAnnotationEdits(project, map, remove, (IProgressMonitor)monitor.newChild(1));
        if (status.isOK()) {
            IFile file = null;
            TextFileChange change = null;
            MultiTextEdit multiedit = null;
            Set<TextEdit> alledits = null;
            for (Map.Entry<IFile, Set<TextEdit>> entry : map.entrySet()) {
                file = entry.getKey();
                monitor.setTaskName(NLS.bind((String)WizardMessages.JavadocConversionPage_collect_edits, (Object[])new Object[]{file.getName()}));
                change = new TextFileChange(MessageFormat.format((String)WizardMessages.JavadocConversionPage_convert_javadoc_tags_in, (Object[])new Object[]{file.getName()}), file);
                multiedit = new MultiTextEdit();
                change.setEdit((TextEdit)multiedit);
                alledits = entry.getValue();
                if (alledits != null) {
                    for (TextEdit edit : alledits) {
                        multiedit.addChild(edit);
                    }
                }
                projectchange.add((Change)change);
            }
            Util.updateMonitor((IProgressMonitor)monitor, (int)1);
        }
        return status;
    }

    RefactoringStatus collectAnnotationEdits(IJavaProject project, Map<IFile, Set<TextEdit>> collector, boolean remove, IProgressMonitor monitor) throws CoreException {
        IApiComponent component;
        RefactoringStatus status = new RefactoringStatus();
        IApiBaseline baseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
        if (baseline != null && (component = baseline.getApiComponent(project.getProject())) != null) {
            IApiDescription description = component.getApiDescription();
            AnnotVisitor visitor = new AnnotVisitor(project, description, remove, monitor);
            description.accept((ApiDescriptionVisitor)visitor, null);
            collector.putAll(visitor.changes);
        }
        return status;
    }

    class AnnotVisitor
    extends ApiDescriptionVisitor {
        Map<IFile, Set<TextEdit>> changes = new HashMap<IFile, Set<TextEdit>>();
        boolean remove = false;
        IJavaProject project = null;
        IApiDescription apidescription = null;
        SubMonitor monitor = null;

        public AnnotVisitor(IJavaProject project, IApiDescription description, boolean remove, IProgressMonitor monitor) {
            this.project = project;
            this.apidescription = description;
            this.remove = remove;
            this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        }

        public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
            if (element.getElementType() == 2) {
                try {
                    IType type = this.project.findType(((IReferenceTypeDescriptor)element).getQualifiedName(), (IProgressMonitor)new NullProgressMonitor());
                    if (type != null) {
                        this.collectUpdates(type, element, this.apidescription);
                    }
                }
                catch (JavaModelException e) {
                    ApiUIPlugin.log(e);
                }
                catch (CoreException e) {
                    ApiUIPlugin.log(e);
                }
                return false;
            }
            return super.visitElement(element, description);
        }

        void collectUpdates(IType type, IElementDescriptor element, IApiDescription description) throws CoreException {
            ASTParser parser = ASTParser.newParser((int)8);
            ICompilationUnit cunit = type.getCompilationUnit();
            if (cunit != null) {
                this.monitor.setTaskName(NLS.bind((String)WizardMessages.JavadocConversionPage_scan_javadoc_to_convert, (Object[])new Object[]{type.getFullyQualifiedName()}));
                parser.setSource(cunit);
                parser.setResolveBindings(true);
                Map options = cunit.getJavaProject().getOptions(true);
                options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                parser.setCompilerOptions(options);
                CompilationUnit cast = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
                cast.recordModifications();
                ASTRewrite rewrite = ASTRewrite.create((AST)cast.getAST());
                TagVisitor visitor = new TagVisitor(description, rewrite, this.remove);
                cast.accept((ASTVisitor)visitor);
                ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
                IPath path = cast.getJavaElement().getPath();
                try {
                    bm.connect(path, LocationKind.IFILE, null);
                    ITextFileBuffer tfb = bm.getTextFileBuffer(path, LocationKind.IFILE);
                    IDocument document = tfb.getDocument();
                    TextEdit edit = rewrite.rewriteAST(document, null);
                    if (edit.getChildrenSize() > 0 || edit.getLength() != 0) {
                        IFile file = (IFile)cunit.getUnderlyingResource();
                        Set<TextEdit> edits = this.changes.get(file);
                        if (edits == null) {
                            edits = new HashSet<TextEdit>(3);
                            this.changes.put(file, edits);
                        }
                        edits.add(edit);
                    }
                }
                finally {
                    bm.disconnect(path, LocationKind.IFILE, null);
                }
            }
        }
    }

    class TagVisitor
    extends ASTVisitor {
        IApiDescription apidescription = null;
        ASTRewrite rewrite = null;
        boolean remove = false;
        List<String> existingImports = new ArrayList<String>();
        List<String> missingImports = new ArrayList<String>();

        public TagVisitor(IApiDescription description, ASTRewrite rewrite, boolean remove) {
            this.apidescription = description;
            this.rewrite = rewrite;
            this.remove = remove;
        }

        public void endVisit(CompilationUnit node) {
            ListRewrite lrewrite;
            if (this.missingImports.size() > 0 && (lrewrite = this.getListrewrite((ASTNode)node)) != null) {
                for (String missing : this.missingImports) {
                    ImportDeclaration imp = node.getAST().newImportDeclaration();
                    imp.setName(node.getAST().newName(missing));
                    lrewrite.insertLast((ASTNode)imp, null);
                }
            }
            this.missingImports.clear();
            this.existingImports.clear();
            super.endVisit(node);
        }

        public boolean visit(ImportDeclaration node) {
            String name = node.getName().getFullyQualifiedName();
            if (!ALL_API_IMPORTS.values().contains(name)) {
                this.existingImports.add(name);
            }
            return super.visit(node);
        }

        public boolean visit(TypeDeclaration node) {
            IReferenceTypeDescriptor desc;
            IApiAnnotations annots;
            ITypeBinding binding = node.resolveBinding();
            if (binding != null && (annots = this.apidescription.resolveAnnotations((IElementDescriptor)(desc = Factory.typeDescriptor((String)binding.getQualifiedName())))) != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                this.updateNode((BodyDeclaration)node, annots);
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            IReferenceTypeDescriptor desc;
            IApiAnnotations annots;
            ITypeBinding binding = node.resolveBinding();
            if (binding != null && (annots = this.apidescription.resolveAnnotations((IElementDescriptor)(desc = Factory.typeDescriptor((String)binding.getQualifiedName())))) != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                this.updateNode((BodyDeclaration)node, annots);
            }
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            IReferenceTypeDescriptor desc;
            IApiAnnotations annots;
            ITypeBinding binding = node.resolveBinding();
            if (binding != null && (annots = this.apidescription.resolveAnnotations((IElementDescriptor)(desc = Factory.typeDescriptor((String)binding.getQualifiedName())))) != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                this.updateNode((BodyDeclaration)node, annots);
            }
            return true;
        }

        public boolean visit(FieldDeclaration node) {
            ASTNode parent = node.getParent();
            ITypeBinding binding = null;
            if (parent instanceof AbstractTypeDeclaration) {
                binding = ((AbstractTypeDeclaration)parent).resolveBinding();
            } else if (parent instanceof AnnotationTypeDeclaration) {
                binding = ((AnnotationTypeDeclaration)parent).resolveBinding();
            }
            if (binding != null) {
                List fragments = node.fragments();
                IFieldDescriptor desc = Factory.fieldDescriptor((String)binding.getQualifiedName(), (String)((VariableDeclarationFragment)fragments.get(0)).getName().getIdentifier());
                IApiAnnotations annots = this.apidescription.resolveAnnotations((IElementDescriptor)desc);
                if (annots != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                    this.updateNode((BodyDeclaration)node, annots);
                }
            }
            return super.visit(node);
        }

        public boolean visit(MethodDeclaration node) {
            IMethodDescriptor desc;
            IApiAnnotations annots;
            ASTNode parent = node.getParent();
            String typename = null;
            if (parent instanceof AbstractTypeDeclaration) {
                typename = ((AbstractTypeDeclaration)parent).getName().getFullyQualifiedName();
            } else if (parent instanceof AnnotationTypeDeclaration) {
                typename = ((AnnotationTypeDeclaration)parent).getName().getFullyQualifiedName();
            }
            if (typename != null && (annots = this.apidescription.resolveAnnotations((IElementDescriptor)(desc = Factory.methodDescriptor((String)typename, (String)node.getName().getIdentifier(), (String)Signatures.getMethodSignatureFromNode((MethodDeclaration)node))))) != null && !RestrictionModifiers.isUnrestricted((int)annots.getRestrictions())) {
                this.updateNode((BodyDeclaration)node, annots);
            }
            return true;
        }

        void updateNode(BodyDeclaration body, IApiAnnotations annotations) {
            Javadoc docnode;
            ListRewrite lrewrite = this.getListrewrite((ASTNode)body);
            if (lrewrite != null) {
                MarkerAnnotation newannot;
                AST ast = body.getAST();
                ArrayList mods = body.modifiers();
                if (mods == null) {
                    mods = new ArrayList();
                    this.rewrite.set((ASTNode)body, (StructuralPropertyDescriptor)body.getModifiersProperty(), mods, null);
                }
                ArrayList<String> existing = new ArrayList<String>();
                for (IExtendedModifier modifier : mods) {
                    Annotation annot;
                    String name;
                    if (!modifier.isAnnotation() || !JavadocTagManager.ALL_ANNOTATIONS.contains(name = (annot = (Annotation)modifier).getTypeName().getFullyQualifiedName())) continue;
                    existing.add(name);
                }
                int restrictions = annotations.getRestrictions();
                if (RestrictionModifiers.isExtendRestriction((int)restrictions) && !existing.contains("NoExtend")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoExtend"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoExtend");
                }
                if (RestrictionModifiers.isImplementRestriction((int)restrictions) && !existing.contains("NoImplement")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoImplement"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoImplement");
                }
                if (RestrictionModifiers.isInstantiateRestriction((int)restrictions) && !existing.contains("NoInstantiate")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoInstantiate"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoInstantiate");
                }
                if (RestrictionModifiers.isOverrideRestriction((int)restrictions) && !existing.contains("NoOverride")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoOverride"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoOverride");
                }
                if (RestrictionModifiers.isReferenceRestriction((int)restrictions) && !existing.contains("NoReference")) {
                    newannot = ast.newMarkerAnnotation();
                    newannot.setTypeName(ast.newName("NoReference"));
                    lrewrite.insertFirst((ASTNode)newannot, null);
                    this.ensureImport("NoReference");
                }
            }
            if (this.remove && (docnode = body.getJavadoc()) != null) {
                List tags = docnode.tags();
                lrewrite = this.rewrite.getListRewrite((ASTNode)docnode, Javadoc.TAGS_PROPERTY);
                for (TagElement tag : tags) {
                    if (!JavadocTagManager.ALL_TAGS.contains(tag.getTagName())) continue;
                    lrewrite.remove((ASTNode)tag, null);
                }
            }
        }

        void ensureImport(String added) {
            String annot = ALL_API_IMPORTS.get(added);
            if (annot != null && !this.existingImports.contains(annot)) {
                this.missingImports.add(annot);
            }
        }

        ListRewrite getListrewrite(ASTNode node) {
            switch (node.getNodeType()) {
                case 55: {
                    return this.rewrite.getListRewrite(node, TypeDeclaration.MODIFIERS2_PROPERTY);
                }
                case 81: {
                    return this.rewrite.getListRewrite(node, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);
                }
                case 71: {
                    return this.rewrite.getListRewrite(node, EnumDeclaration.MODIFIERS2_PROPERTY);
                }
                case 23: {
                    return this.rewrite.getListRewrite(node, FieldDeclaration.MODIFIERS2_PROPERTY);
                }
                case 31: {
                    return this.rewrite.getListRewrite(node, MethodDeclaration.MODIFIERS2_PROPERTY);
                }
                case 15: {
                    return this.rewrite.getListRewrite(node, CompilationUnit.IMPORTS_PROPERTY);
                }
            }
            return null;
        }
    }

    class UpdateJob
    extends WorkbenchJob {
        private String pattern;

        public UpdateJob() {
            super(WizardMessages.ApiToolingSetupWizardPage_filter_update_job);
            this.pattern = null;
            this.setSystem(true);
        }

        public synchronized void setFilter(String pattern) {
            this.pattern = pattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (JavadocConversionPage.this.tableviewer != null) {
                try {
                    JavadocConversionPage.this.tableviewer.getTable().setRedraw(false);
                    UpdateJob updateJob = this;
                    synchronized (updateJob) {
                        JavadocConversionPage.this.filter.setPattern(String.valueOf(this.pattern) + '*');
                    }
                    JavadocConversionPage.this.tableviewer.refresh(true);
                    JavadocConversionPage.this.tableviewer.setCheckedElements(JavadocConversionPage.this.checkedset.toArray());
                }
                finally {
                    JavadocConversionPage.this.tableviewer.getTable().setRedraw(true);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

