/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;

public class Cache<K, V>
implements Iterable<Entry<K, V>> {
    private static final String NULL = "null";
    private boolean supportsNullValue;
    private int initialCapacity;
    private Map<K, Object> map;

    public Cache(boolean supportsNullValue) {
        this(supportsNullValue, -1);
    }

    public Cache(boolean supportsNullValue, int initialCapacity) {
        this.supportsNullValue = supportsNullValue;
        this.initialCapacity = initialCapacity;
    }

    public boolean isSupportNullValue() {
        return this.supportsNullValue;
    }

    public synchronized void clear() {
        if (this.map != null) {
            this.map.clear();
            this.map = null;
        }
    }

    public synchronized boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public synchronized V get(K key) {
        return this.map != null ? (V)this.toValue(this.map.get(key)) : null;
    }

    @Override
    public synchronized Iterator<Entry<K, V>> iterator() {
        if (this.map != null) {
            ArrayList<Entry<K, V>> entries = new ArrayList<Entry<K, V>>(this.map.size());
            for (Map.Entry<K, Object> mapEntry : this.map.entrySet()) {
                entries.add(new Entry(mapEntry.getKey(), this.toValue(mapEntry.getValue())));
            }
            this.adjustEntries(entries);
            return Collections.unmodifiableCollection(entries).iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected void adjustEntries(List<Entry<K, V>> entries) {
    }

    public synchronized List<V> values() {
        if (this.map != null) {
            ArrayList<V> values = new ArrayList<V>(this.map.size());
            for (Map.Entry<K, Object> mapEntry : this.map.entrySet()) {
                values.add(this.toValue(mapEntry.getValue()));
            }
            this.adjustValues(values);
            return Collections.unmodifiableList(values);
        }
        return Collections.emptyList();
    }

    protected void adjustValues(List<V> values) {
    }

    public synchronized V set(K key, V value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        Object object = value;
        if (object == null) {
            if (this.supportsNullValue) {
                object = NULL;
            } else {
                throw new IllegalArgumentException("This cache does not support null values");
            }
        }
        if (this.map == null) {
            Map<K, Object> map = this.createMap(this.initialCapacity);
            this.map = map;
        }
        this.map.put(key, object);
        return value;
    }

    protected Map<K, Object> createMap(int initialCapacity) {
        return initialCapacity >= 0 ? new HashMap(initialCapacity) : new HashMap();
    }

    public synchronized boolean isSet(K key) {
        return this.map != null && this.map.containsKey(key);
    }

    public synchronized V unset(K key) {
        if (this.map != null) {
            Object cached = this.map.remove(key);
            if (this.map.isEmpty()) {
                this.map = null;
            }
            return this.toValue(cached);
        }
        return null;
    }

    private V toValue(Object cached) {
        return (V)(cached == NULL ? null : cached);
    }

    public static final class Entry<K, V> {
        private final K key;
        private final V value;

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return DTRTUtil.equals(this.key, other.key) && DTRTUtil.equals(this.value, other.value);
        }
    }

    public static class MRUCache<K, V>
    extends Cache<K, V> {
        public MRUCache(boolean supportsNullValue) {
            super(supportsNullValue);
        }

        public MRUCache(boolean supportsNullValue, int initialCapacity) {
            super(supportsNullValue, initialCapacity);
        }

        @Override
        protected Map<K, Object> createMap(int initialCapacity) {
            return initialCapacity >= 0 ? new LinkedHashMap(initialCapacity, 0.75f, true) : new LinkedHashMap(16, 0.75f, true);
        }

        @Override
        protected void adjustEntries(List<Entry<K, V>> entries) {
            Collections.reverse(entries);
        }

        @Override
        protected void adjustValues(List<V> values) {
            Collections.reverse(values);
        }
    }

    public static class SortedCache<K, V>
    extends Cache<K, V> {
        public SortedCache(boolean supportsNullValue) {
            super(supportsNullValue);
        }

        public SortedCache(boolean supportsNullValue, int initialCapacity) {
            super(supportsNullValue, initialCapacity);
        }

        @Override
        protected Map<K, Object> createMap(int initialCapacity) {
            return initialCapacity >= 0 ? new LinkedHashMap(initialCapacity) : new LinkedHashMap();
        }
    }
}

