/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.util;

import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.util.DefaultUniqueIdGenerator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.ComponentIDType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFTagIdGenerationUtil {
    private static final String ADF_PREFERENCES_SCOPE_KEY = "/instance/oracle.eclipse.tools.webtier.ui";
    private static final String ADF_PREFERENCE_AUTO_GENERATE_IDS = "oracle.eclipse.tools.adf.view.auto_generate_ids";
    private static final String DVT_FACES_URI = "http://xmlns.oracle.com/dss/adf/faces";
    private static final String ADF_FACES_URI = "http://xmlns.oracle.com/adf/faces/rich";
    private static final String ID_ATTR = "id";

    public static boolean isAutoGenerateIds() {
        IEclipsePreferences prefs = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node(ADF_PREFERENCES_SCOPE_KEY);
        return prefs.getBoolean(ADF_PREFERENCE_AUTO_GENERATE_IDS, true);
    }

    public static void createIds(IDOMElement element, Document document) {
        assert (element != null);
        assert (document != null);
        DefaultUniqueIdGenerator generator = new DefaultUniqueIdGenerator();
        Set idSet = generator.getIDs(document.getDocumentElement());
        idSet.addAll(generator.getIDs((Element)element));
        if (element != null) {
            ADFTagIdGenerationUtil.addIdAttributeToElementAndChildren(element, generator, idSet);
        }
    }

    private static void addIdAttributeToElementAndChildren(IDOMElement element, DefaultUniqueIdGenerator generator, Set<String> idSet) {
        ADFTagIdGenerationUtil.addIdAttributeToElement(element, generator, idSet);
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int size = nodes.getLength();
        while (i < size) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                ADFTagIdGenerationUtil.addIdAttributeToElementAndChildren((IDOMElement)node, generator, idSet);
            }
            ++i;
        }
    }

    private static void addIdAttributeToElement(IDOMElement element, DefaultUniqueIdGenerator generator, Set<String> idSet) {
        if (!ADFTagIdGenerationUtil.idAttributeValueIsSet(element) && ADFTagIdGenerationUtil.canHaveIdAttr(element)) {
            String uniqueId = generator.generateUniqueId(idSet, element.getLocalName().substring(0, 1));
            element.setAttribute(ID_ATTR, uniqueId);
            idSet.add(uniqueId);
        }
    }

    private static boolean idAttributeValueIsSet(IDOMElement element) {
        return element.hasAttribute(ID_ATTR) && !element.getAttribute(ID_ATTR).equals("");
    }

    private static boolean canHaveIdAttr(IDOMElement element) {
        List features;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)element.getStructuredDocument(), (Node)element);
        ITaglibContextResolver contextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        String uri = contextResolver.getTagURIForNodeName((Node)element);
        return ADFTagIdGenerationUtil.isNamespaceOfInterest(uri) && ADFTagIdGenerationUtil.containsComponentIdType(features = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidValues.class, context, uri, element.getLocalName(), ID_ATTR));
    }

    private static boolean isNamespaceOfInterest(String uri) {
        return uri != null ? ADF_FACES_URI.equals(uri) || DVT_FACES_URI.equals(uri) : false;
    }

    private static boolean containsComponentIdType(List<IMetaDataEnabledFeature> features) {
        if (features != null && features.size() > 0) {
            for (IMetaDataEnabledFeature feature : features) {
                if (!(feature instanceof ComponentIDType)) continue;
                return true;
            }
        }
        return false;
    }
}

