/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationLayout;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationVariation;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IStockGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StockGraphAttributeSelectionComposite
extends ModelChangeComposite<IStockGraphOptionsModel>
implements PropertyChangeListener {
    private final StackLayout _attributeSelectionStackLayout = new StackLayout();
    private final Map<String, ModelChangeComposite<?>> _attributeSelectionComposites = new LinkedHashMap();

    public StockGraphAttributeSelectionComposite(Composite parent, int style, IGraphOptionsModel model) {
        super(parent, style, (IStockGraphOptionsModel)model);
        this.setFont(parent.getFont());
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.setLayout((Layout)this._attributeSelectionStackLayout);
        this.addSubtypeComposites(style);
        this.setStackLayoutTopControl();
    }

    public void addSubtypeComposites(int style) {
        List<IPresentationVariation> variations = ((IStockGraphOptionsModel)this.getModel()).getCreatorPresentation().getPresentationVariations();
        for (IPresentationVariation pv : variations) {
            String subtype = pv.getProperties().get("graphType");
            Set<IStockGraphOptionsModel.Property> properties = ((IStockGraphOptionsModel)this.getModel()).getSubtypeProperties(subtype);
            if (properties == null || properties.isEmpty()) continue;
            StockSubtypeAttrComposite comp = new StockSubtypeAttrComposite(this, style, (IStockGraphOptionsModel)this.getModel(), properties);
            this._attributeSelectionComposites.put(subtype, comp);
            comp.addPropertyChangeListener(this);
        }
    }

    private void setStackLayoutTopControl() {
        IPresentationLayout layout = ((IStockGraphOptionsModel)this.getModel()).getPresentationLayout();
        if (layout != null && layout.getVariationType() != null) {
            this._attributeSelectionStackLayout.topControl = (Control)this._attributeSelectionComposites.get(layout.getVariationType());
        }
        this.layout();
    }

    @Override
    public void updateLayout() {
        for (ModelChangeComposite<?> comp : this._attributeSelectionComposites.values()) {
            comp.updateLayout();
        }
        this.setStackLayoutTopControl();
    }

    public void dispose() {
        for (ModelChangeComposite<?> comp : this._attributeSelectionComposites.values()) {
            comp.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange();
    }

    private static class StockSubtypeAttrComposite
    extends ModelChangeComposite<IStockGraphOptionsModel> {
        private final Set<IStockGraphOptionsModel.Property> _properties;
        private Combo _stockCombo;
        private Combo _timeCombo;
        private Combo _openCombo;
        private Combo _highCombo;
        private Combo _lowCombo;
        private Combo _closeCombo;
        private Combo _volumeCombo;
        private final List<String> _stockValueNames = new ArrayList<String>();
        private final List<String> _timeValueNames = new ArrayList<String>();
        private final List<String> _numericValueNames = new ArrayList<String>();

        public StockSubtypeAttrComposite(Composite parent, int style, IStockGraphOptionsModel model, Set<IStockGraphOptionsModel.Property> properties) {
            super(parent, style, model);
            this._properties = properties;
            this.setFont(parent.getFont());
            this.setLayoutData(new GridData(4, 0x1000000, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.createEdgesComposite(this);
            this.populateCombos();
            this.addListeners();
        }

        private void createEdgesComposite(Composite parent) {
            Label label = new Label(parent, 16384);
            label.setText(Messages.StockGraphOptionsPage_labelStock);
            GridData data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._stockCombo = new Combo(parent, 0x800808);
            data = new GridData(4, 0x1000000, true, false);
            this._stockCombo.setLayoutData((Object)data);
            label = new Label(parent, 16384);
            label.setText(Messages.StockGraphOptionsPage_labelTime);
            data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._timeCombo = new Combo(parent, 0x800808);
            data = new GridData(4, 0x1000000, true, false);
            this._timeCombo.setLayoutData((Object)data);
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.OPEN)) {
                label = new Label(parent, 16384);
                label.setText(Messages.StockGraphOptionsPage_labelOpen);
                data = new GridData(16384, 0x1000000, false, false);
                label.setLayoutData((Object)data);
                this._openCombo = new Combo(parent, 0x800808);
                data = new GridData(4, 0x1000000, true, false);
                this._openCombo.setLayoutData((Object)data);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.HIGH)) {
                label = new Label(parent, 16384);
                label.setText(Messages.StockGraphOptionsPage_labelHigh);
                data = new GridData(16384, 0x1000000, false, false);
                label.setLayoutData((Object)data);
                this._highCombo = new Combo(parent, 0x800808);
                data = new GridData(4, 0x1000000, true, false);
                this._highCombo.setLayoutData((Object)data);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.LOW)) {
                label = new Label(parent, 16384);
                label.setText(Messages.StockGraphOptionsPage_labelLow);
                data = new GridData(16384, 0x1000000, false, false);
                label.setLayoutData((Object)data);
                this._lowCombo = new Combo(parent, 0x800808);
                data = new GridData(4, 0x1000000, true, false);
                this._lowCombo.setLayoutData((Object)data);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.CLOSE)) {
                label = new Label(parent, 16384);
                label.setText(Messages.StockGraphOptionsPage_labelClose);
                data = new GridData(16384, 0x1000000, false, false);
                label.setLayoutData((Object)data);
                this._closeCombo = new Combo(parent, 0x800808);
                data = new GridData(4, 0x1000000, true, false);
                this._closeCombo.setLayoutData((Object)data);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.VOLUME)) {
                label = new Label(parent, 16384);
                label.setText(Messages.StockGraphOptionsPage_labelVolume);
                data = new GridData(16384, 0x1000000, false, false);
                label.setLayoutData((Object)data);
                this._volumeCombo = new Combo(parent, 0x800808);
                data = new GridData(4, 0x1000000, true, false);
                this._volumeCombo.setLayoutData((Object)data);
            }
        }

        private void populateCombos() {
            for (EdgeItemContext item : ((IStockGraphOptionsModel)this.getModel()).getAllEdgeItemContexts()) {
                if (item.isNumeric()) {
                    this._numericValueNames.add(item.getName());
                    continue;
                }
                if (item.isDate()) {
                    this._timeValueNames.add(item.getName());
                    continue;
                }
                this._stockValueNames.add(item.getName());
            }
            this._stockCombo.setItems(this._stockValueNames.toArray(new String[this._stockValueNames.size()]));
            this._timeCombo.setItems(this._timeValueNames.toArray(new String[this._timeValueNames.size()]));
            String[] numericValuesArray = this._numericValueNames.toArray(new String[this._numericValueNames.size()]);
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.OPEN)) {
                this._openCombo.setItems(numericValuesArray);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.HIGH)) {
                this._highCombo.setItems(numericValuesArray);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.LOW)) {
                this._lowCombo.setItems(numericValuesArray);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.CLOSE)) {
                this._closeCombo.setItems(numericValuesArray);
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.VOLUME)) {
                this._volumeCombo.setItems(numericValuesArray);
            }
        }

        private void updateWidgets() {
            this._stockCombo.deselectAll();
            this._timeCombo.deselectAll();
            if (((IStockGraphOptionsModel)this.getModel()).getStock() != null) {
                this._stockCombo.setText(((IStockGraphOptionsModel)this.getModel()).getStock().getName());
            }
            if (((IStockGraphOptionsModel)this.getModel()).getTime() != null) {
                this._timeCombo.setText(((IStockGraphOptionsModel)this.getModel()).getTime().getName());
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.OPEN)) {
                this._openCombo.deselectAll();
                if (((IStockGraphOptionsModel)this.getModel()).getOpen() != null) {
                    this._openCombo.setText(((IStockGraphOptionsModel)this.getModel()).getOpen().getName());
                }
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.HIGH)) {
                this._highCombo.deselectAll();
                if (((IStockGraphOptionsModel)this.getModel()).getHigh() != null) {
                    this._highCombo.setText(((IStockGraphOptionsModel)this.getModel()).getHigh().getName());
                }
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.LOW)) {
                this._lowCombo.deselectAll();
                if (((IStockGraphOptionsModel)this.getModel()).getLow() != null) {
                    this._lowCombo.setText(((IStockGraphOptionsModel)this.getModel()).getLow().getName());
                }
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.CLOSE)) {
                this._closeCombo.deselectAll();
                if (((IStockGraphOptionsModel)this.getModel()).getClose() != null) {
                    this._closeCombo.setText(((IStockGraphOptionsModel)this.getModel()).getClose().getName());
                }
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.VOLUME)) {
                this._volumeCombo.deselectAll();
                if (((IStockGraphOptionsModel)this.getModel()).getVolume() != null) {
                    this._volumeCombo.setText(((IStockGraphOptionsModel)this.getModel()).getVolume().getName());
                }
            }
        }

        private void addListeners() {
            this._stockCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EdgeItemContext value = StockSubtypeAttrComposite.this.getComboSelection(StockSubtypeAttrComposite.this._stockCombo, StockSubtypeAttrComposite.this._stockValueNames);
                    if (value != null) {
                        value.setDataItem(false);
                        value.setTreatAsText(false);
                        ((IStockGraphOptionsModel)StockSubtypeAttrComposite.this.getModel()).setStock(value);
                        StockSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            });
            this._timeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EdgeItemContext value = StockSubtypeAttrComposite.this.getComboSelection(StockSubtypeAttrComposite.this._timeCombo, StockSubtypeAttrComposite.this._timeValueNames);
                    if (value != null) {
                        value.setDataItem(false);
                        value.setTreatAsText(true);
                        ((IStockGraphOptionsModel)StockSubtypeAttrComposite.this.getModel()).setTime(value);
                        StockSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            });
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.OPEN)) {
                this._openCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EdgeItemContext value = StockSubtypeAttrComposite.this.getComboSelection(StockSubtypeAttrComposite.this._openCombo, StockSubtypeAttrComposite.this._numericValueNames);
                        if (value != null) {
                            value.setDataItem(true);
                            value.setTreatAsText(false);
                            ((IStockGraphOptionsModel)StockSubtypeAttrComposite.this.getModel()).setOpen(value);
                            StockSubtypeAttrComposite.this.firePropertyChange();
                        }
                    }
                });
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.HIGH)) {
                this._highCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EdgeItemContext value = StockSubtypeAttrComposite.this.getComboSelection(StockSubtypeAttrComposite.this._highCombo, StockSubtypeAttrComposite.this._numericValueNames);
                        if (value != null) {
                            value.setDataItem(true);
                            value.setTreatAsText(false);
                            ((IStockGraphOptionsModel)StockSubtypeAttrComposite.this.getModel()).setHigh(value);
                            StockSubtypeAttrComposite.this.firePropertyChange();
                        }
                    }
                });
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.LOW)) {
                this._lowCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EdgeItemContext value = StockSubtypeAttrComposite.this.getComboSelection(StockSubtypeAttrComposite.this._lowCombo, StockSubtypeAttrComposite.this._numericValueNames);
                        if (value != null) {
                            value.setDataItem(true);
                            value.setTreatAsText(false);
                            ((IStockGraphOptionsModel)StockSubtypeAttrComposite.this.getModel()).setLow(value);
                            StockSubtypeAttrComposite.this.firePropertyChange();
                        }
                    }
                });
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.CLOSE)) {
                this._closeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EdgeItemContext value = StockSubtypeAttrComposite.this.getComboSelection(StockSubtypeAttrComposite.this._closeCombo, StockSubtypeAttrComposite.this._numericValueNames);
                        if (value != null) {
                            value.setDataItem(true);
                            value.setTreatAsText(false);
                            ((IStockGraphOptionsModel)StockSubtypeAttrComposite.this.getModel()).setClose(value);
                            StockSubtypeAttrComposite.this.firePropertyChange();
                        }
                    }
                });
            }
            if (this._properties.contains((Object)IStockGraphOptionsModel.Property.VOLUME)) {
                this._volumeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EdgeItemContext value = StockSubtypeAttrComposite.this.getComboSelection(StockSubtypeAttrComposite.this._volumeCombo, StockSubtypeAttrComposite.this._numericValueNames);
                        if (value != null) {
                            value.setDataItem(true);
                            value.setTreatAsText(false);
                            ((IStockGraphOptionsModel)StockSubtypeAttrComposite.this.getModel()).setVolume(value);
                            StockSubtypeAttrComposite.this.firePropertyChange();
                        }
                    }
                });
            }
        }

        private EdgeItemContext getComboSelection(Combo combo, List<String> names) {
            int index;
            if (names != null && !names.isEmpty() && (index = combo.getSelectionIndex()) >= 0 && index < names.size()) {
                String name = names.get(index);
                return ((IStockGraphOptionsModel)this.getModel()).findEdgeItemContext(name);
            }
            return null;
        }

        @Override
        public void updateLayout() {
            this.updateWidgets();
            super.updateLayout();
        }
    }
}

