/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IScatterGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AttributeSelectionComposite;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.ui.dialogs.ListShuttleDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ScatterGraphAttributeSelectionComposite
extends ModelChangeComposite<IScatterGraphOptionsModel>
implements PropertyChangeListener {
    private final StackLayout _attributeSelectionStackLayout = new StackLayout();
    private final ModelChangeComposite<?> _polarComp;
    private final ModelChangeComposite<?> _scatterComp;

    public ScatterGraphAttributeSelectionComposite(Composite parent, int style, IGraphOptionsModel model) {
        super(parent, style, (IScatterGraphOptionsModel)model);
        this.setFont(parent.getFont());
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.setLayout((Layout)this._attributeSelectionStackLayout);
        this._polarComp = new ScatterSubtypeAttrComposite(this, style, model, true);
        this._polarComp.addPropertyChangeListener(this);
        this._scatterComp = new ScatterSubtypeAttrComposite(this, style, model, false);
        this._scatterComp.addPropertyChangeListener(this);
        this.setStackLayoutTopControl();
    }

    private void setStackLayoutTopControl() {
        this._attributeSelectionStackLayout.topControl = ((IScatterGraphOptionsModel)this.getModel()).isPolar() ? this._polarComp : this._scatterComp;
        this.layout();
    }

    @Override
    public void updateLayout() {
        this._polarComp.updateLayout();
        this._scatterComp.updateLayout();
        this.setStackLayoutTopControl();
    }

    public void dispose() {
        this._polarComp.removePropertyChangeListener(this);
        this._scatterComp.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange();
    }

    private static class ScatterSubtypeAttrComposite
    extends ModelChangeComposite<IScatterGraphOptionsModel> {
        private Combo _xAxisCombo;
        private Combo _yAxisCombo;
        private Combo _colorCombo;
        private Combo _shapeCombo;
        private final List<String> _numericEdgeItemNames = new ArrayList<String>();
        private final List<String> _colorAndShapeValueNames = new ArrayList<String>();
        private Text _typeValues;
        private Button _typeButton;
        private Text _tooltipValuesA;
        private Text _tooltipValuesM;
        private Button _tooltipButtonA;
        private Button _tooltipButtonM;

        public ScatterSubtypeAttrComposite(Composite parent, int style, IGraphOptionsModel model, boolean isPolar) {
            super(parent, style, (IScatterGraphOptionsModel)model);
            this.setFont(parent.getFont());
            this.setLayoutData(new GridData(4, 0x1000000, true, false));
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.createEdgesComposite(this, isPolar);
            this.populateCombos();
            this.addListeners();
        }

        private void createEdgesComposite(Composite parent, boolean isPolar) {
            Button manualButton;
            Button automaticButton;
            Label label = new Label(parent, 16384);
            label.setText(Messages.GraphOptionsPage_xAxisDataPointLabel);
            GridData data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._xAxisCombo = new Combo(parent, 0x800808);
            data = new GridData(4, 0x1000000, true, false);
            this._xAxisCombo.setLayoutData((Object)data);
            Label gridPlaceHolder = new Label(parent, 0);
            gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            gridPlaceHolder.setVisible(false);
            label = new Label(parent, 16384);
            label.setText(Messages.GraphOptionsPage_yAxisDataPointLabel);
            data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._yAxisCombo = new Combo(parent, 0x800808);
            data = new GridData(4, 0x1000000, true, false);
            this._yAxisCombo.setLayoutData((Object)data);
            gridPlaceHolder = new Label(parent, 0);
            gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            gridPlaceHolder.setVisible(false);
            label = new Label(parent, 0);
            label.setText(Messages.ScatterGraphOptionsPage_labelMarkers);
            data = new GridData(16384, 0x1000000, false, false);
            data.horizontalSpan = 3;
            data.verticalIndent = 20;
            label.setLayoutData((Object)data);
            if (isPolar) {
                automaticButton = null;
                manualButton = null;
            } else {
                Composite assignComp = new Composite(parent, 0);
                data = new GridData(16384, 0x1000000, true, false);
                data.horizontalSpan = 3;
                assignComp.setLayoutData((Object)data);
                GridLayout layout = new GridLayout(3, false);
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.verticalSpacing = 0;
                assignComp.setLayout((Layout)layout);
                label = new Label(assignComp, 16384);
                label.setText(Messages.ScatterGraphOptionsPage_labelAssign);
                data = new GridData(16384, 0x1000000, false, false);
                label.setLayoutData((Object)data);
                automaticButton = new Button(assignComp, 16);
                automaticButton.setText(Messages.ScatterGraphOptionsPage_labelAutomatically);
                automaticButton.setSelection(((IScatterGraphOptionsModel)this.getModel()).isAutomaticallyAssigned());
                manualButton = new Button(assignComp, 16);
                manualButton.setText(Messages.ScatterGraphOptionsPage_labelManually);
                manualButton.setSelection(!((IScatterGraphOptionsModel)this.getModel()).isAutomaticallyAssigned());
                gridPlaceHolder = new Label(assignComp, 0);
                gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                gridPlaceHolder.setVisible(false);
            }
            final StackLayout markersStackLayout = new StackLayout();
            final Composite stackComposite = new Composite(parent, 0);
            data = new GridData(4, 0x1000000, true, false);
            data.horizontalSpan = 3;
            stackComposite.setLayoutData((Object)data);
            stackComposite.setLayout((Layout)markersStackLayout);
            final Composite automaticComposite = new Composite(stackComposite, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            automaticComposite.setLayout((Layout)layout);
            label = new Label(automaticComposite, 16384);
            label.setText(Messages.ScatterGraphOptionsPage_labelMarkerType);
            data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._typeValues = new Text(automaticComposite, 2052);
            this._typeValues.setEditable(false);
            data = new GridData(4, 0x1000000, true, false);
            this._typeValues.setLayoutData((Object)data);
            this._typeButton = new Button(automaticComposite, 8);
            this._typeButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
            this._typeButton.setToolTipText(Messages.GraphOptionsPage_addAttributeToolTip);
            data = new GridData(4, 0x1000000, false, false);
            this._typeButton.setLayoutData((Object)data);
            label = new Label(automaticComposite, 16384);
            label.setText(Messages.ScatterGraphOptionsPage_labelMarkerTooltips);
            data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._tooltipValuesA = new Text(automaticComposite, 2052);
            this._tooltipValuesA.setEditable(false);
            data = new GridData(4, 0x1000000, true, false);
            this._tooltipValuesA.setLayoutData((Object)data);
            this._tooltipButtonA = new Button(automaticComposite, 8);
            this._tooltipButtonA.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
            this._tooltipButtonA.setToolTipText(Messages.GraphOptionsPage_addAttributeToolTip);
            data = new GridData(4, 0x1000000, false, false);
            this._tooltipButtonA.setLayoutData((Object)data);
            final Composite manualComposite = new Composite(stackComposite, 0);
            layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            manualComposite.setLayout((Layout)layout);
            label = new Label(manualComposite, 16384);
            label.setText(Messages.ScatterGraphOptionsPage_labelMarkerColor);
            data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._colorCombo = new Combo(manualComposite, 0x800808);
            data = new GridData(4, 0x1000000, true, false);
            this._colorCombo.setLayoutData((Object)data);
            gridPlaceHolder = new Label(manualComposite, 0);
            gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            gridPlaceHolder.setVisible(false);
            label = new Label(manualComposite, 16384);
            label.setText(Messages.ScatterGraphOptionsPage_labelMarkerShape);
            data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._shapeCombo = new Combo(manualComposite, 0x800808);
            data = new GridData(4, 0x1000000, true, false);
            this._shapeCombo.setLayoutData((Object)data);
            gridPlaceHolder = new Label(manualComposite, 0);
            gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            gridPlaceHolder.setVisible(false);
            label = new Label(manualComposite, 16384);
            label.setText(Messages.ScatterGraphOptionsPage_labelMarkerTooltips);
            data = new GridData(16384, 0x1000000, false, false);
            label.setLayoutData((Object)data);
            this._tooltipValuesM = new Text(manualComposite, 2052);
            this._tooltipValuesM.setEditable(false);
            data = new GridData(4, 0x1000000, true, false);
            this._tooltipValuesM.setLayoutData((Object)data);
            this._tooltipButtonM = new Button(manualComposite, 8);
            this._tooltipButtonM.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
            this._tooltipButtonM.setToolTipText(Messages.GraphOptionsPage_addAttributeToolTip);
            data = new GridData(4, 0x1000000, false, false);
            this._tooltipButtonM.setLayoutData((Object)data);
            markersStackLayout.topControl = ((IScatterGraphOptionsModel)this.getModel()).isAutomaticallyAssigned() ? automaticComposite : manualComposite;
            if (automaticButton != null && manualButton != null) {
                automaticButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (automaticButton.getSelection()) {
                            ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setAutomaticallyAssigned(true);
                            ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setSeriesItemContexts(null);
                            ScatterSubtypeAttrComposite.this._colorCombo.deselectAll();
                            ScatterSubtypeAttrComposite.this._shapeCombo.deselectAll();
                            ScatterSubtypeAttrComposite.this.setEdgeValuesText(ScatterSubtypeAttrComposite.this._typeValues, ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).getMarkerTypes());
                            markersStackLayout.topControl = automaticComposite;
                            stackComposite.layout();
                            ScatterSubtypeAttrComposite.this.firePropertyChange();
                        }
                    }
                });
                manualButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        if (manualButton.getSelection()) {
                            ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setAutomaticallyAssigned(false);
                            ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setSeriesItemContexts(null);
                            markersStackLayout.topControl = manualComposite;
                            stackComposite.layout();
                            ScatterSubtypeAttrComposite.this.firePropertyChange();
                        }
                    }
                });
            }
        }

        private void populateCombos() {
            for (EdgeItemContext item : ((IScatterGraphOptionsModel)this.getModel()).getAllEdgeItemContexts()) {
                if (item.isNumeric()) {
                    this._numericEdgeItemNames.add(item.getName());
                }
                this._colorAndShapeValueNames.add(item.getName());
            }
            String[] numericItemArray = this._numericEdgeItemNames.toArray(new String[this._numericEdgeItemNames.size()]);
            String[] colorAndShapeItemArray = this._colorAndShapeValueNames.toArray(new String[this._colorAndShapeValueNames.size()]);
            this._xAxisCombo.setItems(numericItemArray);
            this._yAxisCombo.setItems(numericItemArray);
            this._colorCombo.setItems(colorAndShapeItemArray);
            this._shapeCombo.setItems(colorAndShapeItemArray);
        }

        private void updateWidgets() {
            this._xAxisCombo.deselectAll();
            this._yAxisCombo.deselectAll();
            this._colorCombo.deselectAll();
            this._shapeCombo.deselectAll();
            if (((IScatterGraphOptionsModel)this.getModel()).getXAxisDataPoint() != null) {
                this._xAxisCombo.setText(((IScatterGraphOptionsModel)this.getModel()).getXAxisDataPoint().getName());
            }
            if (((IScatterGraphOptionsModel)this.getModel()).getYAxisDataPoint() != null) {
                this._yAxisCombo.setText(((IScatterGraphOptionsModel)this.getModel()).getYAxisDataPoint().getName());
            }
            this.setEdgeValuesText(this._typeValues, ((IScatterGraphOptionsModel)this.getModel()).getMarkerTypes());
            if (((IScatterGraphOptionsModel)this.getModel()).getMarkerColor() != null) {
                this._colorCombo.setText(((IScatterGraphOptionsModel)this.getModel()).getMarkerColor().getName());
            }
            if (((IScatterGraphOptionsModel)this.getModel()).getMarkerShape() != null) {
                this._shapeCombo.setText(((IScatterGraphOptionsModel)this.getModel()).getMarkerShape().getName());
            }
            this.setEdgeValuesText(this._tooltipValuesA, ((IScatterGraphOptionsModel)this.getModel()).getMarkerTooltips());
            this.setEdgeValuesText(this._tooltipValuesM, ((IScatterGraphOptionsModel)this.getModel()).getMarkerTooltips());
        }

        private void setEdgeValuesText(Text textControl, List<EdgeItemContext> selectedItems) {
            if (textControl == null) {
                return;
            }
            StringBuilder edgeValues = new StringBuilder();
            if (selectedItems != null) {
                int i = 0;
                for (EdgeItemContext item : selectedItems) {
                    edgeValues.append(item.getName());
                    if (i < selectedItems.size() - 1) {
                        edgeValues.append(", ");
                    }
                    ++i;
                }
            }
            textControl.setText(edgeValues.toString());
        }

        private void addListeners() {
            this._xAxisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EdgeItemContext value = ScatterSubtypeAttrComposite.this.getComboSelection(ScatterSubtypeAttrComposite.this._xAxisCombo, ScatterSubtypeAttrComposite.this._numericEdgeItemNames);
                    if (value != null) {
                        value.setDataItem(true);
                        value.setTreatAsText(false);
                        ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setXAxisDataPoint(value);
                        ScatterSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            });
            this._yAxisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EdgeItemContext value = ScatterSubtypeAttrComposite.this.getComboSelection(ScatterSubtypeAttrComposite.this._yAxisCombo, ScatterSubtypeAttrComposite.this._numericEdgeItemNames);
                    if (value != null) {
                        value.setDataItem(true);
                        value.setTreatAsText(false);
                        ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setYAxisDataPoint(value);
                        ScatterSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            });
            this._colorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EdgeItemContext value = ScatterSubtypeAttrComposite.this.getComboSelection(ScatterSubtypeAttrComposite.this._colorCombo, ScatterSubtypeAttrComposite.this._colorAndShapeValueNames);
                    if (value != null) {
                        value.setDataItem(false);
                        value.setTreatAsText(value.isNumeric());
                        ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setMarkerColor(value);
                        ScatterSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            });
            this._shapeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EdgeItemContext value = ScatterSubtypeAttrComposite.this.getComboSelection(ScatterSubtypeAttrComposite.this._shapeCombo, ScatterSubtypeAttrComposite.this._colorAndShapeValueNames);
                    if (value != null) {
                        value.setDataItem(false);
                        value.setTreatAsText(value.isNumeric());
                        ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setMarkerShape(value);
                        ScatterSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            });
            this._typeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ListShuttleDialog dialog = new ListShuttleDialog(e.display.getActiveShell());
                    dialog.setTitle(Messages.GraphOptionsSelectAttributeDialog_title);
                    dialog.setAvailableItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                    dialog.setAvailableItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.AvailableAttrsLabelProvider());
                    dialog.setAllItemsInput(ScatterSubtypeAttrComposite.this.getAvailableSeriesItemContexts());
                    dialog.setSelectedItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                    dialog.setSelectedItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.SelectedAttrsLabelProvider(false));
                    dialog.setInitiallySelectedItemsInput(((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).getMarkerTypes());
                    if (dialog.open() == 0) {
                        List selectedItems = dialog.getSelectedItems();
                        ScatterSubtypeAttrComposite.this.updateEdgeItemContexts(selectedItems, false);
                        ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setMarkerTypes(selectedItems);
                        ScatterSubtypeAttrComposite.this.setEdgeValuesText(ScatterSubtypeAttrComposite.this._typeValues, selectedItems);
                        ScatterSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            });
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ListShuttleDialog dialog = new ListShuttleDialog(e.display.getActiveShell());
                    dialog.setTitle(Messages.GraphOptionsSelectAttributeDialog_title);
                    dialog.setAvailableItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                    dialog.setAvailableItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.AvailableAttrsLabelProvider());
                    dialog.setAllItemsInput(ScatterSubtypeAttrComposite.this.getAvailableMarkerTooltip());
                    dialog.setSelectedItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                    dialog.setSelectedItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.SelectedAttrsLabelProvider(false));
                    dialog.setInitiallySelectedItemsInput(((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).getMarkerTooltips());
                    if (dialog.open() == 0) {
                        List selectedItems = dialog.getSelectedItems();
                        ScatterSubtypeAttrComposite.this.updateEdgeItemContexts(selectedItems, false);
                        ((IScatterGraphOptionsModel)ScatterSubtypeAttrComposite.this.getModel()).setMarkerTooltips(selectedItems);
                        ScatterSubtypeAttrComposite.this.setEdgeValuesText(ScatterSubtypeAttrComposite.this._tooltipValuesA, selectedItems);
                        ScatterSubtypeAttrComposite.this.setEdgeValuesText(ScatterSubtypeAttrComposite.this._tooltipValuesM, selectedItems);
                        ScatterSubtypeAttrComposite.this.firePropertyChange();
                    }
                }
            };
            this._tooltipButtonA.addSelectionListener((SelectionListener)selectionAdapter);
            this._tooltipButtonM.addSelectionListener((SelectionListener)selectionAdapter);
        }

        private EdgeItemContext getComboSelection(Combo combo, List<String> names) {
            int index;
            if (names != null && !names.isEmpty() && (index = combo.getSelectionIndex()) >= 0 && index < names.size()) {
                String name = names.get(index);
                return ((IScatterGraphOptionsModel)this.getModel()).findEdgeItemContext(name);
            }
            return null;
        }

        private List<EdgeItemContext> getAvailableSeriesItemContexts() {
            ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IScatterGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
            contexts.removeAll(((IScatterGraphOptionsModel)this.getModel()).getGroupsItemContexts());
            return contexts;
        }

        private List<EdgeItemContext> getAvailableMarkerTooltip() {
            ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IScatterGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
            contexts.removeAll(((IScatterGraphOptionsModel)this.getModel()).getSeriesItemContexts());
            if (((IScatterGraphOptionsModel)this.getModel()).getXAxisDataPoint() != null) {
                contexts.remove(((IScatterGraphOptionsModel)this.getModel()).getXAxisDataPoint());
            }
            if (((IScatterGraphOptionsModel)this.getModel()).getYAxisDataPoint() != null) {
                contexts.remove(((IScatterGraphOptionsModel)this.getModel()).getYAxisDataPoint());
            }
            return contexts;
        }

        private void updateEdgeItemContexts(List<EdgeItemContext> selectedItems, boolean setAsDataItem) {
            for (EdgeItemContext context : selectedItems) {
                context.setDataItem(setAsDataItem);
                context.setTreatAsText(!setAsDataItem && context.isNumeric());
            }
        }

        @Override
        public void updateLayout() {
            this.updateWidgets();
            super.updateLayout();
        }
    }
}

