/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.util.ArrayList;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IPieGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.MultiPieGraphAttributeSelectionComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class PieGraphAttributeSelectionComposite
extends MultiPieGraphAttributeSelectionComposite {
    private Combo _groupsCombo;
    private String[] _namesOfNumericAttrs;

    public PieGraphAttributeSelectionComposite(Composite parent, int style, IPieGraphOptionsModel model) {
        super(parent, style, model);
    }

    @Override
    protected void createGroupsEdgeComposite(Composite parent) {
        Label groupsEdgeLabel = new Label(parent, 16384);
        groupsEdgeLabel.setText(this.getGroupsEdgeLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        groupsEdgeLabel.setLayoutData((Object)data);
        if (this._namesOfNumericAttrs == null) {
            this._namesOfNumericAttrs = this.updateItemsForCombo();
        }
        this._groupsCombo = new Combo(parent, 0x800808);
        this._groupsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._groupsCombo.setItems(this._namesOfNumericAttrs);
        EdgeItemContext groupsItem = this.getGroupsDataItemContext();
        if (groupsItem != null) {
            this._groupsCombo.setText(groupsItem.getName());
        }
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    @Override
    protected String getGroupsEdgeLabelText() {
        return Messages.PieGraphOptionsPage_pieGroupsEdgeLabel;
    }

    protected String[] updateItemsForCombo() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IPieGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IPieGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        ArrayList<String> names = new ArrayList<String>();
        for (EdgeItemContext item : contexts) {
            if (!item.isNumeric()) continue;
            names.add(item.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    protected EdgeItemContext getGroupsDataItemContext() {
        for (EdgeItemContext context : ((IPieGraphOptionsModel)this.getModel()).getGroupsItemContexts()) {
            if (!context.isNumeric() || context.isTreatAsText()) continue;
            return context;
        }
        return null;
    }

    @Override
    protected void addDataChangeOptions(Composite parent) {
    }

    @Override
    protected void addListeners() {
        this.addGroupsComboListener();
        this.addSeriesButtonListener();
    }

    private void addGroupsComboListener() {
        this._groupsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PieGraphAttributeSelectionComposite.this._namesOfNumericAttrs != null && PieGraphAttributeSelectionComposite.this._namesOfNumericAttrs.length > 0) {
                    String name = PieGraphAttributeSelectionComposite.this._namesOfNumericAttrs[PieGraphAttributeSelectionComposite.this._groupsCombo.getSelectionIndex()];
                    EdgeItemContext item = ((IPieGraphOptionsModel)PieGraphAttributeSelectionComposite.this.getModel()).findEdgeItemContext(name);
                    if (item != null) {
                        PieGraphAttributeSelectionComposite.this.updateGroupsDataItemContext(item);
                        PieGraphAttributeSelectionComposite.this.firePropertyChangeNoComboItemUpdate();
                    }
                }
            }
        });
    }

    protected void updateGroupsDataItemContext(EdgeItemContext item) {
        if (item == null || !item.isNumeric()) {
            return;
        }
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>();
        item.setDataItem(true);
        item.setTreatAsText(false);
        contexts.add(item);
        ((IPieGraphOptionsModel)this.getModel()).setGroupsItemContexts(contexts);
    }

    @Override
    public void updateLayout() {
        this._namesOfNumericAttrs = this.updateItemsForCombo();
        this._groupsCombo.setItems(this._namesOfNumericAttrs);
        EdgeItemContext groupsItem = this.getGroupsDataItemContext();
        if (groupsItem != null) {
            this._groupsCombo.setText(groupsItem.getName());
        }
        super.updateLayout();
    }

    @Override
    protected void firePropertyChange() {
        this._namesOfNumericAttrs = this.updateItemsForCombo();
        this._groupsCombo.setItems(this._namesOfNumericAttrs);
        EdgeItemContext groupsItem = this.getGroupsDataItemContext();
        if (groupsItem != null) {
            this._groupsCombo.setText(groupsItem.getName());
        }
        super.firePropertyChange();
    }

    private void firePropertyChangeNoComboItemUpdate() {
        super.firePropertyChange();
    }
}

