/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AttributeSelectionComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class FunnelGraphAttributeSelectionComposite
extends AttributeSelectionComposite<IGraphOptionsModel> {
    private Combo _actualValueCombo;
    private Combo _targetValueCombo;
    private Combo _sectionCombo;
    private String[] seriesItems;
    private String[] _groupsItemsNames;
    EdgeItemContext _actualValueItem = null;
    EdgeItemContext _targetValueItem = null;

    public FunnelGraphAttributeSelectionComposite(Composite parent, int style, IGraphOptionsModel model) {
        super(parent, style, model);
    }

    @Override
    protected String getSwapButtonText() {
        return null;
    }

    @Override
    protected void addDataChangeOptions(Composite parent) {
    }

    @Override
    protected void addSwapButtonListener() {
    }

    @Override
    protected void createSeriesEdgeComposite(Composite parent) {
        List<EdgeItemContext> items = ((IGraphOptionsModel)this.getModel()).getSeriesItemContexts();
        if (items.size() == 2) {
            this._actualValueItem = items.get(0);
            this._targetValueItem = items.get(1);
        }
        this.seriesItems = this.getSeriesItemsNames();
        Label actualValueLabel = new Label(parent, 16384);
        actualValueLabel.setText(Messages.FunnelGraphOptionsPage_seriesEdgeLabelActual);
        GridData data = new GridData(16384, 0x1000000, false, false);
        actualValueLabel.setLayoutData((Object)data);
        this._actualValueCombo = new Combo(parent, 0x800808);
        this._actualValueCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._actualValueCombo.setItems(this.seriesItems);
        if (this._actualValueItem != null) {
            this._actualValueCombo.setText(this._actualValueItem.getName());
        }
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label targetValueLabel = new Label(parent, 16384);
        targetValueLabel.setText(Messages.FunnelGraphOptionsPage_seriesEdgeLabelTarget);
        data = new GridData(16384, 0x1000000, false, false);
        targetValueLabel.setLayoutData((Object)data);
        this._targetValueCombo = new Combo(parent, 0x800808);
        this._targetValueCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._targetValueCombo.setItems(this.seriesItems);
        if (this._targetValueItem != null) {
            this._targetValueCombo.setText(this._targetValueItem.getName());
        }
        label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    @Override
    protected void createGroupsEdgeComposite(Composite parent) {
        this._groupsItemsNames = this.getGroupsItemsNames();
        Label groupsEdgeLabel = new Label(parent, 16384);
        groupsEdgeLabel.setText(this.getGroupsEdgeLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        groupsEdgeLabel.setLayoutData((Object)data);
        this._sectionCombo = new Combo(parent, 0x800808);
        this._sectionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._sectionCombo.setItems(this._groupsItemsNames);
        EdgeItemContext groupsItem = this.getGroupsItemContext();
        if (groupsItem != null) {
            this._sectionCombo.setText(groupsItem.getName());
        }
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    @Override
    protected String getSeriesEdgeLabelText() {
        return null;
    }

    @Override
    protected String getGroupsEdgeLabelText() {
        return Messages.FunnelGraphOptionsPage_groupsEdgeLabel;
    }

    private EdgeItemContext getActualValueComboSelection() {
        int index;
        if (this.seriesItems != null && this.seriesItems.length > 0 && (index = this._actualValueCombo.getSelectionIndex()) >= 0 && index < this.seriesItems.length) {
            String name = this.seriesItems[index];
            return ((IGraphOptionsModel)this.getModel()).findEdgeItemContext(name);
        }
        return null;
    }

    private EdgeItemContext getTargetValueComboSelection() {
        int index;
        if (this.seriesItems != null && this.seriesItems.length > 0 && (index = this._targetValueCombo.getSelectionIndex()) >= 0 && index < this.seriesItems.length) {
            String name = this.seriesItems[index];
            return ((IGraphOptionsModel)this.getModel()).findEdgeItemContext(name);
        }
        return null;
    }

    private EdgeItemContext getFunnelSectionComboSelection() {
        int index;
        if (this._groupsItemsNames != null && this._groupsItemsNames.length > 0 && (index = this._sectionCombo.getSelectionIndex()) >= 0 && index < this._groupsItemsNames.length) {
            String name = this._groupsItemsNames[index];
            return ((IGraphOptionsModel)this.getModel()).findEdgeItemContext(name);
        }
        return null;
    }

    private String[] getSeriesItemsNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (EdgeItemContext item : ((IGraphOptionsModel)this.getModel()).getAllEdgeItemContexts()) {
            if (!item.isNumeric()) continue;
            names.add(item.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getGroupsItemsNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (EdgeItemContext item : ((IGraphOptionsModel)this.getModel()).getAllEdgeItemContexts()) {
            if (item.isNumeric()) continue;
            names.add(item.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    private EdgeItemContext getGroupsItemContext() {
        List<EdgeItemContext> items = ((IGraphOptionsModel)this.getModel()).getGroupsItemContexts();
        return items.size() == 1 ? items.get(0) : null;
    }

    @Override
    protected void addListeners() {
        this.addSeriesComboListeners();
        this.addGroupsComboListener();
    }

    private void addSeriesComboListeners() {
        this._actualValueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunnelGraphAttributeSelectionComposite.this._actualValueItem = FunnelGraphAttributeSelectionComposite.this.getActualValueComboSelection();
                FunnelGraphAttributeSelectionComposite.this.updateSeriesItemContexts(FunnelGraphAttributeSelectionComposite.this._actualValueItem, FunnelGraphAttributeSelectionComposite.this._targetValueItem);
                FunnelGraphAttributeSelectionComposite.this.firePropertyChange();
            }
        });
        this._targetValueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunnelGraphAttributeSelectionComposite.this._targetValueItem = FunnelGraphAttributeSelectionComposite.this.getTargetValueComboSelection();
                FunnelGraphAttributeSelectionComposite.this.updateSeriesItemContexts(FunnelGraphAttributeSelectionComposite.this._actualValueItem, FunnelGraphAttributeSelectionComposite.this._targetValueItem);
                FunnelGraphAttributeSelectionComposite.this.firePropertyChange();
            }
        });
    }

    private void addGroupsComboListener() {
        this._sectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EdgeItemContext item = FunnelGraphAttributeSelectionComposite.this.getFunnelSectionComboSelection();
                if (item != null) {
                    item.setDataItem(false);
                    ArrayList<EdgeItemContext> items = new ArrayList<EdgeItemContext>();
                    items.add(item);
                    ((IGraphOptionsModel)FunnelGraphAttributeSelectionComposite.this.getModel()).setGroupsItemContexts(items);
                    FunnelGraphAttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
    }

    private void updateSeriesItemContexts(EdgeItemContext actualValueItem, EdgeItemContext targetValueItem) {
        ArrayList<EdgeItemContext> items = new ArrayList<EdgeItemContext>();
        if (actualValueItem != null) {
            actualValueItem.setDataItem(true);
            items.add(actualValueItem);
        }
        if (targetValueItem != null) {
            targetValueItem.setDataItem(true);
            items.add(targetValueItem);
        }
        ((IGraphOptionsModel)this.getModel()).setSeriesItemContexts(items);
    }

    @Override
    public void updateLayout() {
    }
}

