/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IBubbleGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph.AttributeSelectionComposite;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.ui.dialogs.ListShuttleDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BubbleGraphAttributeSelectionComposite
extends ModelChangeComposite<IBubbleGraphOptionsModel> {
    private Combo _xAxisCombo;
    private Combo _yAxisCombo;
    private Combo _sizeCombo;
    private final List<String> _seriesItemNames = new ArrayList<String>();
    private Text _colorValues;
    private Text _tooltipValues;
    private Button _colorButton;
    private Button _tooltipButton;

    public BubbleGraphAttributeSelectionComposite(Composite parent, int style, IGraphOptionsModel model) {
        super(parent, style, (IBubbleGraphOptionsModel)model);
        this.setFont(parent.getFont());
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createEdgesComposite(this);
        this.populateCombos();
        this.addListeners();
    }

    private void createEdgesComposite(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(Messages.GraphOptionsPage_xAxisDataPointLabel);
        GridData data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this._xAxisCombo = new Combo(parent, 0x800808);
        data = new GridData(4, 0x1000000, true, false);
        this._xAxisCombo.setLayoutData((Object)data);
        Label gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.GraphOptionsPage_yAxisDataPointLabel);
        data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this._yAxisCombo = new Combo(parent, 0x800808);
        data = new GridData(4, 0x1000000, true, false);
        this._yAxisCombo.setLayoutData((Object)data);
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.BubbleGraphOptionsPage_labelSize);
        data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this._sizeCombo = new Combo(parent, 0x800808);
        data = new GridData(4, 0x1000000, true, false);
        this._sizeCombo.setLayoutData((Object)data);
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.BubbleGraphOptionsPage_labelColors);
        data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this._colorValues = new Text(parent, 2052);
        this._colorValues.setEditable(false);
        data = new GridData(4, 0x1000000, true, false);
        this._colorValues.setLayoutData((Object)data);
        this._colorButton = new Button(parent, 8);
        this._colorButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this._colorButton.setToolTipText(Messages.GraphOptionsPage_addAttributeToolTip);
        data = new GridData(4, 0x1000000, false, false);
        this._colorButton.setLayoutData((Object)data);
        label = new Label(parent, 16384);
        label.setText(Messages.BubbleGraphOptionsPage_labelTooltips);
        data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this._tooltipValues = new Text(parent, 2052);
        this._tooltipValues.setEditable(false);
        data = new GridData(4, 0x1000000, true, false);
        this._tooltipValues.setLayoutData((Object)data);
        this._tooltipButton = new Button(parent, 8);
        this._tooltipButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this._tooltipButton.setToolTipText(Messages.GraphOptionsPage_addAttributeToolTip);
        data = new GridData(4, 0x1000000, false, false);
        this._tooltipButton.setLayoutData((Object)data);
    }

    private void populateCombos() {
        for (EdgeItemContext item : ((IBubbleGraphOptionsModel)this.getModel()).getAllEdgeItemContexts()) {
            if (!item.isNumeric()) continue;
            this._seriesItemNames.add(item.getName());
        }
        String[] seriesItems = this._seriesItemNames.toArray(new String[this._seriesItemNames.size()]);
        this._xAxisCombo.setItems(seriesItems);
        this._yAxisCombo.setItems(seriesItems);
        this._sizeCombo.setItems(seriesItems);
    }

    private void updateWidgets() {
        this._xAxisCombo.deselectAll();
        this._yAxisCombo.deselectAll();
        this._sizeCombo.deselectAll();
        if (((IBubbleGraphOptionsModel)this.getModel()).getXAxisDataPoint() != null) {
            this._xAxisCombo.setText(((IBubbleGraphOptionsModel)this.getModel()).getXAxisDataPoint().getName());
        }
        if (((IBubbleGraphOptionsModel)this.getModel()).getYAxisDataPoint() != null) {
            this._yAxisCombo.setText(((IBubbleGraphOptionsModel)this.getModel()).getYAxisDataPoint().getName());
        }
        if (((IBubbleGraphOptionsModel)this.getModel()).getSize() != null) {
            this._sizeCombo.setText(((IBubbleGraphOptionsModel)this.getModel()).getSize().getName());
        }
        this.setEdgeValuesText(this._colorValues, ((IBubbleGraphOptionsModel)this.getModel()).getColors());
        this.setEdgeValuesText(this._tooltipValues, ((IBubbleGraphOptionsModel)this.getModel()).getTooltips());
    }

    private void setEdgeValuesText(Text textControl, List<EdgeItemContext> selectedItems) {
        if (textControl == null) {
            return;
        }
        StringBuilder edgeValues = new StringBuilder();
        if (selectedItems != null) {
            int i = 0;
            for (EdgeItemContext item : selectedItems) {
                edgeValues.append(item.getName());
                if (i < selectedItems.size() - 1) {
                    edgeValues.append(", ");
                }
                ++i;
            }
        }
        textControl.setText(edgeValues.toString());
    }

    private void addListeners() {
        this._xAxisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EdgeItemContext value = BubbleGraphAttributeSelectionComposite.this.getComboSelection(BubbleGraphAttributeSelectionComposite.this._xAxisCombo, BubbleGraphAttributeSelectionComposite.this._seriesItemNames);
                if (value != null) {
                    value.setDataItem(true);
                    value.setTreatAsText(false);
                    ((IBubbleGraphOptionsModel)BubbleGraphAttributeSelectionComposite.this.getModel()).setXAxisDataPoint(value);
                    BubbleGraphAttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
        this._yAxisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EdgeItemContext value = BubbleGraphAttributeSelectionComposite.this.getComboSelection(BubbleGraphAttributeSelectionComposite.this._yAxisCombo, BubbleGraphAttributeSelectionComposite.this._seriesItemNames);
                if (value != null) {
                    value.setDataItem(true);
                    value.setTreatAsText(false);
                    ((IBubbleGraphOptionsModel)BubbleGraphAttributeSelectionComposite.this.getModel()).setYAxisDataPoint(value);
                    BubbleGraphAttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
        this._sizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EdgeItemContext value = BubbleGraphAttributeSelectionComposite.this.getComboSelection(BubbleGraphAttributeSelectionComposite.this._sizeCombo, BubbleGraphAttributeSelectionComposite.this._seriesItemNames);
                if (value != null) {
                    value.setDataItem(true);
                    value.setTreatAsText(false);
                    ((IBubbleGraphOptionsModel)BubbleGraphAttributeSelectionComposite.this.getModel()).setSize(value);
                    BubbleGraphAttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
        this._colorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog dialog = new ListShuttleDialog(e.display.getActiveShell());
                dialog.setTitle(Messages.GraphOptionsSelectAttributeDialog_title);
                dialog.setAvailableItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                dialog.setAvailableItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.AvailableAttrsLabelProvider());
                dialog.setAllItemsInput(BubbleGraphAttributeSelectionComposite.this.getAvailableSeriesItemContexts());
                dialog.setSelectedItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                dialog.setSelectedItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.SelectedAttrsLabelProvider(false));
                dialog.setInitiallySelectedItemsInput(((IBubbleGraphOptionsModel)BubbleGraphAttributeSelectionComposite.this.getModel()).getColors());
                if (dialog.open() == 0) {
                    List selectedItems = dialog.getSelectedItems();
                    BubbleGraphAttributeSelectionComposite.this.updateEdgeItemContexts(selectedItems, false);
                    ((IBubbleGraphOptionsModel)BubbleGraphAttributeSelectionComposite.this.getModel()).setColors(selectedItems);
                    BubbleGraphAttributeSelectionComposite.this.setEdgeValuesText(BubbleGraphAttributeSelectionComposite.this._colorValues, selectedItems);
                    BubbleGraphAttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
        this._tooltipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog dialog = new ListShuttleDialog(e.display.getActiveShell());
                dialog.setTitle(Messages.GraphOptionsSelectAttributeDialog_title);
                dialog.setAvailableItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                dialog.setAvailableItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.AvailableAttrsLabelProvider());
                dialog.setAllItemsInput(BubbleGraphAttributeSelectionComposite.this.getAvailableTooltip());
                dialog.setSelectedItemsContentProvider((IStructuredContentProvider)new AttributeSelectionComposite.EdgeItemContextContentProvider());
                dialog.setSelectedItemsLabelProvider((ILabelProvider)new AttributeSelectionComposite.SelectedAttrsLabelProvider(false));
                dialog.setInitiallySelectedItemsInput(((IBubbleGraphOptionsModel)BubbleGraphAttributeSelectionComposite.this.getModel()).getTooltips());
                if (dialog.open() == 0) {
                    List selectedItems = dialog.getSelectedItems();
                    BubbleGraphAttributeSelectionComposite.this.updateEdgeItemContexts(selectedItems, false);
                    ((IBubbleGraphOptionsModel)BubbleGraphAttributeSelectionComposite.this.getModel()).setTooltips(selectedItems);
                    BubbleGraphAttributeSelectionComposite.this.setEdgeValuesText(BubbleGraphAttributeSelectionComposite.this._tooltipValues, selectedItems);
                    BubbleGraphAttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
    }

    private EdgeItemContext getComboSelection(Combo combo, List<String> names) {
        int index;
        if (names != null && !names.isEmpty() && (index = combo.getSelectionIndex()) >= 0 && index < names.size()) {
            String name = names.get(index);
            return ((IBubbleGraphOptionsModel)this.getModel()).findEdgeItemContext(name);
        }
        return null;
    }

    private List<EdgeItemContext> getAvailableSeriesItemContexts() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IBubbleGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IBubbleGraphOptionsModel)this.getModel()).getGroupsItemContexts());
        return contexts;
    }

    private List<EdgeItemContext> getAvailableTooltip() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IBubbleGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IBubbleGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        if (((IBubbleGraphOptionsModel)this.getModel()).getXAxisDataPoint() != null) {
            contexts.remove(((IBubbleGraphOptionsModel)this.getModel()).getXAxisDataPoint());
        }
        if (((IBubbleGraphOptionsModel)this.getModel()).getYAxisDataPoint() != null) {
            contexts.remove(((IBubbleGraphOptionsModel)this.getModel()).getYAxisDataPoint());
        }
        if (((IBubbleGraphOptionsModel)this.getModel()).getSize() != null) {
            contexts.remove(((IBubbleGraphOptionsModel)this.getModel()).getSize());
        }
        return contexts;
    }

    private void updateEdgeItemContexts(List<EdgeItemContext> selectedItems, boolean setAsDataItem) {
        for (EdgeItemContext context : selectedItems) {
            context.setDataItem(setAsDataItem);
            context.setTreatAsText(!setAsDataItem && context.isNumeric());
        }
    }

    @Override
    public void updateLayout() {
        this.updateWidgets();
        super.updateLayout();
    }
}

