/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGraphOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.ui.dialogs.ListShuttleDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AttributeSelectionComposite<O extends IGraphOptionsModel>
extends ModelChangeComposite<O> {
    private Text _seriesEdgeValues;
    private Text _groupsEdgeValues;
    private Button _seriesButton;
    private Button _groupsButton;
    private Button _swapButton;

    public AttributeSelectionComposite(Composite parent, int style, O model) {
        super(parent, style, model);
        this.setFont(parent.getFont());
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createEdgesComposite(this);
        this.addDataChangeOptions(this);
        this.addListeners();
    }

    protected void createEdgesComposite(Composite parent) {
        Composite edgesComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        edgesComposite.setLayout((Layout)layout);
        this.createSeriesEdgeComposite(edgesComposite);
        this.createGroupsEdgeComposite(edgesComposite);
        GridData gd = new GridData(4, 4, true, false);
        edgesComposite.setLayoutData((Object)gd);
    }

    protected void createSeriesEdgeComposite(Composite parent) {
        Label seriesEdgeLabel = new Label(parent, 16384);
        seriesEdgeLabel.setText(this.getSeriesEdgeLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        seriesEdgeLabel.setLayoutData((Object)data);
        this._seriesEdgeValues = new Text(parent, 2052);
        this.setEdgeValuesText(this._seriesEdgeValues, ((IGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        this._seriesEdgeValues.setEditable(false);
        data = new GridData(4, 0x1000000, true, false);
        this._seriesEdgeValues.setLayoutData((Object)data);
        this._seriesButton = new Button(parent, 8);
        this._seriesButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this._seriesButton.setToolTipText(this.getSeriesEdgeToolTipText());
        data = new GridData(4, 0x1000000, false, false);
        this._seriesButton.setLayoutData((Object)data);
    }

    protected void createGroupsEdgeComposite(Composite parent) {
        Label groupsEdgeLabel = new Label(parent, 16384);
        groupsEdgeLabel.setText(this.getGroupsEdgeLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        groupsEdgeLabel.setLayoutData((Object)data);
        this._groupsEdgeValues = new Text(parent, 2052);
        this.setEdgeValuesText(this._groupsEdgeValues, ((IGraphOptionsModel)this.getModel()).getGroupsItemContexts());
        this._groupsEdgeValues.setEditable(false);
        data = new GridData(4, 0x1000000, true, false);
        this._groupsEdgeValues.setLayoutData((Object)data);
        this._groupsButton = new Button(parent, 8);
        this._groupsButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        this._groupsButton.setToolTipText(this.getGroupEdgeToolTipText());
        data = new GridData(4, 0x1000000, false, false);
        this._groupsButton.setLayoutData((Object)data);
    }

    protected abstract String getSeriesEdgeLabelText();

    protected String getSeriesEdgeToolTipText() {
        return Messages.GraphOptionsPage_addAttributeToolTip;
    }

    protected abstract String getGroupsEdgeLabelText();

    protected String getGroupEdgeToolTipText() {
        return Messages.GraphOptionsPage_addAttributeToolTip;
    }

    protected abstract String getSwapButtonText();

    protected void setEdgeValuesText(Text textControl, List<EdgeItemContext> selectedItems) {
        if (textControl == null) {
            return;
        }
        StringBuilder edgeValues = new StringBuilder();
        if (selectedItems != null) {
            int i = 0;
            for (EdgeItemContext item : selectedItems) {
                edgeValues.append(item.getName());
                if (i < selectedItems.size() - 1) {
                    edgeValues.append(", ");
                }
                ++i;
            }
        }
        textControl.setText(edgeValues.toString());
    }

    protected void addDataChangeOptions(Composite parent) {
        this._swapButton = new Button(parent, 8);
        this._swapButton.setText(this.getSwapButtonText());
        GridData data = new GridData(131072, 0x1000000, false, false);
        this._swapButton.setLayoutData((Object)data);
    }

    protected void addListeners() {
        this.addSeriesButtonListener();
        this.addGroupsButtonListener();
        this.addSwapButtonListener();
    }

    protected void addSeriesButtonListener() {
        this._seriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog dialog = new ListShuttleDialog(e.display.getActiveShell());
                dialog.setTitle(Messages.GraphOptionsSelectAttributeDialog_title);
                dialog.setAvailableItemsContentProvider((IStructuredContentProvider)new EdgeItemContextContentProvider());
                dialog.setAvailableItemsLabelProvider((ILabelProvider)new AvailableAttrsLabelProvider());
                dialog.setAllItemsInput(AttributeSelectionComposite.this.getAvailableSeriesItemContexts());
                dialog.setSelectedItemsContentProvider((IStructuredContentProvider)new EdgeItemContextContentProvider());
                dialog.setSelectedItemsLabelProvider((ILabelProvider)new SelectedAttrsLabelProvider(((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).isDataOnSeries()));
                dialog.setInitiallySelectedItemsInput(((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).getSeriesItemContexts());
                if (dialog.open() == 0) {
                    List selectedItems = dialog.getSelectedItems();
                    AttributeSelectionComposite.this.updateEdgeItemContexts(selectedItems, ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).isDataOnSeries());
                    ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).setSeriesItemContexts(selectedItems);
                    AttributeSelectionComposite.this.setEdgeValuesText(AttributeSelectionComposite.this._seriesEdgeValues, selectedItems);
                    AttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
    }

    protected void addGroupsButtonListener() {
        this._groupsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog dialog = new ListShuttleDialog(e.display.getActiveShell());
                dialog.setTitle(Messages.GraphOptionsSelectAttributeDialog_title);
                dialog.setAvailableItemsContentProvider((IStructuredContentProvider)new EdgeItemContextContentProvider());
                dialog.setAvailableItemsLabelProvider((ILabelProvider)new AvailableAttrsLabelProvider());
                dialog.setAllItemsInput(AttributeSelectionComposite.this.getAvailableGroupsItemContexts());
                dialog.setSelectedItemsContentProvider((IStructuredContentProvider)new EdgeItemContextContentProvider());
                dialog.setSelectedItemsLabelProvider((ILabelProvider)new SelectedAttrsLabelProvider(!((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).isDataOnSeries()));
                dialog.setInitiallySelectedItemsInput(((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).getGroupsItemContexts());
                if (dialog.open() == 0) {
                    List selectedItems = dialog.getSelectedItems();
                    AttributeSelectionComposite.this.updateEdgeItemContexts(selectedItems, !((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).isDataOnSeries());
                    ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).setGroupsItemContexts(selectedItems);
                    AttributeSelectionComposite.this.setEdgeValuesText(AttributeSelectionComposite.this._groupsEdgeValues, selectedItems);
                    AttributeSelectionComposite.this.firePropertyChange();
                }
            }
        });
    }

    protected void addSwapButtonListener() {
        this._swapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<EdgeItemContext> temp = new ArrayList<EdgeItemContext>(((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).getSeriesItemContexts());
                ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).setSeriesItemContexts(((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).getGroupsItemContexts());
                ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).setGroupsItemContexts(temp);
                ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).setDataOnSeries(!((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).isDataOnSeries());
                AttributeSelectionComposite.this.setEdgeValuesText(AttributeSelectionComposite.this._seriesEdgeValues, ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).getSeriesItemContexts());
                AttributeSelectionComposite.this.setEdgeValuesText(AttributeSelectionComposite.this._groupsEdgeValues, ((IGraphOptionsModel)AttributeSelectionComposite.this.getModel()).getGroupsItemContexts());
                AttributeSelectionComposite.this.firePropertyChange();
            }
        });
    }

    private List<EdgeItemContext> getAvailableSeriesItemContexts() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IGraphOptionsModel)this.getModel()).getGroupsItemContexts());
        return contexts;
    }

    private List<EdgeItemContext> getAvailableGroupsItemContexts() {
        ArrayList<EdgeItemContext> contexts = new ArrayList<EdgeItemContext>(((IGraphOptionsModel)this.getModel()).getAllEdgeItemContexts());
        contexts.removeAll(((IGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        return contexts;
    }

    protected void updateEdgeItemContexts(List<EdgeItemContext> selectedItems, boolean setAsDataItem) {
        for (EdgeItemContext context : selectedItems) {
            context.setDataItem(setAsDataItem);
            context.setTreatAsText(!setAsDataItem && context.isNumeric());
        }
    }

    @Override
    public void updateLayout() {
        this.setEdgeValuesText(this._seriesEdgeValues, ((IGraphOptionsModel)this.getModel()).getSeriesItemContexts());
        this.setEdgeValuesText(this._groupsEdgeValues, ((IGraphOptionsModel)this.getModel()).getGroupsItemContexts());
        super.updateLayout();
    }

    private static Image getImageFromBundle(DTRTvCommonBundleIcon icon) {
        return (Image)ImageManager.getInstance().getImage((ImageManager.IImageData)icon);
    }

    static class AvailableAttrsLabelProvider
    extends LabelProvider {
        AvailableAttrsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof EdgeItemContext) {
                EdgeItemContext itemContext = (EdgeItemContext)element;
                if (itemContext.isNumeric()) {
                    return AttributeSelectionComposite.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_NUMBER_ICON);
                }
                return AttributeSelectionComposite.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_STRING_ICON);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof EdgeItemContext) {
                return ((EdgeItemContext)element).getName();
            }
            return null;
        }
    }

    static class EdgeItemContextContentProvider
    implements IStructuredContentProvider {
        private List<EdgeItemContext> _itemContexts;

        EdgeItemContextContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this._itemContexts = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this._itemContexts.toArray();
        }
    }

    static class SelectedAttrsLabelProvider
    extends AvailableAttrsLabelProvider {
        private final boolean _isForEdgeWithData;

        public SelectedAttrsLabelProvider(boolean isForEdgeWithData) {
            this._isForEdgeWithData = isForEdgeWithData;
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof EdgeItemContext) {
                EdgeItemContext itemContext = (EdgeItemContext)element;
                if (itemContext.isNumeric()) {
                    if (itemContext.isTreatAsText() || !this._isForEdgeWithData) {
                        return AttributeSelectionComposite.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_NUMERIC_AS_STRING);
                    }
                    return AttributeSelectionComposite.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_NUMBER_ICON);
                }
                return AttributeSelectionComposite.getImageFromBundle(DTRTvCommonBundleIcon.DATABINDING_STRING_ICON);
            }
            return null;
        }
    }
}

