/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.graph;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.EdgeItemContext;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;

public class AttributeLabelEditingSupport
extends EditingSupport {
    private CellEditor _dataItemLabelEditor;
    private CellEditor _textLabelEditor;
    private List<String> _textLabelValues;

    public AttributeLabelEditingSupport(TableViewer viewer, List<EdgeItemContext> attributes) {
        super((ColumnViewer)viewer);
        this.initNameList(attributes);
        this._dataItemLabelEditor = new MyComboBoxCellEditor((Composite)viewer.getTable(), new String[]{Messages.GraphOptionsPage_labelValueUseAttributeName, Messages.GraphOptionsPage_labelValueNoLabel}, 0x800000);
        this._textLabelEditor = new ComboBoxCellEditor((Composite)viewer.getTable(), this._textLabelValues.toArray(new String[this._textLabelValues.size()]), 8);
    }

    private void initNameList(List<EdgeItemContext> attributes) {
        this._textLabelValues = new ArrayList<String>();
        this._textLabelValues.add(Messages.GraphOptionsPage_labelValueUseAttributeValue);
        if (attributes != null) {
            ArrayList<String> numericAttrNames = new ArrayList<String>();
            for (EdgeItemContext itemContext : attributes) {
                if (itemContext.isNumeric()) {
                    numericAttrNames.add(itemContext.getName());
                    continue;
                }
                if (itemContext.isDate()) continue;
                this._textLabelValues.add(itemContext.getName());
            }
            if (!numericAttrNames.isEmpty()) {
                this._textLabelValues.addAll(numericAttrNames);
            }
        }
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        EdgeItemContext edgeItem = (EdgeItemContext)element;
        if (edgeItem.isNumeric() && !edgeItem.isTreatAsText()) {
            return this._dataItemLabelEditor;
        }
        return this._textLabelEditor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(Object element) {
        EdgeItemContext edgeItem = (EdgeItemContext)element;
        String label = edgeItem.getLabel();
        int index = 0;
        if (edgeItem.isNumeric() && !edgeItem.isTreatAsText()) {
            if (label == null) return index;
            if (!"__NO_LABEL".equals(label)) return label;
            index = 1;
            return index;
        } else {
            if (label == null) return index;
            index = this._textLabelValues.indexOf(label);
        }
        return index;
    }

    protected void setValue(Object element, Object value) {
        int index;
        EdgeItemContext edgeItem = (EdgeItemContext)element;
        String label = null;
        if (edgeItem.isNumeric() && !edgeItem.isTreatAsText()) {
            if (value instanceof Integer) {
                int index2 = (Integer)value;
                if (index2 == 1) {
                    label = "__NO_LABEL";
                }
            } else if (value instanceof String) {
                label = (String)value;
            }
        } else if (value instanceof Integer && (index = ((Integer)value).intValue()) > 0) {
            label = this._textLabelValues.get(index);
        }
        edgeItem.setLabel(label);
        this.getViewer().update(element, null);
    }

    class MyComboBoxCellEditor
    extends ComboBoxCellEditor {
        public MyComboBoxCellEditor(Composite parent, String[] items, int style) {
            super(parent, items, style);
        }

        protected void doSetValue(Object value) {
            if (value instanceof String) {
                super.doSetValue((Object)-1);
                ((CCombo)this.getControl()).setText((String)value);
            } else if (value == null) {
                super.doSetValue((Object)0);
            } else {
                super.doSetValue(value);
            }
        }

        protected Object doGetValue() {
            Object value = super.doGetValue();
            if (value instanceof Integer && (Integer)value < 0) {
                value = ((CCombo)this.getControl()).getText();
            }
            return value;
        }
    }
}

