/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeThreshold;

public class ThresholdManager {
    private static final String[] COLUMN_NAMES_LIST = new String[]{ColumnName.INDEX.toString(), ColumnName.VALUE.toString(), ColumnName.LABEL.toString(), ColumnName.COLOR.toString()};
    public static final String ADD_THRESHOLD = "Add Threshold";
    public static final String REMOVE_THRESHOLD = "Remove Threshold";
    public static final String CHANGE_THRESHOLD = "Change Threshold";
    private final PropertyChangeSupport _propChangeSupport = new PropertyChangeSupport(this);
    private final IGaugeOptionsModel _model;

    public ThresholdManager(IGaugeOptionsModel model) {
        this._model = model;
    }

    public static ColumnName getColumnName(String name) {
        return ColumnName.forName(name);
    }

    public static String[] getColumnNames() {
        return COLUMN_NAMES_LIST;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propChangeSupport.removePropertyChangeListener(listener);
    }

    public void createThreshold() {
        this._model.createGaugeThreshold(false);
        this._propChangeSupport.firePropertyChange(ADD_THRESHOLD, null, null);
    }

    public void removeThreshold(IGaugeThreshold threshold) {
        this._model.removeGaugeThreshold(threshold);
        this._propChangeSupport.firePropertyChange(REMOVE_THRESHOLD, threshold, null);
    }

    public void updateThreshold(IGaugeThreshold threshold, String oldValue) {
        this._propChangeSupport.firePropertyChange(CHANGE_THRESHOLD, oldValue, threshold);
    }

    public static enum ColumnName {
        INDEX("index"),
        VALUE("value"),
        LABEL("label"),
        COLOR("color");

        private final String _name;

        private ColumnName(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public static ColumnName forName(String name) {
            ColumnName[] columnNameArray = ColumnName.values();
            int n = columnNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnName columnName = columnNameArray[n2];
                if (columnName._name.equals(name)) {
                    return columnName;
                }
                ++n2;
            }
            return null;
        }
    }
}

